/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;

public final class LinkCollectionIntent
extends ConnectivityIntent {
    private final Set<Link> links;
    private final Set<ConnectPoint> ingressPoints;
    private final Set<ConnectPoint> egressPoints;

    private LinkCollectionIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, Set<Link> links, Set<ConnectPoint> ingressPoints, Set<ConnectPoint> egressPoints, List<Constraint> constraints, int priority) {
        super(appId, key, LinkCollectionIntent.resources(links), selector, treatment, constraints, priority);
        this.links = links;
        this.ingressPoints = ingressPoints;
        this.egressPoints = egressPoints;
    }

    protected LinkCollectionIntent() {
        this.links = null;
        this.ingressPoints = null;
        this.egressPoints = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<Link> links() {
        return this.links;
    }

    public Set<ConnectPoint> ingressPoints() {
        return this.ingressPoints;
    }

    public Set<ConnectPoint> egressPoints() {
        return this.egressPoints;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", this.id()).add("key", this.key()).add("appId", this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", this.selector()).add("treatment", this.treatment()).add("links", this.links()).add("ingress", this.ingressPoints()).add("egress", this.egressPoints()).toString();
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        Set<Link> links;
        Set<ConnectPoint> ingressPoints;
        Set<ConnectPoint> egressPoints;

        private Builder() {
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        public Builder ingressPoints(Set<ConnectPoint> ingressPoints) {
            this.ingressPoints = ImmutableSet.copyOf(ingressPoints);
            return this;
        }

        public Builder egressPoints(Set<ConnectPoint> egressPoints) {
            this.egressPoints = ImmutableSet.copyOf(egressPoints);
            return this;
        }

        public Builder links(Set<Link> links) {
            this.links = ImmutableSet.copyOf(links);
            return this;
        }

        public LinkCollectionIntent build() {
            return new LinkCollectionIntent(this.appId, this.key, this.selector, this.treatment, this.links, this.ingressPoints, this.egressPoints, this.constraints, this.priority);
        }
    }
}

