/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;

public final class MultiPointToSinglePointIntent
extends ConnectivityIntent {
    private final Set<ConnectPoint> ingressPoints;
    private final ConnectPoint egressPoint;

    private MultiPointToSinglePointIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, Set<ConnectPoint> ingressPoints, ConnectPoint egressPoint, List<Constraint> constraints, int priority) {
        super(appId, key, Collections.emptyList(), selector, treatment, constraints, priority);
        Preconditions.checkNotNull(ingressPoints);
        Preconditions.checkArgument(!ingressPoints.isEmpty(), "Ingress point set cannot be empty");
        Preconditions.checkNotNull(egressPoint);
        Preconditions.checkArgument(!ingressPoints.contains(egressPoint), "Set of ingresses should not contain egress (egress: %s)", egressPoint);
        this.ingressPoints = Sets.newHashSet(ingressPoints);
        this.egressPoint = egressPoint;
    }

    protected MultiPointToSinglePointIntent() {
        this.ingressPoints = null;
        this.egressPoint = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<ConnectPoint> ingressPoints() {
        return this.ingressPoints;
    }

    public ConnectPoint egressPoint() {
        return this.egressPoint;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", this.id()).add("key", this.key()).add("appId", this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", this.selector()).add("treatment", this.treatment()).add("ingress", this.ingressPoints()).add("egress", this.egressPoint()).add("constraints", this.constraints()).toString();
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        Set<ConnectPoint> ingressPoints;
        ConnectPoint egressPoint;

        private Builder() {
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        public Builder ingressPoints(Set<ConnectPoint> ingressPoints) {
            this.ingressPoints = ImmutableSet.copyOf(ingressPoints);
            return this;
        }

        public Builder egressPoint(ConnectPoint egressPoint) {
            this.egressPoint = egressPoint;
            return this;
        }

        public MultiPointToSinglePointIntent build() {
            return new MultiPointToSinglePointIntent(this.appId, this.key, this.selector, this.treatment, this.ingressPoints, this.egressPoint, this.constraints, this.priority);
        }
    }
}

