/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;

public final class SinglePointToMultiPointIntent
extends ConnectivityIntent {
    private final ConnectPoint ingressPoint;
    private final Set<ConnectPoint> egressPoints;

    private SinglePointToMultiPointIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, ConnectPoint ingressPoint, Set<ConnectPoint> egressPoints, List<Constraint> constraints, int priority) {
        super(appId, key, Collections.emptyList(), selector, treatment, constraints, priority);
        Preconditions.checkNotNull(egressPoints);
        Preconditions.checkNotNull(ingressPoint);
        Preconditions.checkArgument(!egressPoints.isEmpty(), "Egress point set cannot be empty");
        Preconditions.checkArgument(!egressPoints.contains(ingressPoint), "Set of egresses should not contain ingress (ingress: %s)", ingressPoint);
        this.ingressPoint = Preconditions.checkNotNull(ingressPoint);
        this.egressPoints = egressPoints;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected SinglePointToMultiPointIntent() {
        this.ingressPoint = null;
        this.egressPoints = null;
    }

    public ConnectPoint ingressPoint() {
        return this.ingressPoint;
    }

    public Set<ConnectPoint> egressPoints() {
        return this.egressPoints;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", this.id()).add("key", this.key()).add("appId", this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", this.selector()).add("treatment", this.treatment()).add("ingress", this.ingressPoint).add("egress", this.egressPoints).add("constraints", this.constraints()).toString();
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        ConnectPoint ingressPoint;
        Set<ConnectPoint> egressPoints;

        private Builder() {
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        public Builder ingressPoint(ConnectPoint ingressPoint) {
            this.ingressPoint = ingressPoint;
            return this;
        }

        public Builder egressPoints(Set<ConnectPoint> egressPoints) {
            this.egressPoints = ImmutableSet.copyOf(egressPoints);
            return this;
        }

        public SinglePointToMultiPointIntent build() {
            return new SinglePointToMultiPointIntent(this.appId, this.key, this.selector, this.treatment, this.ingressPoint, this.egressPoints, this.constraints, this.priority);
        }
    }
}

