/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.AnnotationKeys;
import org.onosproject.net.Link;
import org.onosproject.net.intent.constraint.BooleanConstraint;
import org.onosproject.net.resource.link.LinkResourceService;

public class AnnotationConstraint
extends BooleanConstraint {
    private final String key;
    private final double threshold;

    public AnnotationConstraint(String key, double threshold) {
        this.key = key;
        this.threshold = threshold;
    }

    private AnnotationConstraint() {
        this.key = "";
        this.threshold = 0.0;
    }

    public String key() {
        return this.key;
    }

    public double threshold() {
        return this.threshold;
    }

    @Override
    public boolean isValid(Link link, LinkResourceService resourceService) {
        double value = AnnotationKeys.getAnnotatedValue(link, this.key);
        return value <= this.threshold;
    }

    @Override
    public double cost(Link link, LinkResourceService resourceService) {
        if (this.isValid(link, resourceService)) {
            return AnnotationKeys.getAnnotatedValue(link, this.key);
        }
        return -1.0;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.threshold);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnnotationConstraint)) {
            return false;
        }
        AnnotationConstraint other = (AnnotationConstraint)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.threshold, other.threshold);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("key", this.key).add("threshold", this.threshold).toString();
    }
}

