/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.onosproject.net.AnnotationKeys;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.resource.link.LinkResourceService;

public class LatencyConstraint
implements Constraint {
    private final Duration latency;

    public LatencyConstraint(Duration latency) {
        this.latency = latency;
    }

    private LatencyConstraint() {
        this.latency = Duration.ZERO;
    }

    public Duration latency() {
        return this.latency;
    }

    @Override
    public double cost(Link link, LinkResourceService resourceService) {
        return AnnotationKeys.getAnnotatedValue(link, "latency");
    }

    @Override
    public boolean validate(Path path, LinkResourceService resourceService) {
        double pathLatency = path.links().stream().mapToDouble(link -> this.cost((Link)link, resourceService)).sum();
        return Duration.of((long)pathLatency, ChronoUnit.MICROS).compareTo(this.latency) <= 0;
    }

    public int hashCode() {
        return Objects.hash(this.latency);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LatencyConstraint)) {
            return false;
        }
        LatencyConstraint that = (LatencyConstraint)obj;
        return Objects.equals(this.latency, that.latency);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("latency", this.latency).toString();
    }
}

