/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.table;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.table.TableModel;
import org.onosproject.ui.table.TableUtils;

public abstract class TableRequestHandler
extends RequestHandler {
    private final String respType;
    private final String nodeName;

    public TableRequestHandler(String reqType, String respType, String nodeName) {
        super(reqType);
        this.respType = respType;
        this.nodeName = nodeName;
    }

    @Override
    public void process(long sid, ObjectNode payload) {
        TableModel tm = this.createTableModel();
        this.populateTable(tm, payload);
        String sortCol = JsonUtils.string(payload, "sortCol", this.defaultColumnId());
        String sortDir = JsonUtils.string(payload, "sortDir", "asc");
        tm.sort(sortCol, TableModel.sortDir(sortDir));
        ObjectNode rootNode = MAPPER.createObjectNode();
        rootNode.set(this.nodeName, TableUtils.generateArrayNode(tm));
        this.sendMessage(this.respType, 0L, rootNode);
    }

    protected TableModel createTableModel() {
        return new TableModel(this.getColumnIds());
    }

    protected String defaultColumnId() {
        return "id";
    }

    protected abstract String[] getColumnIds();

    protected abstract void populateTable(TableModel var1, ObjectNode var2);
}

