/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import org.onlab.metrics.MetricsComponent;
import org.onlab.metrics.MetricsFeature;
import org.onlab.metrics.MetricsService;

public class EventMetric {
    private static final String GAUGE_TIMESTAMP_NAME = "Timestamp.EpochMs";
    private static final String METER_RATE_NAME = "Rate";
    private final MetricsService metricsService;
    private final String componentName;
    private final String featureName;
    private MetricsComponent metricsComponent;
    private MetricsFeature metricsFeature;
    private volatile long lastEventTimestampEpochMs = 0L;
    private Gauge<Long> lastEventTimestampGauge;
    private Meter eventRateMeter;

    public EventMetric(MetricsService metricsService, String componentName, String featureName) {
        this.metricsService = metricsService;
        this.componentName = componentName;
        this.featureName = featureName;
    }

    public void registerMetrics() {
        this.metricsComponent = this.metricsService.registerComponent(this.componentName);
        this.metricsFeature = this.metricsComponent.registerFeature(this.featureName);
        this.lastEventTimestampEpochMs = 0L;
        this.lastEventTimestampGauge = this.metricsService.registerMetric(this.metricsComponent, this.metricsFeature, GAUGE_TIMESTAMP_NAME, new Gauge<Long>(){

            @Override
            public Long getValue() {
                return EventMetric.this.lastEventTimestampEpochMs;
            }
        });
        this.eventRateMeter = this.metricsService.createMeter(this.metricsComponent, this.metricsFeature, METER_RATE_NAME);
    }

    public void removeMetrics() {
        this.lastEventTimestampEpochMs = 0L;
        this.metricsService.removeMetric(this.metricsComponent, this.metricsFeature, GAUGE_TIMESTAMP_NAME);
        this.metricsService.removeMetric(this.metricsComponent, this.metricsFeature, METER_RATE_NAME);
    }

    public void eventReceived() {
        this.lastEventTimestampEpochMs = System.currentTimeMillis();
        this.eventRateMeter.mark(1L);
    }

    public Gauge<Long> lastEventTimestampGauge() {
        return this.lastEventTimestampGauge;
    }

    public Meter eventRateMeter() {
        return this.eventRateMeter;
    }
}

