/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.event;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerRegistry<E extends Event, L extends EventListener<E>>
implements EventSink<E> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private long lastStart;
    private L lastListener;
    protected final Set<L> listeners = new CopyOnWriteArraySet<L>();

    public void addListener(L listener) {
        Preconditions.checkNotNull(listener, "Listener cannot be null");
        this.listeners.add(listener);
    }

    public void removeListener(L listener) {
        Preconditions.checkNotNull(listener, "Listener cannot be null");
        if (!this.listeners.remove(listener)) {
            this.log.warn("Listener {} not registered", listener);
        }
    }

    @Override
    public void process(E event) {
        for (EventListener listener : this.listeners) {
            try {
                this.lastListener = listener;
                this.lastStart = System.currentTimeMillis();
                listener.event(event);
                this.lastStart = 0L;
            }
            catch (Exception error) {
                this.reportProblem(event, error);
            }
        }
    }

    @Override
    public void onProcessLimit() {
        if (this.lastStart > 0L) {
            this.log.error("Listener {} exceeded execution time limit: {} ms; ejected", (Object)this.lastListener.getClass().getName(), (Object)(System.currentTimeMillis() - this.lastStart));
            this.removeListener(this.lastListener);
            this.lastStart = 0L;
        }
    }

    protected void reportProblem(E event, Throwable error) {
        this.log.warn("Exception encountered while processing event " + event, error);
    }
}

