/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.ListUtils;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.core.GroupId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;

public final class DefaultTrafficTreatment
implements TrafficTreatment {
    private final List<Instruction> immediate;
    private final List<Instruction> deferred;
    private final List<Instruction> all;
    private final Instructions.TableTypeTransition table;
    private final Instructions.MetadataInstruction meta;
    private final boolean hasClear;
    private static final DefaultTrafficTreatment EMPTY = new DefaultTrafficTreatment(Collections.emptyList());

    private DefaultTrafficTreatment(List<Instruction> immediate) {
        this.immediate = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(immediate));
        this.deferred = ImmutableList.of();
        this.all = this.immediate;
        this.hasClear = false;
        this.table = null;
        this.meta = null;
    }

    private DefaultTrafficTreatment(List<Instruction> deferred, List<Instruction> immediate, Instructions.TableTypeTransition table, boolean clear, Instructions.MetadataInstruction meta) {
        this.immediate = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(immediate));
        this.deferred = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(deferred));
        this.all = ListUtils.union(this.immediate, this.deferred);
        this.table = table;
        this.meta = meta;
        this.hasClear = clear;
    }

    @Override
    public List<Instruction> deferred() {
        return this.deferred;
    }

    @Override
    public List<Instruction> immediate() {
        return this.immediate;
    }

    @Override
    public List<Instruction> allInstructions() {
        return this.all;
    }

    @Override
    public Instructions.TableTypeTransition tableTransition() {
        return this.table;
    }

    @Override
    public boolean clearedDeferred() {
        return this.hasClear;
    }

    @Override
    public Instructions.MetadataInstruction writeMetadata() {
        return this.meta;
    }

    public static TrafficTreatment.Builder builder() {
        return new Builder();
    }

    public static TrafficTreatment emptyTreatment() {
        return EMPTY;
    }

    public static TrafficTreatment.Builder builder(TrafficTreatment treatment) {
        return new Builder(treatment);
    }

    public int hashCode() {
        return Objects.hash(this.immediate, this.deferred, this.table, this.meta);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTrafficTreatment) {
            DefaultTrafficTreatment that = (DefaultTrafficTreatment)obj;
            return Objects.equals(this.immediate, that.immediate) && Objects.equals(this.deferred, that.deferred) && Objects.equals(this.table, that.table) && Objects.equals(this.meta, that.meta);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("immediate", this.immediate).add("deferred", this.deferred).add("transition", this.table == null ? "None" : this.table.toString()).add("cleared", this.hasClear).add("metadata", this.meta).toString();
    }

    public static final class Builder
    implements TrafficTreatment.Builder {
        boolean clear = false;
        Instructions.TableTypeTransition table;
        Instructions.MetadataInstruction meta;
        List<Instruction> deferred = Lists.newLinkedList();
        List<Instruction> immediate = Lists.newLinkedList();
        List<Instruction> current = this.immediate;

        private Builder() {
        }

        private Builder(TrafficTreatment treatment) {
            this.deferred();
            treatment.deferred().forEach(i -> this.add((Instruction)i));
            this.immediate();
            treatment.immediate().forEach(i -> this.add((Instruction)i));
            this.clear = treatment.clearedDeferred();
        }

        @Override
        public Builder add(Instruction instruction) {
            switch (instruction.type()) {
                case DROP: 
                case OUTPUT: 
                case GROUP: 
                case L0MODIFICATION: 
                case L2MODIFICATION: 
                case L3MODIFICATION: {
                    this.current.add(instruction);
                    break;
                }
                case TABLE: {
                    this.table = (Instructions.TableTypeTransition)instruction;
                    break;
                }
                case METADATA: {
                    this.meta = (Instructions.MetadataInstruction)instruction;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown instruction type: " + (Object)((Object)instruction.type()));
                }
            }
            return this;
        }

        @Override
        public Builder drop() {
            return this.add(Instructions.createDrop());
        }

        @Override
        public Builder punt() {
            return this.add(Instructions.createOutput(PortNumber.CONTROLLER));
        }

        @Override
        public Builder setOutput(PortNumber number) {
            return this.add(Instructions.createOutput(number));
        }

        @Override
        public Builder setEthSrc(MacAddress addr) {
            return this.add(Instructions.modL2Src(addr));
        }

        @Override
        public Builder setEthDst(MacAddress addr) {
            return this.add(Instructions.modL2Dst(addr));
        }

        @Override
        public Builder setVlanId(VlanId id) {
            return this.add(Instructions.modVlanId(id));
        }

        @Override
        public Builder setVlanPcp(Byte pcp) {
            return this.add(Instructions.modVlanPcp(pcp));
        }

        @Override
        public Builder setIpSrc(IpAddress addr) {
            return this.add(Instructions.modL3Src(addr));
        }

        @Override
        public Builder setIpDst(IpAddress addr) {
            return this.add(Instructions.modL3Dst(addr));
        }

        @Override
        public Builder decNwTtl() {
            return this.add(Instructions.decNwTtl());
        }

        @Override
        public Builder copyTtlIn() {
            return this.add(Instructions.copyTtlIn());
        }

        @Override
        public Builder copyTtlOut() {
            return this.add(Instructions.copyTtlOut());
        }

        @Override
        public Builder pushMpls() {
            return this.add(Instructions.pushMpls());
        }

        @Override
        public Builder popMpls() {
            return this.add(Instructions.popMpls());
        }

        @Override
        public Builder popMpls(int etherType) {
            return this.add(Instructions.popMpls(etherType));
        }

        @Override
        public Builder setMpls(MplsLabel mplsLabel) {
            return this.add(Instructions.modMplsLabel(mplsLabel));
        }

        @Override
        public Builder decMplsTtl() {
            return this.add(Instructions.decMplsTtl());
        }

        @Override
        public Builder setLambda(short lambda) {
            return this.add(Instructions.modL0Lambda(lambda));
        }

        @Override
        public Builder group(GroupId groupId) {
            return this.add(Instructions.createGroup(groupId));
        }

        @Override
        public Builder popVlan() {
            return this.add(Instructions.popVlan());
        }

        @Override
        public Builder pushVlan() {
            return this.add(Instructions.pushVlan());
        }

        @Override
        public Builder transition(FlowRule.Type type) {
            return this.add(Instructions.transition(type.ordinal()));
        }

        @Override
        public Builder transition(Integer tableId) {
            return this.add(Instructions.transition(tableId));
        }

        @Override
        public Builder immediate() {
            this.current = this.immediate;
            return this;
        }

        @Override
        public Builder deferred() {
            this.current = this.deferred;
            return this;
        }

        @Override
        public Builder wipeDeferred() {
            this.clear = true;
            return this;
        }

        @Override
        public Builder writeMetadata(long metadata, long metadataMask) {
            return this.add(Instructions.writeMetadata(metadata, metadataMask));
        }

        @Override
        public TrafficTreatment build() {
            return new DefaultTrafficTreatment(this.deferred, this.immediate, this.table, this.clear, this.meta);
        }
    }
}

