/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.MacAddress;
import org.onosproject.net.flow.criteria.Criterion;

public final class EthCriterion
implements Criterion {
    private final MacAddress mac;
    private final Criterion.Type type;

    EthCriterion(MacAddress mac, Criterion.Type type) {
        this.mac = mac;
        this.type = type;
    }

    @Override
    public Criterion.Type type() {
        return this.type;
    }

    public MacAddress mac() {
        return this.mac;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.type().toString()).add("mac", this.mac).toString();
    }

    public int hashCode() {
        return Objects.hash(this.type.ordinal(), this.mac);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EthCriterion) {
            EthCriterion that = (EthCriterion)obj;
            return Objects.equals(this.mac, that.mac) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }
}

