/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class IcmpCodeCriterion
implements Criterion {
    private static final short MASK = 255;
    private final short icmpCode;

    IcmpCodeCriterion(short icmpCode) {
        this.icmpCode = (short)(icmpCode & 0xFF);
    }

    @Override
    public Criterion.Type type() {
        return Criterion.Type.ICMPV4_CODE;
    }

    public short icmpCode() {
        return this.icmpCode;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.type().toString()).add("icmpCode", this.icmpCode).toString();
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.icmpCode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IcmpCodeCriterion) {
            IcmpCodeCriterion that = (IcmpCodeCriterion)obj;
            return Objects.equals(this.icmpCode, that.icmpCode) && Objects.equals((Object)this.type(), (Object)that.type());
        }
        return false;
    }
}

