/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;

@Beta
public final class OpticalConnectivityIntent
extends Intent {
    private final ConnectPoint src;
    private final ConnectPoint dst;
    private final OduSignalType signalType;
    private final boolean isBidirectional;

    protected OpticalConnectivityIntent(ApplicationId appId, Key key, ConnectPoint src, ConnectPoint dst, OduSignalType signalType, boolean isBidirectional, int priority) {
        super(appId, key, Collections.emptyList(), priority);
        this.src = Preconditions.checkNotNull(src);
        this.dst = Preconditions.checkNotNull(dst);
        this.signalType = Preconditions.checkNotNull(signalType);
        this.isBidirectional = isBidirectional;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected OpticalConnectivityIntent() {
        this.src = null;
        this.dst = null;
        this.signalType = null;
        this.isBidirectional = false;
    }

    public ConnectPoint getSrc() {
        return this.src;
    }

    public ConnectPoint getDst() {
        return this.dst;
    }

    public OduSignalType getSignalType() {
        return this.signalType;
    }

    public boolean isBidirectional() {
        return this.isBidirectional;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id()).add("key", this.key()).add("appId", this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("src", this.src).add("dst", this.dst).add("signalType", (Object)this.signalType).add("isBidirectional", this.isBidirectional).toString();
    }

    public static class Builder
    extends Intent.Builder {
        private ConnectPoint src;
        private ConnectPoint dst;
        private OduSignalType signalType;
        private boolean isBidirectional;

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        public Builder src(ConnectPoint src) {
            this.src = src;
            return this;
        }

        public Builder dst(ConnectPoint dst) {
            this.dst = dst;
            return this;
        }

        public Builder signalType(OduSignalType signalType) {
            this.signalType = signalType;
            return this;
        }

        public Builder bidirectional(boolean isBidirectional) {
            this.isBidirectional = isBidirectional;
            return this;
        }

        public OpticalConnectivityIntent build() {
            return new OpticalConnectivityIntent(this.appId, this.key, this.src, this.dst, this.signalType, this.isBidirectional, this.priority);
        }
    }
}

