/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;

public final class DatabaseUpdate {
    private Type type;
    private String tableName;
    private String key;
    private byte[] value;
    private byte[] currentValue;
    private long currentVersion = -1L;

    public Type type() {
        return this.type;
    }

    public String tableName() {
        return this.tableName;
    }

    public String key() {
        return this.key;
    }

    public byte[] value() {
        return this.value;
    }

    public byte[] currentValue() {
        return this.currentValue;
    }

    public long currentVersion() {
        return this.currentVersion;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type).add("tableName", this.tableName).add("key", this.key).add("value", this.value).add("currentValue", this.currentValue).add("currentVersion", this.currentVersion).toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static /* synthetic */ byte[] access$302(DatabaseUpdate x0, byte[] x1) {
        x0.currentValue = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$402(DatabaseUpdate x0, byte[] x1) {
        x0.value = x1;
        return x1;
    }

    public static final class Builder {
        private DatabaseUpdate update = new DatabaseUpdate();

        public DatabaseUpdate build() {
            this.validateInputs();
            return this.update;
        }

        public Builder withType(Type type) {
            this.update.type = Preconditions.checkNotNull(type, "type cannot be null");
            return this;
        }

        public Builder withTableName(String tableName) {
            this.update.tableName = Preconditions.checkNotNull(tableName, "tableName cannot be null");
            return this;
        }

        public Builder withKey(String key) {
            this.update.key = Preconditions.checkNotNull(key, "key cannot be null");
            return this;
        }

        public Builder withCurrentValue(byte[] value) {
            DatabaseUpdate.access$302(this.update, Preconditions.checkNotNull(value, "currentValue cannot be null"));
            return this;
        }

        public Builder withValue(byte[] value) {
            DatabaseUpdate.access$402(this.update, Preconditions.checkNotNull(value, "value cannot be null"));
            return this;
        }

        public Builder withCurrentVersion(long version) {
            Preconditions.checkArgument(version >= 0L, "version cannot be negative");
            this.update.currentVersion = version;
            return this;
        }

        private void validateInputs() {
            Preconditions.checkNotNull(this.update.type, "type must be specified");
            Preconditions.checkNotNull(this.update.tableName, "table name must be specified");
            Preconditions.checkNotNull(this.update.key, "key must be specified");
            switch (this.update.type) {
                case PUT: 
                case PUT_IF_ABSENT: {
                    Preconditions.checkNotNull(this.update.value, "value must be specified.");
                    break;
                }
                case PUT_IF_VERSION_MATCH: {
                    Preconditions.checkNotNull(this.update.value, "value must be specified.");
                    Preconditions.checkState(this.update.currentVersion >= 0L, "current version must be specified");
                    break;
                }
                case PUT_IF_VALUE_MATCH: {
                    Preconditions.checkNotNull(this.update.value, "value must be specified.");
                    Preconditions.checkNotNull(this.update.currentValue, "currentValue must be specified.");
                    break;
                }
                case REMOVE: {
                    break;
                }
                case REMOVE_IF_VERSION_MATCH: {
                    Preconditions.checkState(this.update.currentVersion >= 0L, "current version must be specified");
                    break;
                }
                case REMOVE_IF_VALUE_MATCH: {
                    Preconditions.checkNotNull(this.update.currentValue, "currentValue must be specified.");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation type");
                }
            }
        }
    }

    public static enum Type {
        PUT,
        PUT_IF_ABSENT,
        PUT_IF_VERSION_MATCH,
        PUT_IF_VALUE_MATCH,
        REMOVE,
        REMOVE_IF_VERSION_MATCH,
        REMOVE_IF_VALUE_MATCH;

    }
}

