/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.store.service.Versioned;

public class MapEvent<K, V> {
    private final String name;
    private final Type type;
    private final K key;
    private final Versioned<V> value;

    public MapEvent(String name, Type type, K key, Versioned<V> value) {
        this.name = name;
        this.type = type;
        this.key = key;
        this.value = value;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public K key() {
        return this.key;
    }

    public Versioned<V> value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MapEvent)) {
            return false;
        }
        MapEvent that = (MapEvent)o;
        return Objects.equals(this.name, that.name) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.key, this.value});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", this.name).add("type", (Object)this.type).add("key", this.key).add("value", this.value).toString();
    }

    public static enum Type {
        INSERT,
        UPDATE,
        REMOVE;

    }
}

