/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.util.Objects;
import org.onosproject.store.Timestamp;

public class MultiValuedTimestamp<T extends Comparable<T>, U extends Comparable<U>>
implements Timestamp {
    private final T value1;
    private final U value2;

    public MultiValuedTimestamp(T value1, U value2) {
        this.value1 = (Comparable)Preconditions.checkNotNull(value1);
        this.value2 = (Comparable)Preconditions.checkNotNull(value2);
    }

    @Override
    public int compareTo(Timestamp o) {
        Preconditions.checkArgument(o instanceof MultiValuedTimestamp, "Must be MultiValuedTimestamp", o);
        MultiValuedTimestamp that = (MultiValuedTimestamp)o;
        return ComparisonChain.start().compare((Comparable<?>)this.value1, (Comparable<?>)that.value1).compare((Comparable<?>)this.value2, (Comparable<?>)that.value2).result();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value1, this.value2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MultiValuedTimestamp)) {
            return false;
        }
        MultiValuedTimestamp that = (MultiValuedTimestamp)obj;
        return Objects.equals(this.value1, that.value1) && Objects.equals(this.value2, that.value2);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("value1", this.value1).add("value2", this.value2).toString();
    }

    public T value1() {
        return this.value1;
    }

    public U value2() {
        return this.value2;
    }

    private MultiValuedTimestamp() {
        this.value1 = null;
        this.value2 = null;
    }
}

