/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.onlab.util.KryoNamespace;
import org.onosproject.store.service.MapEvent;

public interface Serializer {
    public <T> byte[] encode(T var1);

    public <T> T decode(byte[] var1);

    public static Serializer using(KryoNamespace kryo) {
        return Serializer.using(Arrays.asList(kryo), new Class[0]);
    }

    public static Serializer using(List<KryoNamespace> namespaces, Class<?> ... classes) {
        KryoNamespace.Builder builder = new KryoNamespace.Builder();
        namespaces.forEach(builder::register);
        Lists.newArrayList(classes).forEach((Consumer<Class<?>>)((Consumer<Class>)xva$0 -> builder.register((Class<?>)xva$0)));
        builder.register(MapEvent.class, MapEvent.Type.class);
        final KryoNamespace namespace = builder.build();
        return new Serializer(){

            @Override
            public <T> byte[] encode(T object) {
                return namespace.serialize(object);
            }

            @Override
            public <T> T decode(byte[] bytes) {
                return namespace.deserialize(bytes);
            }
        };
    }

    public static Serializer forTypes(Class<?> ... classes) {
        return Serializer.using(KryoNamespace.newBuilder().register(classes).register(MapEvent.class, MapEvent.Type.class).build());
    }
}

