/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ndp;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.onlab.packet.BasePacket;
import org.onlab.packet.IPacket;

public class NeighborDiscoveryOptions
extends BasePacket {
    public static final byte TYPE_SOURCE_LL_ADDRESS = 1;
    public static final byte TYPE_TARGET_LL_ADDRESS = 2;
    public static final byte TYPE_PREFIX_INFORMATION = 3;
    public static final byte TYPE_REDIRECTED_HEADER = 4;
    public static final byte TYPE_MTU = 5;
    private final List<Option> options = new ArrayList<Option>();

    public NeighborDiscoveryOptions addOption(byte type, byte[] data) {
        this.options.add(new Option(type, data));
        return this;
    }

    public List<Option> options() {
        return this.options;
    }

    public boolean hasOptions() {
        return !this.options.isEmpty();
    }

    @Override
    public byte[] serialize() {
        int wireLength = 0;
        for (Option option : this.options) {
            wireLength += option.optionWireLength();
        }
        byte[] data = new byte[wireLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        for (Option option : this.options) {
            bb.put(option.type());
            bb.put(option.optionLengthField());
            bb.put(option.data());
            int paddingLength = option.optionWireLength() - option.optionLength();
            for (int i = 0; i < paddingLength; ++i) {
                bb.put((byte)0);
            }
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        this.options.clear();
        while (bb.hasRemaining()) {
            byte lengthField;
            int dataLength;
            byte type = bb.get();
            if (!bb.hasRemaining() || (dataLength = (lengthField = bb.get()) * 8) < 2 || bb.remaining() < (dataLength -= 2)) break;
            byte[] optionData = new byte[dataLength];
            bb.get(optionData, 0, optionData.length);
            this.addOption(type, optionData);
        }
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (Option option : this.options) {
            result = 31 * result + option.type();
            result = 31 * result + Arrays.hashCode(option.data());
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NeighborDiscoveryOptions) {
            NeighborDiscoveryOptions other = (NeighborDiscoveryOptions)obj;
            return this.options.equals(other.options);
        }
        return false;
    }

    public final class Option {
        private final byte type;
        private final byte[] data;

        private Option(byte type, byte[] data) {
            this.type = type;
            this.data = Arrays.copyOfRange(data, 0, data.length);
        }

        public byte type() {
            return this.type;
        }

        public byte[] data() {
            return this.data;
        }

        public int dataLength() {
            return this.data.length;
        }

        private int optionLength() {
            return 2 + this.dataLength();
        }

        private byte optionLengthField() {
            return (byte)((this.optionLength() + 7) / 8);
        }

        private int optionWireLength() {
            return 8 * this.optionLengthField();
        }
    }
}

