/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.app;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.onosproject.app.ApplicationDescription;
import org.onosproject.core.ApplicationRole;
import org.onosproject.core.Permission;
import org.onosproject.core.Version;

public class DefaultApplicationDescription
implements ApplicationDescription {
    private final String name;
    private final Version version;
    private final String description;
    private final String origin;
    private final ApplicationRole role;
    private final Set<Permission> permissions;
    private final Optional<URI> featuresRepo;
    private final List<String> features;

    public DefaultApplicationDescription(String name, Version version, String description, String origin, ApplicationRole role, Set<Permission> permissions, URI featuresRepo, List<String> features) {
        this.name = Preconditions.checkNotNull(name, "Name cannot be null");
        this.version = Preconditions.checkNotNull(version, "Version cannot be null");
        this.description = Preconditions.checkNotNull(description, "Description cannot be null");
        this.origin = Preconditions.checkNotNull(origin, "Origin cannot be null");
        this.role = Preconditions.checkNotNull(role, "Role cannot be null");
        this.permissions = Preconditions.checkNotNull(permissions, "Permissions cannot be null");
        this.featuresRepo = Optional.ofNullable(featuresRepo);
        this.features = Preconditions.checkNotNull(features, "Features cannot be null");
        Preconditions.checkArgument(!features.isEmpty(), "There must be at least one feature");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String origin() {
        return this.origin;
    }

    @Override
    public ApplicationRole role() {
        return this.role;
    }

    @Override
    public Set<Permission> permissions() {
        return this.permissions;
    }

    @Override
    public Optional<URI> featuresRepo() {
        return this.featuresRepo;
    }

    @Override
    public List<String> features() {
        return this.features;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("version", this.version).add("description", this.description).add("origin", this.origin).add("role", (Object)this.role).add("permissions", this.permissions).add("featuresRepo", this.featuresRepo).add("features", this.features).toString();
    }
}

