/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.AbstractElement;
import org.onosproject.net.Annotations;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.provider.ProviderId;

public class DefaultHost
extends AbstractElement
implements Host {
    private final MacAddress mac;
    private final VlanId vlan;
    private final HostLocation location;
    private final Set<IpAddress> ips;

    public DefaultHost(ProviderId providerId, HostId id, MacAddress mac, VlanId vlan, HostLocation location, Set<IpAddress> ips, Annotations ... annotations) {
        super(providerId, id, annotations);
        this.mac = mac;
        this.vlan = vlan;
        this.location = location;
        this.ips = new HashSet<IpAddress>(ips);
    }

    @Override
    public HostId id() {
        return (HostId)this.id;
    }

    @Override
    public MacAddress mac() {
        return this.mac;
    }

    @Override
    public Set<IpAddress> ipAddresses() {
        return Collections.unmodifiableSet(this.ips);
    }

    @Override
    public HostLocation location() {
        return this.location;
    }

    @Override
    public VlanId vlan() {
        return this.vlan;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.mac, this.vlan, this.location);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultHost) {
            DefaultHost other = (DefaultHost)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.mac, other.mac) && Objects.equals(this.vlan, other.vlan) && Objects.equals(this.location, other.location);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("mac", this.mac).add("vlan", this.vlan).add("location", this.location).add("ipAddresses", this.ips).toString();
    }
}

