/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.util.Frequency;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.GridType;
import org.onosproject.net.Lambda;
import org.onosproject.net.resource.link.LambdaResourceAllocation;

public class OchSignal
implements Lambda {
    public static final Frequency CENTER_FREQUENCY = Frequency.ofTHz(193.1);
    public static final Frequency FLEX_GRID_SLOT = Frequency.ofGHz(12.5);
    private static final GridType DEFAULT_OCH_GRIDTYPE = GridType.DWDM;
    private static final ChannelSpacing DEFAULT_CHANNEL_SPACING = ChannelSpacing.CHL_50GHZ;
    private final GridType gridType;
    private final ChannelSpacing channelSpacing;
    private final int spacingMultiplier;
    private final int slotGranularity;

    public OchSignal(GridType gridType, ChannelSpacing channelSpacing, int spacingMultiplier, int slotGranularity) {
        this.gridType = Preconditions.checkNotNull(gridType);
        this.channelSpacing = Preconditions.checkNotNull(channelSpacing);
        this.spacingMultiplier = spacingMultiplier;
        Preconditions.checkArgument(slotGranularity > 0, "slotGranularity must be larger than 0, received %s", slotGranularity);
        this.slotGranularity = slotGranularity;
    }

    public OchSignal(LambdaResourceAllocation alloc, Frequency maxFrequency, Frequency grid) {
        int channel = alloc.lambda().toInt();
        Frequency centerFrequency = maxFrequency.subtract(grid.multiply(channel - 1));
        this.gridType = DEFAULT_OCH_GRIDTYPE;
        this.channelSpacing = DEFAULT_CHANNEL_SPACING;
        this.spacingMultiplier = (int)(centerFrequency.subtract(CENTER_FREQUENCY).asHz() / grid.asHz());
        this.slotGranularity = (int)Math.round((double)grid.asHz() / (double)ChannelSpacing.CHL_12P5GHZ.frequency().asHz());
    }

    public OchSignal(Frequency centerFrequency, ChannelSpacing channelSpacing, int slotGranularity) {
        this.gridType = DEFAULT_OCH_GRIDTYPE;
        this.channelSpacing = channelSpacing;
        this.spacingMultiplier = (int)Math.round((double)centerFrequency.subtract(CENTER_FREQUENCY).asHz() / (double)this.channelSpacing().frequency().asHz());
        this.slotGranularity = slotGranularity;
    }

    public GridType gridType() {
        return this.gridType;
    }

    public ChannelSpacing channelSpacing() {
        return this.channelSpacing;
    }

    public int spacingMultiplier() {
        return this.spacingMultiplier;
    }

    public int slotGranularity() {
        return this.slotGranularity;
    }

    public Frequency centralFrequency() {
        return CENTER_FREQUENCY.add(this.channelSpacing().frequency().multiply(this.spacingMultiplier));
    }

    public Frequency slotWidth() {
        return FLEX_GRID_SLOT.multiply(this.slotGranularity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.gridType, this.channelSpacing, this.spacingMultiplier, this.slotGranularity});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OchSignal)) {
            return false;
        }
        OchSignal other = (OchSignal)obj;
        return Objects.equals((Object)this.gridType, (Object)other.gridType) && Objects.equals((Object)this.channelSpacing, (Object)other.channelSpacing) && Objects.equals(this.spacingMultiplier, other.spacingMultiplier) && Objects.equals(this.slotGranularity, other.slotGranularity);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("gridType", (Object)this.gridType).add("channelSpacing", (Object)this.channelSpacing).add("spacingMultiplier", this.spacingMultiplier).add("slotGranularity", this.slotGranularity).toString();
    }
}

