/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.HandlerBehaviour;

public class DefaultDriver
implements Driver {
    private final String name;
    private final Driver parent;
    private final String manufacturer;
    private final String hwVersion;
    private final String swVersion;
    private final Map<Class<? extends Behaviour>, Class<? extends Behaviour>> behaviours;
    private final Map<String, String> properties;

    public DefaultDriver(String name, Driver parent, String manufacturer, String hwVersion, String swVersion, Map<Class<? extends Behaviour>, Class<? extends Behaviour>> behaviours, Map<String, String> properties) {
        this.name = Preconditions.checkNotNull(name, "Name cannot be null");
        this.parent = parent;
        this.manufacturer = Preconditions.checkNotNull(manufacturer, "Manufacturer cannot be null");
        this.hwVersion = Preconditions.checkNotNull(hwVersion, "HW version cannot be null");
        this.swVersion = Preconditions.checkNotNull(swVersion, "SW version cannot be null");
        this.behaviours = ImmutableMap.copyOf(Preconditions.checkNotNull(behaviours, "Behaviours cannot be null"));
        this.properties = ImmutableMap.copyOf(Preconditions.checkNotNull(properties, "Properties cannot be null"));
    }

    @Override
    public Driver merge(Driver other) {
        Preconditions.checkArgument(this.parent == null || Objects.equals(this.parent, other.parent()), "Parent drivers are not the same");
        HashMap<Class<? extends Behaviour>, Class<? extends Behaviour>> behaviours = Maps.newHashMap();
        behaviours.putAll(this.behaviours);
        other.behaviours().forEach(b -> behaviours.put((Class<? extends Behaviour>)b, other.implementation((Class<? extends Behaviour>)b)));
        ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();
        properties.putAll(this.properties).putAll(other.properties());
        return new DefaultDriver(this.name, other.parent(), this.manufacturer, this.hwVersion, this.swVersion, ImmutableMap.copyOf(behaviours), properties.build());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String manufacturer() {
        return this.manufacturer;
    }

    @Override
    public String hwVersion() {
        return this.hwVersion;
    }

    @Override
    public String swVersion() {
        return this.swVersion;
    }

    @Override
    public Driver parent() {
        return this.parent;
    }

    @Override
    public Set<Class<? extends Behaviour>> behaviours() {
        return this.behaviours.keySet();
    }

    @Override
    public Class<? extends Behaviour> implementation(Class<? extends Behaviour> behaviour) {
        return this.behaviours.get(behaviour);
    }

    @Override
    public boolean hasBehaviour(Class<? extends Behaviour> behaviourClass) {
        return this.behaviours.containsKey(behaviourClass) || this.parent != null && this.parent.hasBehaviour(behaviourClass);
    }

    @Override
    public <T extends Behaviour> T createBehaviour(DriverData data, Class<T> behaviourClass) {
        T behaviour = this.createBehaviour(data, null, behaviourClass);
        if (behaviour != null) {
            return behaviour;
        }
        if (this.parent != null) {
            return this.parent.createBehaviour(data, behaviourClass);
        }
        throw new IllegalArgumentException(behaviourClass.getName() + " not supported");
    }

    @Override
    public <T extends Behaviour> T createBehaviour(DriverHandler handler, Class<T> behaviourClass) {
        T behaviour = this.createBehaviour(handler.data(), handler, behaviourClass);
        if (behaviour != null) {
            return behaviour;
        }
        if (this.parent != null) {
            return this.parent.createBehaviour(handler, behaviourClass);
        }
        throw new IllegalArgumentException(behaviourClass.getName() + " not supported");
    }

    private <T extends Behaviour> T createBehaviour(DriverData data, DriverHandler handler, Class<T> behaviourClass) {
        Preconditions.checkArgument(handler != null || !HandlerBehaviour.class.isAssignableFrom(behaviourClass), "{} is applicable only to handler context", behaviourClass.getName());
        Class<? extends Behaviour> implementation = this.behaviours.get(behaviourClass);
        if (implementation != null) {
            T behaviour = this.createBehaviour(behaviourClass, implementation);
            behaviour.setData(data);
            if (handler != null) {
                ((HandlerBehaviour)behaviour).setHandler(handler);
            }
            return behaviour;
        }
        return null;
    }

    private <T extends Behaviour> T createBehaviour(Class<T> behaviourClass, Class<? extends Behaviour> implementation) {
        try {
            return (T)implementation.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Unable to create behaviour", e);
        }
    }

    @Override
    public Set<String> keys() {
        return this.properties.keySet();
    }

    @Override
    public String value(String key) {
        return this.properties.get(key);
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("parent", this.parent).add("manufacturer", this.manufacturer).add("hwVersion", this.hwVersion).add("swVersion", this.swVersion).add("behaviours", this.behaviours).add("properties", this.properties).toString();
    }
}

