/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class LambdaCriterion
implements Criterion {
    private static final int MASK = 65535;
    private final int lambda;
    private final Criterion.Type type;

    LambdaCriterion(int lambda, Criterion.Type type) {
        this.lambda = lambda & 0xFFFF;
        this.type = type;
    }

    @Override
    public Criterion.Type type() {
        return this.type;
    }

    public int lambda() {
        return this.lambda;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.type().toString()).add("lambda", this.lambda).toString();
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.lambda);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LambdaCriterion) {
            LambdaCriterion that = (LambdaCriterion)obj;
            return Objects.equals(this.lambda, that.lambda) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }
}

