/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class UdpPortCriterion
implements Criterion {
    private static final int MASK = 65535;
    private final int udpPort;
    private final Criterion.Type type;

    UdpPortCriterion(int udpPort, Criterion.Type type) {
        this.udpPort = udpPort & 0xFFFF;
        this.type = type;
    }

    @Override
    public Criterion.Type type() {
        return this.type;
    }

    public int udpPort() {
        return this.udpPort;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.type().toString()).add("udpPort", this.udpPort).toString();
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.udpPort);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UdpPortCriterion) {
            UdpPortCriterion that = (UdpPortCriterion)obj;
            return Objects.equals(this.udpPort, that.udpPort) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }
}

