/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.core.GroupId;
import org.onosproject.net.IndexedLambda;
import org.onosproject.net.Lambda;
import org.onosproject.net.OchSignal;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.L0ModificationInstruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;

public final class Instructions {
    private Instructions() {
    }

    public static OutputInstruction createOutput(PortNumber number) {
        Preconditions.checkNotNull(number, "PortNumber cannot be null");
        return new OutputInstruction(number);
    }

    public static DropInstruction createDrop() {
        return new DropInstruction();
    }

    public static GroupInstruction createGroup(GroupId groupId) {
        Preconditions.checkNotNull(groupId, "GroupId cannot be null");
        return new GroupInstruction(groupId);
    }

    @Deprecated
    public static L0ModificationInstruction modL0Lambda(short lambda) {
        Preconditions.checkNotNull(lambda, "L0 lambda cannot be null");
        return new L0ModificationInstruction.ModLambdaInstruction(L0ModificationInstruction.L0SubType.LAMBDA, lambda);
    }

    public static L0ModificationInstruction modL0Lambda(Lambda lambda) {
        Preconditions.checkNotNull(lambda, "L0 OCh signal cannot be null");
        if (lambda instanceof IndexedLambda) {
            return new L0ModificationInstruction.ModLambdaInstruction(L0ModificationInstruction.L0SubType.LAMBDA, (short)((IndexedLambda)lambda).index());
        }
        if (lambda instanceof OchSignal) {
            return new L0ModificationInstruction.ModOchSignalInstruction((OchSignal)lambda);
        }
        throw new UnsupportedOperationException(String.format("Unsupported type: %s", lambda));
    }

    public static L2ModificationInstruction modL2Src(MacAddress addr) {
        Preconditions.checkNotNull(addr, "Src l2 address cannot be null");
        return new L2ModificationInstruction.ModEtherInstruction(L2ModificationInstruction.L2SubType.ETH_SRC, addr);
    }

    public static L2ModificationInstruction modL2Dst(MacAddress addr) {
        Preconditions.checkNotNull(addr, "Dst l2 address cannot be null");
        return new L2ModificationInstruction.ModEtherInstruction(L2ModificationInstruction.L2SubType.ETH_DST, addr);
    }

    public static L2ModificationInstruction modVlanId(VlanId vlanId) {
        Preconditions.checkNotNull(vlanId, "VLAN id cannot be null");
        return new L2ModificationInstruction.ModVlanIdInstruction(vlanId);
    }

    public static L2ModificationInstruction modVlanPcp(Byte vlanPcp) {
        Preconditions.checkNotNull(vlanPcp, "VLAN Pcp cannot be null");
        return new L2ModificationInstruction.ModVlanPcpInstruction(vlanPcp);
    }

    public static L2ModificationInstruction modMplsLabel(MplsLabel mplsLabel) {
        Preconditions.checkNotNull(mplsLabel, "MPLS label cannot be null");
        return new L2ModificationInstruction.ModMplsLabelInstruction(mplsLabel);
    }

    public static L2ModificationInstruction decMplsTtl() {
        return new L2ModificationInstruction.ModMplsTtlInstruction();
    }

    public static L3ModificationInstruction modL3Src(IpAddress addr) {
        Preconditions.checkNotNull(addr, "Src l3 IPv4 address cannot be null");
        return new L3ModificationInstruction.ModIPInstruction(L3ModificationInstruction.L3SubType.IPV4_SRC, addr);
    }

    public static L3ModificationInstruction modL3Dst(IpAddress addr) {
        Preconditions.checkNotNull(addr, "Dst l3 IPv4 address cannot be null");
        return new L3ModificationInstruction.ModIPInstruction(L3ModificationInstruction.L3SubType.IPV4_DST, addr);
    }

    public static L3ModificationInstruction modL3IPv6Src(IpAddress addr) {
        Preconditions.checkNotNull(addr, "Src l3 IPv6 address cannot be null");
        return new L3ModificationInstruction.ModIPInstruction(L3ModificationInstruction.L3SubType.IPV6_SRC, addr);
    }

    public static L3ModificationInstruction modL3IPv6Dst(IpAddress addr) {
        Preconditions.checkNotNull(addr, "Dst l3 IPv6 address cannot be null");
        return new L3ModificationInstruction.ModIPInstruction(L3ModificationInstruction.L3SubType.IPV6_DST, addr);
    }

    public static L3ModificationInstruction modL3IPv6FlowLabel(int flowLabel) {
        return new L3ModificationInstruction.ModIPv6FlowLabelInstruction(flowLabel);
    }

    public static L3ModificationInstruction decNwTtl() {
        return new L3ModificationInstruction.ModTtlInstruction(L3ModificationInstruction.L3SubType.DEC_TTL);
    }

    public static L3ModificationInstruction copyTtlOut() {
        return new L3ModificationInstruction.ModTtlInstruction(L3ModificationInstruction.L3SubType.TTL_OUT);
    }

    public static L3ModificationInstruction copyTtlIn() {
        return new L3ModificationInstruction.ModTtlInstruction(L3ModificationInstruction.L3SubType.TTL_IN);
    }

    public static Instruction pushMpls() {
        return new L2ModificationInstruction.PushHeaderInstructions(L2ModificationInstruction.L2SubType.MPLS_PUSH, -30649);
    }

    public static Instruction popMpls() {
        return new L2ModificationInstruction.PushHeaderInstructions(L2ModificationInstruction.L2SubType.MPLS_POP, -30649);
    }

    public static Instruction popMpls(int etherType) {
        Preconditions.checkNotNull(etherType, "Ethernet type cannot be null");
        return new L2ModificationInstruction.PushHeaderInstructions(L2ModificationInstruction.L2SubType.MPLS_POP, etherType);
    }

    public static Instruction popVlan() {
        return new L2ModificationInstruction.PopVlanInstruction(L2ModificationInstruction.L2SubType.VLAN_POP);
    }

    public static Instruction pushVlan() {
        return new L2ModificationInstruction.PushHeaderInstructions(L2ModificationInstruction.L2SubType.VLAN_PUSH, -32512);
    }

    public static Instruction transition(Integer tableId) {
        Preconditions.checkNotNull(tableId, "Table id cannot be null");
        return new TableTypeTransition(tableId);
    }

    public static Instruction writeMetadata(long metadata, long metadataMask) {
        return new MetadataInstruction(metadata, metadataMask);
    }

    public static class MetadataInstruction
    implements Instruction {
        private final long metadata;
        private final long metadataMask;

        MetadataInstruction(long metadata, long metadataMask) {
            this.metadata = metadata;
            this.metadataMask = metadataMask;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.METADATA;
        }

        public long metadata() {
            return this.metadata;
        }

        public long metadataMask() {
            return this.metadataMask;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("metadata", Long.toHexString(this.metadata)).add("metadata mask", Long.toHexString(this.metadataMask)).toString();
        }

        public int hashCode() {
            return Objects.hash(this.type().ordinal(), this.metadata, this.metadataMask);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof MetadataInstruction) {
                MetadataInstruction that = (MetadataInstruction)obj;
                return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.metadataMask, that.metadataMask);
            }
            return false;
        }
    }

    public static class TableTypeTransition
    implements Instruction {
        private final Integer tableId;

        TableTypeTransition(Integer tableId) {
            this.tableId = tableId;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.TABLE;
        }

        public Integer tableId() {
            return this.tableId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("tableId", this.tableId).toString();
        }

        public int hashCode() {
            return Objects.hash(this.type().ordinal(), this.tableId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TableTypeTransition) {
                TableTypeTransition that = (TableTypeTransition)obj;
                return Objects.equals(this.tableId, that.tableId);
            }
            return false;
        }
    }

    public static final class GroupInstruction
    implements Instruction {
        private final GroupId groupId;

        private GroupInstruction(GroupId groupId) {
            this.groupId = groupId;
        }

        public GroupId groupId() {
            return this.groupId;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.GROUP;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("group ID", this.groupId.id()).toString();
        }

        public int hashCode() {
            return Objects.hash(this.type().ordinal(), this.groupId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof GroupInstruction) {
                GroupInstruction that = (GroupInstruction)obj;
                return Objects.equals(this.groupId, that.groupId);
            }
            return false;
        }
    }

    public static final class OutputInstruction
    implements Instruction {
        private final PortNumber port;

        private OutputInstruction(PortNumber port) {
            this.port = port;
        }

        public PortNumber port() {
            return this.port;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.OUTPUT;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("port", this.port).toString();
        }

        public int hashCode() {
            return Objects.hash(this.type().ordinal(), this.port);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OutputInstruction) {
                OutputInstruction that = (OutputInstruction)obj;
                return Objects.equals(this.port, that.port);
            }
            return false;
        }
    }

    public static final class DropInstruction
    implements Instruction {
        private DropInstruction() {
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.DROP;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).toString();
        }

        public int hashCode() {
            return Objects.hash(this.type().ordinal());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof DropInstruction;
        }
    }
}

