/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.Key;
import org.onosproject.store.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class IntentData {
    private static final Logger log = LoggerFactory.getLogger(IntentData.class);
    private final Intent intent;
    private final IntentState request;
    private IntentState state;
    private Timestamp version;
    private NodeId origin;
    private int errorCount;
    private List<Intent> installables;

    public IntentData(Intent intent, IntentState state, Timestamp version) {
        this.intent = intent;
        this.state = state;
        this.request = state;
        this.version = version;
    }

    public IntentData(IntentData intentData) {
        Preconditions.checkNotNull(intentData);
        this.intent = intentData.intent;
        this.state = intentData.state;
        this.request = intentData.request;
        this.version = intentData.version;
        this.origin = intentData.origin;
        this.installables = intentData.installables;
        this.errorCount = intentData.errorCount;
    }

    protected IntentData() {
        this.intent = null;
        this.request = null;
    }

    public Intent intent() {
        return this.intent;
    }

    public IntentState state() {
        return this.state;
    }

    public IntentState request() {
        return this.request;
    }

    public Key key() {
        return this.intent.key();
    }

    public Timestamp version() {
        return this.version;
    }

    public void setOrigin(NodeId origin) {
        this.origin = origin;
    }

    public NodeId origin() {
        return this.origin;
    }

    public void setState(IntentState newState) {
        this.state = newState;
    }

    public void setVersion(Timestamp version) {
        this.version = version;
    }

    public void incrementErrorCount() {
        ++this.errorCount;
    }

    public void setErrorCount(int newCount) {
        this.errorCount = newCount;
    }

    public int errorCount() {
        return this.errorCount;
    }

    public void setInstallables(List<Intent> installables) {
        this.installables = ImmutableList.copyOf(installables);
    }

    public List<Intent> installables() {
        return this.installables != null ? this.installables : Collections.emptyList();
    }

    public static boolean isUpdateAcceptable(IntentData currentData, IntentData newData) {
        if (currentData == null) {
            return true;
        }
        if (currentData.version().isOlderThan(newData.version())) {
            return true;
        }
        if (currentData.version().isNewerThan(newData.version())) {
            return false;
        }
        IntentState currentState = currentData.state();
        IntentState newState = newData.state();
        switch (newState) {
            case INSTALLING: {
                if (currentState == IntentState.INSTALLING) {
                    return false;
                }
            }
            case INSTALLED: {
                if (currentState == IntentState.INSTALLED) {
                    return false;
                }
                if (currentState == IntentState.WITHDRAWING || currentState == IntentState.WITHDRAWN || currentState == IntentState.PURGE_REQ) {
                    log.warn("Invalid state transition from {} to {} for intent {}", new Object[]{currentState, newState, newData.key()});
                    return false;
                }
                return true;
            }
            case WITHDRAWING: {
                if (currentState == IntentState.WITHDRAWING) {
                    return false;
                }
            }
            case WITHDRAWN: {
                if (currentState == IntentState.WITHDRAWN) {
                    return false;
                }
                if (currentState == IntentState.INSTALLING || currentState == IntentState.INSTALLED || currentState == IntentState.PURGE_REQ) {
                    log.warn("Invalid state transition from {} to {} for intent {}", new Object[]{currentState, newState, newData.key()});
                    return false;
                }
                return true;
            }
            case FAILED: {
                return currentState != IntentState.FAILED;
            }
            case CORRUPT: {
                return currentState != IntentState.CORRUPT;
            }
            case PURGE_REQ: {
                return true;
            }
        }
        log.warn("Invalid state {} for intent {}", (Object)newState, (Object)newData.key());
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.intent, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntentData other = (IntentData)obj;
        return Objects.equals(this.intent, other.intent) && Objects.equals(this.version, other.version);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("key", this.key()).add("state", (Object)this.state()).add("version", this.version()).add("intent", this.intent()).add("origin", this.origin()).add("installables", this.installables()).toString();
    }
}

