/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.Key;

@Beta
public final class IntentOperation {
    private final Type type;
    private final Intent intent;

    public IntentOperation(Type type, Intent intent) {
        this.type = Preconditions.checkNotNull(type);
        this.intent = intent;
    }

    public Type type() {
        return this.type;
    }

    public IntentId intentId() {
        return this.intent.id();
    }

    public Key key() {
        return this.intent.key();
    }

    public Intent intent() {
        return this.intent;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.intent});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntentOperation other = (IntentOperation)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.intent, other.intent);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type).add("intent", this.intent).toString();
    }

    public static enum Type {
        SUBMIT,
        WITHDRAW;

    }
}

