/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.Link;
import org.onosproject.net.intent.constraint.BooleanConstraint;
import org.onosproject.net.resource.ResourceRequest;
import org.onosproject.net.resource.ResourceType;
import org.onosproject.net.resource.link.LambdaResource;
import org.onosproject.net.resource.link.LinkResourceService;

@Beta
public class LambdaConstraint
extends BooleanConstraint {
    private final LambdaResource lambda;

    public LambdaConstraint(LambdaResource lambda) {
        this.lambda = lambda;
    }

    private LambdaConstraint() {
        this.lambda = null;
    }

    @Override
    public boolean isValid(Link link, LinkResourceService resourceService) {
        for (ResourceRequest request : resourceService.getAvailableResources(link)) {
            if (request.type() != ResourceType.LAMBDA) continue;
            return true;
        }
        return false;
    }

    public LambdaResource lambda() {
        return this.lambda;
    }

    public int hashCode() {
        return Objects.hash(this.lambda);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LambdaConstraint other = (LambdaConstraint)obj;
        return Objects.equals(this.lambda, other.lambda);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("lambda", this.lambda).toString();
    }
}

