/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource.link;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.onosproject.net.Link;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceRequest;
import org.onosproject.net.resource.ResourceType;
import org.onosproject.net.resource.link.LinkResourceAllocations;
import org.onosproject.net.resource.link.LinkResourceRequest;

public class DefaultLinkResourceAllocations
implements LinkResourceAllocations {
    private final LinkResourceRequest request;
    private final Map<Link, Set<ResourceAllocation>> allocations;

    public DefaultLinkResourceAllocations(LinkResourceRequest request, Map<Link, Set<ResourceAllocation>> allocations) {
        this.request = Preconditions.checkNotNull(request);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Link, Set<ResourceAllocation>> e : allocations.entrySet()) {
            builder.put(e.getKey(), ImmutableSet.copyOf((Collection)e.getValue()));
        }
        this.allocations = builder.build();
    }

    @Override
    public IntentId intentId() {
        return this.request.intentId();
    }

    @Override
    public Collection<Link> links() {
        return this.request.links();
    }

    @Override
    public Set<ResourceRequest> resources() {
        return this.request.resources();
    }

    @Override
    public ResourceType type() {
        return null;
    }

    @Override
    public Set<ResourceAllocation> getResourceAllocation(Link link) {
        Set<ResourceAllocation> result = this.allocations.get(link);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.request, this.allocations);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultLinkResourceAllocations other = (DefaultLinkResourceAllocations)obj;
        return Objects.equals(this.request, other.request) && Objects.equals(this.allocations, other.allocations);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("allocations", this.allocations).toString();
    }
}

