/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.statistic;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.onosproject.net.statistic.Load;

public class DefaultLoad
implements Load {
    private final boolean isValid;
    private final long current;
    private final long previous;
    private final long time;
    private final long interval;
    private static long pollInterval = 10L;

    public DefaultLoad() {
        this.isValid = false;
        this.time = System.currentTimeMillis();
        this.current = -1L;
        this.previous = -1L;
        this.interval = pollInterval;
    }

    public DefaultLoad(long current, long previous) {
        this(current, previous, pollInterval);
    }

    public DefaultLoad(long current, long previous, long interval) {
        Preconditions.checkArgument(interval > 0L, "Interval must be greater than 0");
        this.current = current;
        this.previous = previous;
        this.time = System.currentTimeMillis();
        this.isValid = true;
        this.interval = interval;
    }

    public static void setPollInterval(long newPollInterval) {
        pollInterval = newPollInterval;
    }

    @Override
    public long rate() {
        return (this.current - this.previous) / this.interval;
    }

    @Override
    public long latest() {
        return this.current;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public long time() {
        return this.time;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Load").add("rate", this.rate()).add("latest", this.latest()).toString();
    }
}

