/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import java.util.function.Function;
import org.joda.time.DateTime;

public class Versioned<V> {
    private final V value;
    private final long version;
    private final long creationTime;

    public Versioned(V value, long version, long creationTime) {
        this.value = value;
        this.version = version;
        this.creationTime = creationTime;
    }

    public Versioned(V value, long version) {
        this(value, version, System.currentTimeMillis());
    }

    public V value() {
        return this.value;
    }

    public long version() {
        return this.version;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public <U> Versioned<U> map(Function<V, U> transformer) {
        return new Versioned<U>(transformer.apply(this.value), this.version, this.creationTime);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("value", this.value).add("version", this.version).add("creationTime", new DateTime(this.creationTime)).toString();
    }
}

