/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.olt;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.onlab.packet.VlanId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;

public class AccessDeviceData {
    private static final String DEVICE_ID_MISSING = "Device ID cannot be null";
    private static final String UPLINK_MISSING = "Uplink cannot be null";
    private static final String VLAN_MISSING = "VLAN ID cannot be null";
    private final DeviceId deviceId;
    private final PortNumber uplink;
    private final VlanId vlan;
    private final Optional<VlanId> defaultVlan;

    public AccessDeviceData(DeviceId deviceId, PortNumber uplink, VlanId vlan, Optional<VlanId> defaultVlan) {
        this.deviceId = (DeviceId)Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_MISSING);
        this.uplink = (PortNumber)Preconditions.checkNotNull((Object)uplink, (Object)UPLINK_MISSING);
        this.vlan = (VlanId)Preconditions.checkNotNull((Object)vlan, (Object)VLAN_MISSING);
        this.defaultVlan = (Optional)Preconditions.checkNotNull(defaultVlan);
    }

    public DeviceId deviceId() {
        return this.deviceId;
    }

    public PortNumber uplink() {
        return this.uplink;
    }

    public VlanId vlan() {
        return this.vlan;
    }

    public Optional<VlanId> defaultVlan() {
        return this.defaultVlan;
    }
}

