/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.optical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentOperations;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.TopologyEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpticalPathProvisioner {
    protected static final Logger log = LoggerFactory.getLogger(OpticalPathProvisioner.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PathService pathService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    private ApplicationId appId;
    protected final Map<ConnectPoint, OpticalConnectivityIntent> inStatusTportMap = new ConcurrentHashMap<ConnectPoint, OpticalConnectivityIntent>();
    protected final Map<ConnectPoint, OpticalConnectivityIntent> outStatusTportMap = new ConcurrentHashMap<ConnectPoint, OpticalConnectivityIntent>();
    protected final Map<ConnectPoint, Map<ConnectPoint, Intent>> intentMap = new ConcurrentHashMap<ConnectPoint, Map<ConnectPoint, Intent>>();
    private final InternalOpticalPathProvisioner pathProvisioner = new InternalOpticalPathProvisioner();

    @Activate
    protected void activate() {
        this.intentService.addListener((IntentListener)this.pathProvisioner);
        this.appId = this.coreService.registerApplication("org.onosproject.optical");
        this.initTport();
        log.info("Starting optical path provisoning...");
    }

    protected void initTport() {
        this.inStatusTportMap.clear();
        this.outStatusTportMap.clear();
        for (Intent intent : this.intentService.getIntents()) {
            if (this.intentService.getIntentState(intent.id()) != IntentState.INSTALLED || !(intent instanceof OpticalConnectivityIntent)) continue;
            this.inStatusTportMap.put(((OpticalConnectivityIntent)intent).getSrc(), (OpticalConnectivityIntent)intent);
            this.outStatusTportMap.put(((OpticalConnectivityIntent)intent).getDst(), (OpticalConnectivityIntent)intent);
        }
    }

    protected void deactivate() {
        this.intentService.removeListener((IntentListener)this.pathProvisioner);
    }

    private static boolean isOpticalLink(Link link) {
        boolean isOptical = false;
        Link.Type lt = link.type();
        if (lt == Link.Type.OPTICAL) {
            isOptical = true;
        }
        return isOptical;
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindPathService(PathService pathService) {
        this.pathService = pathService;
    }

    protected void unbindPathService(PathService pathService) {
        if (this.pathService == pathService) {
            this.pathService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    private static class OpticalLinkWeight
    implements LinkWeight {
        private OpticalLinkWeight() {
        }

        public double weight(TopologyEdge edge) {
            if (edge.link().state() == Link.State.INACTIVE) {
                return -1.0;
            }
            if (OpticalPathProvisioner.isOpticalLink(edge.link())) {
                return 1000.0;
            }
            return 1.0;
        }
    }

    public class InternalOpticalPathProvisioner
    implements IntentListener {
        public void event(IntentEvent event) {
            switch ((IntentEvent.Type)event.type()) {
                case INSTALL_REQ: {
                    break;
                }
                case INSTALLED: {
                    break;
                }
                case FAILED: {
                    log.info("packet intent {} failed, calling optical path provisioning APP.", event.subject());
                    this.setupLightpath((Intent)event.subject());
                    break;
                }
                case WITHDRAWN: {
                    log.info("intent {} withdrawn.", event.subject());
                    break;
                }
            }
        }

        private void reserveTport(Intent intent) {
            if (intent instanceof OpticalConnectivityIntent) {
                OpticalConnectivityIntent opticalIntent = (OpticalConnectivityIntent)intent;
                if (OpticalPathProvisioner.this.inStatusTportMap.containsKey(opticalIntent.getSrc()) || OpticalPathProvisioner.this.outStatusTportMap.containsKey(opticalIntent.getDst())) {
                    log.warn("Overlapping reservation: {}", (Object)opticalIntent);
                }
                OpticalPathProvisioner.this.inStatusTportMap.put(opticalIntent.getSrc(), opticalIntent);
                OpticalPathProvisioner.this.outStatusTportMap.put(opticalIntent.getDst(), opticalIntent);
            }
        }

        private boolean addIntent(ConnectPoint src, ConnectPoint dst, Intent intent) {
            Map<ConnectPoint, Intent> srcMap = OpticalPathProvisioner.this.intentMap.get(src);
            if (srcMap == null) {
                srcMap = new ConcurrentHashMap<ConnectPoint, Intent>();
                OpticalPathProvisioner.this.intentMap.put(src, srcMap);
            }
            if (srcMap.containsKey(dst)) {
                return false;
            }
            srcMap.put(dst, intent);
            return true;
        }

        private void setupLightpath(Intent intent) {
            if (!IntentState.FAILED.equals((Object)OpticalPathProvisioner.this.intentService.getIntentState(intent.id()))) {
                return;
            }
            ArrayList intents = Lists.newArrayList();
            if (intent instanceof HostToHostIntent) {
                HostToHostIntent hostToHostIntent = (HostToHostIntent)intent;
                Host one = OpticalPathProvisioner.this.hostService.getHost(hostToHostIntent.one());
                Host two = OpticalPathProvisioner.this.hostService.getHost(hostToHostIntent.two());
                if (one == null || two == null) {
                    return;
                }
                intents.addAll(this.getOpticalPath((ConnectPoint)one.location(), (ConnectPoint)two.location()));
            } else if (intent instanceof PointToPointIntent) {
                PointToPointIntent p2pIntent = (PointToPointIntent)intent;
                intents.addAll(this.getOpticalPath(p2pIntent.ingressPoint(), p2pIntent.egressPoint()));
            } else {
                log.info("Unsupported intent type: {}", intent.getClass());
            }
            IntentOperations.Builder ops = IntentOperations.builder((ApplicationId)OpticalPathProvisioner.this.appId);
            for (Intent i : intents) {
                if (i instanceof OpticalConnectivityIntent) {
                    OpticalConnectivityIntent oi = (OpticalConnectivityIntent)i;
                    if (!this.addIntent(oi.getSrc(), oi.getDst(), (Intent)oi)) continue;
                    ops.addSubmitOperation(i);
                    this.reserveTport(i);
                    continue;
                }
                log.warn("Invalid intent type: {} for {}", i.getClass(), (Object)i);
            }
            OpticalPathProvisioner.this.intentService.execute(ops.build());
        }

        private List<Intent> getOpticalPath(ConnectPoint ingress, ConnectPoint egress) {
            Set paths = OpticalPathProvisioner.this.pathService.getPaths((ElementId)ingress.deviceId(), (ElementId)egress.deviceId(), (LinkWeight)new OpticalLinkWeight());
            if (paths.isEmpty()) {
                return Lists.newArrayList();
            }
            ArrayList connectionList = Lists.newArrayList();
            Iterator itrPath = paths.iterator();
            while (itrPath.hasNext()) {
                boolean usedTportFound = false;
                Path nextPath = (Path)itrPath.next();
                log.info(nextPath.links().toString());
                Iterator itrLink = nextPath.links().iterator();
                while (itrLink.hasNext()) {
                    Link link2;
                    ConnectPoint srcWdmPoint;
                    Link link1 = (Link)itrLink.next();
                    if (!OpticalPathProvisioner.isOpticalLink(link1)) continue;
                    ConnectPoint dstWdmPoint = srcWdmPoint = link1.dst();
                    while (itrLink.hasNext() && OpticalPathProvisioner.isOpticalLink(link2 = (Link)itrLink.next())) {
                        dstWdmPoint = link2.src();
                    }
                    if (OpticalPathProvisioner.this.inStatusTportMap.get(srcWdmPoint) != null || OpticalPathProvisioner.this.outStatusTportMap.get(dstWdmPoint) != null) {
                        usedTportFound = true;
                        break;
                    }
                    OpticalConnectivityIntent opticalIntent = new OpticalConnectivityIntent(OpticalPathProvisioner.this.appId, srcWdmPoint, dstWdmPoint);
                    OpticalConnectivityIntent opticalIntent2 = new OpticalConnectivityIntent(OpticalPathProvisioner.this.appId, dstWdmPoint, srcWdmPoint);
                    log.info("Creating optical intent from {} to {}", (Object)srcWdmPoint, (Object)dstWdmPoint);
                    log.info("Creating optical intent from {} to {}", (Object)dstWdmPoint, (Object)srcWdmPoint);
                    connectionList.add(opticalIntent);
                    connectionList.add(opticalIntent2);
                    break;
                }
                if (!usedTportFound) break;
                connectionList = Lists.newArrayList();
            }
            return connectionList;
        }

        private void teardownLightpath(Intent intent) {
        }
    }
}

