/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.optical.cfg;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.onlab.packet.ChassisId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.optical.cfg.OpticalLinkDescription;
import org.onosproject.optical.cfg.OpticalNetworkConfig;
import org.onosproject.optical.cfg.OpticalSwitchDescription;
import org.onosproject.optical.cfg.PktOptLink;
import org.onosproject.optical.cfg.Roadm;
import org.onosproject.optical.cfg.WdmLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpticalConfigProvider
extends AbstractProvider
implements DeviceProvider,
LinkProvider {
    protected static final Logger log = LoggerFactory.getLogger(OpticalConfigProvider.class);
    private static final String DEFAULT_CONFIG_FILE = "config/demo-3-roadm-2-ps.json";
    private String configFileName = "config/demo-3-roadm-2-ps.json";
    protected LinkProviderRegistry linkProviderRegistry;
    protected DeviceProviderRegistry deviceProviderRegistry;
    private static final String OPTICAL_ANNOTATION = "optical.";
    private LinkProviderService linkProviderService;
    private DeviceProviderService deviceProviderService;
    private static final List<Roadm> RAW_ROADMS = new ArrayList<Roadm>();
    private static final List<WdmLink> RAW_WDMLINKS = new ArrayList<WdmLink>();
    private static final List<PktOptLink> RAW_PKTOPTLINKS = new ArrayList<PktOptLink>();
    private static final String ROADM = "Roadm";
    private static final String WDM_LINK = "wdmLink";
    private static final String PKT_OPT_LINK = "pktOptLink";
    protected OpticalNetworkConfig opticalNetworkConfig;

    public OpticalConfigProvider() {
        super(new ProviderId("optical", "org.onosproject.provider.opticalConfig"));
    }

    protected void activate() {
        this.linkProviderService = (LinkProviderService)this.linkProviderRegistry.register((Provider)this);
        this.deviceProviderService = (DeviceProviderService)this.deviceProviderRegistry.register((Provider)this);
        log.info("Starting optical network configuration process...");
        log.info("Optical config file set to {}", (Object)this.configFileName);
        this.loadOpticalConfig();
        this.parseOpticalConfig();
        this.publishOpticalConfig();
    }

    protected void deactivate() {
        this.linkProviderRegistry.unregister((Provider)this);
        this.linkProviderService = null;
        this.deviceProviderRegistry.unregister((Provider)this);
        this.deviceProviderService = null;
        RAW_ROADMS.clear();
        RAW_WDMLINKS.clear();
        RAW_PKTOPTLINKS.clear();
        log.info("Stopped");
    }

    private void loadOpticalConfig() {
        ObjectMapper mapper = new ObjectMapper();
        this.opticalNetworkConfig = new OpticalNetworkConfig();
        try {
            this.opticalNetworkConfig = (OpticalNetworkConfig)mapper.readValue(new File(this.configFileName), OpticalNetworkConfig.class);
        }
        catch (JsonParseException e) {
            String err = String.format("JsonParseException while loading network config from file: %s: %s", this.configFileName, e.getMessage());
            log.error(err, (Throwable)e);
        }
        catch (JsonMappingException e) {
            String err = String.format("JsonMappingException while loading network config from file: %s: %s", this.configFileName, e.getMessage());
            log.error(err, (Throwable)e);
        }
        catch (IOException e) {
            String err = String.format("IOException while loading network config from file: %s %s", this.configFileName, e.getMessage());
            log.error(err, (Throwable)e);
        }
    }

    private void parseOpticalConfig() {
        List<OpticalSwitchDescription> swList = this.opticalNetworkConfig.getOpticalSwitches();
        List<OpticalLinkDescription> lkList = this.opticalNetworkConfig.getOpticalLinks();
        for (OpticalSwitchDescription sw : swList) {
            String swtype = sw.getType();
            boolean allow = sw.isAllowed();
            if (!swtype.equals(ROADM) || !allow) continue;
            int regNum = 0;
            Set<Map.Entry<String, JsonNode>> m = sw.params.entrySet();
            for (Map.Entry<String, JsonNode> entry : m) {
                String string = entry.getKey();
                JsonNode j = entry.getValue();
                if (!string.equals("numRegen")) continue;
                regNum = j.asInt();
            }
            Roadm newRoadm = new Roadm();
            newRoadm.setName(sw.name);
            newRoadm.setNodeId(sw.nodeDpid);
            newRoadm.setLongtitude(sw.longitude);
            newRoadm.setLatitude(sw.latitude);
            newRoadm.setRegenNum(regNum);
            RAW_ROADMS.add(newRoadm);
            log.info(newRoadm.toString());
        }
        for (OpticalLinkDescription lk : lkList) {
            String lktype;
            switch (lktype = lk.getType()) {
                case "wdmLink": {
                    WdmLink newWdmLink = new WdmLink();
                    newWdmLink.setSrcNodeId(lk.getNodeDpid1());
                    newWdmLink.setSnkNodeId(lk.getNodeDpid2());
                    newWdmLink.setAdminWeight(1000L);
                    Set<Map.Entry<String, JsonNode>> m = lk.params.entrySet();
                    for (Map.Entry<String, JsonNode> entry : m) {
                        String key = entry.getKey();
                        JsonNode j = entry.getValue();
                        if (key.equals("nodeName1")) {
                            newWdmLink.setSrcNodeName(j.asText());
                            continue;
                        }
                        if (key.equals("nodeName2")) {
                            newWdmLink.setSnkNodeName(j.asText());
                            continue;
                        }
                        if (key.equals("port1")) {
                            newWdmLink.setSrcPort(j.asInt());
                            continue;
                        }
                        if (key.equals("port2")) {
                            newWdmLink.setSnkPort(j.asInt());
                            continue;
                        }
                        if (key.equals("distKms")) {
                            newWdmLink.setDistance(j.asDouble());
                            continue;
                        }
                        if (key.equals("numWaves")) {
                            newWdmLink.setWavelengthNumber(j.asInt());
                            continue;
                        }
                        log.error("error found");
                    }
                    RAW_WDMLINKS.add(newWdmLink);
                    log.info(newWdmLink.toString());
                    break;
                }
                case "pktOptLink": {
                    PktOptLink pktOptLink = new PktOptLink();
                    pktOptLink.setSrcNodeId(lk.getNodeDpid1());
                    pktOptLink.setSnkNodeId(lk.getNodeDpid2());
                    pktOptLink.setAdminWeight(10L);
                    Set<Map.Entry<String, JsonNode>> set = lk.params.entrySet();
                    for (Map.Entry<String, JsonNode> e : set) {
                        String key = e.getKey();
                        JsonNode j = e.getValue();
                        if (key.equals("nodeName1")) {
                            pktOptLink.setSrcNodeName(j.asText());
                            continue;
                        }
                        if (key.equals("nodeName2")) {
                            pktOptLink.setSnkNodeName(j.asText());
                            continue;
                        }
                        if (key.equals("port1")) {
                            pktOptLink.setSrcPort(j.asInt());
                            continue;
                        }
                        if (key.equals("port2")) {
                            pktOptLink.setSnkPort(j.asInt());
                            continue;
                        }
                        if (key.equals("bandWidth")) {
                            pktOptLink.setBandwdith(j.asDouble());
                            continue;
                        }
                        log.error("error found");
                    }
                    RAW_PKTOPTLINKS.add(pktOptLink);
                    log.info(pktOptLink.toString());
                    break;
                }
            }
        }
    }

    private void publishOpticalConfig() {
        if (this.deviceProviderService == null || this.linkProviderService == null) {
            return;
        }
        for (Roadm value : RAW_ROADMS) {
            DeviceId did = DeviceId.deviceId((String)("of:" + value.getNodeId().replace(":", "")));
            ChassisId cid = new ChassisId();
            DefaultAnnotations extendedAttributes = DefaultAnnotations.builder().set("optical.switchType", "ROADM").set("optical.switchName", value.getName()).set("optical.latitude", Double.toString(value.getLatitude())).set("optical.longtitude", Double.toString(value.getLongtitude())).set("optical.regNum", Integer.toString(value.getRegenNum())).build();
            DefaultDeviceDescription description = new DefaultDeviceDescription(did.uri(), Device.Type.SWITCH, "", "", "", "", cid, new SparseAnnotations[]{extendedAttributes});
            this.deviceProviderService.deviceConnected(did, (DeviceDescription)description);
        }
        for (WdmLink value : RAW_WDMLINKS) {
            DeviceId srcNodeId = DeviceId.deviceId((String)("of:" + value.getSrcNodeId().replace(":", "")));
            DeviceId snkNodeId = DeviceId.deviceId((String)("of:" + value.getSnkNodeId().replace(":", "")));
            PortNumber srcPort = PortNumber.portNumber((long)value.getSrcPort());
            PortNumber snkPort = PortNumber.portNumber((long)value.getSnkPort());
            ConnectPoint srcPoint = new ConnectPoint((ElementId)srcNodeId, srcPort);
            ConnectPoint snkPoint = new ConnectPoint((ElementId)snkNodeId, snkPort);
            DefaultAnnotations extendedAttributes = DefaultAnnotations.builder().set("optical.linkType", "WDM").set("optical.distance", Double.toString(value.getDistance())).set("optical.cost", Double.toString(value.getDistance())).set("optical.adminWeight", Double.toString(value.getAdminWeight())).set("optical.wavelengthNum", Integer.toString(value.getWavelengthNumber())).build();
            DefaultLinkDescription linkDescription = new DefaultLinkDescription(srcPoint, snkPoint, Link.Type.OPTICAL, new SparseAnnotations[]{extendedAttributes});
            this.linkProviderService.linkDetected((LinkDescription)linkDescription);
            log.info(String.format("WDM link: %s : %s", linkDescription.src().toString(), linkDescription.dst().toString()));
            DefaultLinkDescription linkDescriptionReverse = new DefaultLinkDescription(snkPoint, srcPoint, Link.Type.OPTICAL, new SparseAnnotations[]{extendedAttributes});
            this.linkProviderService.linkDetected((LinkDescription)linkDescriptionReverse);
            log.info(String.format("WDM link: %s : %s", linkDescriptionReverse.src().toString(), linkDescriptionReverse.dst().toString()));
        }
        for (PktOptLink value : RAW_PKTOPTLINKS) {
            DeviceId srcNodeId = DeviceId.deviceId((String)("of:" + value.getSrcNodeId().replace(":", "")));
            DeviceId snkNodeId = DeviceId.deviceId((String)("of:" + value.getSnkNodeId().replace(":", "")));
            PortNumber srcPort = PortNumber.portNumber((long)value.getSrcPort());
            PortNumber snkPort = PortNumber.portNumber((long)value.getSnkPort());
            ConnectPoint srcPoint = new ConnectPoint((ElementId)srcNodeId, srcPort);
            ConnectPoint snkPoint = new ConnectPoint((ElementId)snkNodeId, snkPort);
            DefaultAnnotations extendedAttributes = DefaultAnnotations.builder().set("optical.linkType", "PktOptLink").set("optical.bandwidth", Double.toString(value.getBandwidth())).set("optical.cost", Double.toString(value.getBandwidth())).set("optical.adminWeight", Double.toString(value.getAdminWeight())).build();
            DefaultLinkDescription linkDescription = new DefaultLinkDescription(srcPoint, snkPoint, Link.Type.OPTICAL, new SparseAnnotations[]{extendedAttributes});
            this.linkProviderService.linkDetected((LinkDescription)linkDescription);
            log.info(String.format("Packet-optical link: %s : %s", linkDescription.src().toString(), linkDescription.dst().toString()));
            DefaultLinkDescription linkDescriptionReverse = new DefaultLinkDescription(snkPoint, srcPoint, Link.Type.OPTICAL, new SparseAnnotations[]{extendedAttributes});
            this.linkProviderService.linkDetected((LinkDescription)linkDescriptionReverse);
            log.info(String.format("Packet-optical link: %s : %s", linkDescriptionReverse.src().toString(), linkDescriptionReverse.dst().toString()));
        }
    }

    public void triggerProbe(DeviceId deviceId) {
    }

    public void roleChanged(DeviceId device, MastershipRole newRole) {
    }

    public boolean isReachable(DeviceId device) {
        return false;
    }
}

