/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.optical.testapp;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.IndexedLambda;
import org.onosproject.net.Lambda;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaForwarding {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    private ApplicationId appId;
    private final InternalDeviceListener listener = new InternalDeviceListener();
    private final Map<DeviceId, Integer> uglyMap = new HashMap<DeviceId, Integer>();

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.fwd");
        this.uglyMap.put(DeviceId.deviceId((String)"of:0000ffffffffff01"), 1);
        this.uglyMap.put(DeviceId.deviceId((String)"of:0000ffffffffff02"), 2);
        this.uglyMap.put(DeviceId.deviceId((String)"of:0000ffffffffff03"), 3);
        this.deviceService.addListener((EventListener)this.listener);
        for (Device d : this.deviceService.getDevices()) {
            this.pushRules(d);
        }
        this.log.info("Started with Application ID {}", (Object)this.appId.id());
    }

    @Deactivate
    public void deactivate() {
        this.flowRuleService.removeFlowRulesById(this.appId);
        this.log.info("Stopped");
    }

    private void pushRules(Device device) {
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder();
        int lambda = 10;
        boolean sigType = true;
        Integer switchNumber = this.uglyMap.get(device.id());
        if (switchNumber == null) {
            return;
        }
        switch (switchNumber) {
            case 1: {
                int inport = 10;
                int outport = 20;
                sbuilder.matchInPort(PortNumber.portNumber((long)inport));
                tbuilder.setOutput(PortNumber.portNumber((long)outport)).add((Instruction)Instructions.modL0Lambda((Lambda)new IndexedLambda((long)lambda)));
                break;
            }
            case 2: {
                int inport = 21;
                int outport = 11;
                sbuilder.add(Criteria.matchLambda((Lambda)new IndexedLambda((long)lambda))).matchInPort(PortNumber.portNumber((long)inport));
                tbuilder.setOutput(PortNumber.portNumber((long)outport));
                break;
            }
            case 3: {
                int inport = 30;
                int outport = 31;
                sbuilder.add(Criteria.matchLambda((Lambda)new IndexedLambda((long)lambda))).matchInPort(PortNumber.portNumber((long)inport));
                tbuilder.setOutput(PortNumber.portNumber((long)outport)).add((Instruction)Instructions.modL0Lambda((Lambda)new IndexedLambda((long)lambda)));
                break;
            }
        }
        TrafficTreatment treatment = tbuilder.build();
        TrafficSelector selector = sbuilder.build();
        FlowRule f = DefaultFlowRule.builder().forDevice(device.id()).withSelector(selector).withTreatment(treatment).withPriority(100).fromApp(this.appId).makeTemporary(600).build();
        this.flowRuleService.applyFlowRules(new FlowRule[]{f});
    }

    public class InternalDeviceListener
    implements DeviceListener {
        public void event(DeviceEvent event) {
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_ADDED: {
                    LambdaForwarding.this.pushRules((Device)event.subject());
                    break;
                }
                case DEVICE_AVAILABILITY_CHANGED: {
                    break;
                }
                case DEVICE_REMOVED: {
                    break;
                }
                case DEVICE_SUSPENDED: {
                    break;
                }
                case DEVICE_UPDATED: {
                    break;
                }
                case PORT_ADDED: {
                    break;
                }
                case PORT_REMOVED: {
                    break;
                }
                case PORT_UPDATED: {
                    break;
                }
            }
        }
    }
}

