/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.optical.testapp;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MplsLabel;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPLSForwarding {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    private ApplicationId appId;
    private final InternalDeviceListener listener = new InternalDeviceListener();
    private final Map<DeviceId, Integer> uglyMap = new HashMap<DeviceId, Integer>();

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.testapp.mplsfwd");
        this.uglyMap.put(DeviceId.deviceId((String)"of:0000000000000001"), 1);
        this.uglyMap.put(DeviceId.deviceId((String)"of:0000000000000002"), 2);
        this.uglyMap.put(DeviceId.deviceId((String)"of:0000000000000003"), 3);
        this.deviceService.addListener((EventListener)this.listener);
        for (Device d : this.deviceService.getDevices()) {
            this.pushRules(d);
        }
        this.log.info("Started with Application ID {}", (Object)this.appId.id());
    }

    @Deactivate
    public void deactivate() {
        this.flowRuleService.removeFlowRulesById(this.appId);
        this.log.info("Stopped");
    }

    private void pushRules(Device device) {
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder();
        int inport = 1;
        int outport = 2;
        MplsLabel mplsLabel = MplsLabel.mplsLabel((int)101);
        Integer switchNumber = this.uglyMap.get(device.id());
        if (switchNumber == null) {
            return;
        }
        switch (switchNumber) {
            case 1: {
                sbuilder.matchInPort(PortNumber.portNumber((long)inport));
                tbuilder.setOutput(PortNumber.portNumber((long)outport)).pushMpls().setMpls(mplsLabel);
                break;
            }
            case 2: {
                sbuilder.matchMplsLabel(mplsLabel).matchEthType(Ethernet.MPLS_UNICAST).matchInPort(PortNumber.portNumber((long)inport));
                tbuilder.setOutput(PortNumber.portNumber((long)outport));
                break;
            }
            case 3: {
                sbuilder.matchMplsLabel(mplsLabel).matchEthType(Ethernet.MPLS_UNICAST).matchInPort(PortNumber.portNumber((long)inport));
                tbuilder.popMpls().setOutput(PortNumber.portNumber((long)outport));
                break;
            }
        }
        TrafficTreatment treatement = tbuilder.build();
        TrafficSelector selector = sbuilder.build();
        FlowRule f = DefaultFlowRule.builder().forDevice(device.id()).withSelector(selector).withTreatment(treatement).withPriority(100).fromApp(this.appId).makeTemporary(600).build();
        this.flowRuleService.applyFlowRules(new FlowRule[]{f});
    }

    public class InternalDeviceListener
    implements DeviceListener {
        public void event(DeviceEvent event) {
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_ADDED: {
                    MPLSForwarding.this.pushRules((Device)event.subject());
                    break;
                }
                case DEVICE_AVAILABILITY_CHANGED: {
                    break;
                }
                case DEVICE_REMOVED: {
                    break;
                }
                case DEVICE_SUSPENDED: {
                    break;
                }
                case DEVICE_UPDATED: {
                    break;
                }
                case PORT_ADDED: {
                    break;
                }
                case PORT_REMOVED: {
                    break;
                }
                case PORT_UPDATED: {
                    break;
                }
            }
        }
    }
}

