/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.optical;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Port;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpticalLinkProvider
extends AbstractProvider
implements LinkProvider {
    private static final Logger log = LoggerFactory.getLogger(OpticalLinkProvider.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkProviderRegistry registry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    private LinkProviderService providerService;
    private DeviceListener deviceListener = new InternalDeviceListener();
    private LinkListener linkListener = new InternalLinkListener();

    public OpticalLinkProvider() {
        super(new ProviderId("optical", "org.onosproject.optical"));
    }

    @Activate
    protected void activate() {
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.linkService.addListener((EventListener)this.linkListener);
        this.providerService = (LinkProviderService)this.registry.register((Provider)this);
        log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.linkService.removeListener((EventListener)this.linkListener);
        this.registry.unregister((Provider)this);
        log.info("Stopped");
    }

    private void processDeviceLinks(Device device) {
        for (Link link : this.linkService.getDeviceLinks(device.id())) {
            if (!link.isDurable() || link.type() != Link.Type.OPTICAL) continue;
            this.processLink(link);
        }
    }

    private void processPortLinks(Device device, Port port) {
        ConnectPoint connectPoint = new ConnectPoint((ElementId)device.id(), port.number());
        for (Link link : this.linkService.getLinks(connectPoint)) {
            if (!link.isDurable() || link.type() != Link.Type.OPTICAL) continue;
            this.processLink(link);
        }
    }

    private void processLink(Link link) {
        DeviceId srcId = link.src().deviceId();
        DeviceId dstId = link.dst().deviceId();
        Port srcPort = this.deviceService.getPort(srcId, link.src().port());
        Port dstPort = this.deviceService.getPort(dstId, link.dst().port());
        if (srcPort == null || dstPort == null) {
            return;
        }
        boolean active = this.deviceService.isAvailable(srcId) && this.deviceService.isAvailable(dstId) && srcPort.isEnabled() && dstPort.isEnabled();
        DefaultLinkDescription desc = new DefaultLinkDescription(link.src(), link.dst(), Link.Type.OPTICAL, new SparseAnnotations[0]);
        if (active) {
            this.providerService.linkDetected((LinkDescription)desc);
        } else {
            this.providerService.linkVanished((LinkDescription)desc);
        }
    }

    protected void bindRegistry(LinkProviderRegistry linkProviderRegistry) {
        this.registry = linkProviderRegistry;
    }

    protected void unbindRegistry(LinkProviderRegistry linkProviderRegistry) {
        if (this.registry == linkProviderRegistry) {
            this.registry = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    private class InternalLinkListener
    implements LinkListener {
        private InternalLinkListener() {
        }

        public void event(LinkEvent event) {
            Link link;
            if (event.type() == LinkEvent.Type.LINK_ADDED && (link = (Link)event.subject()).providerId().scheme().equals("cfg")) {
                OpticalLinkProvider.this.processLink((Link)event.subject());
            }
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            DeviceEvent.Type type = (DeviceEvent.Type)event.type();
            Device device = (Device)event.subject();
            if (type == DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED || type == DeviceEvent.Type.DEVICE_ADDED || type == DeviceEvent.Type.DEVICE_UPDATED) {
                OpticalLinkProvider.this.processDeviceLinks(device);
            } else if (type == DeviceEvent.Type.PORT_UPDATED) {
                OpticalLinkProvider.this.processPortLinks(device, event.port());
            }
        }
    }
}

