/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.optical;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.Link;
import org.onosproject.net.OchPort;
import org.onosproject.net.OduCltPort;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.Path;
import org.onosproject.net.Port;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.OpticalCircuitIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.TopologyEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpticalPathProvisioner {
    protected static final Logger log = LoggerFactory.getLogger(OpticalPathProvisioner.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PathService pathService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    private ApplicationId appId;
    private final InternalOpticalPathProvisioner pathProvisioner = new InternalOpticalPathProvisioner();

    @Activate
    protected void activate() {
        this.intentService.addListener((EventListener)this.pathProvisioner);
        this.appId = this.coreService.registerApplication("org.onosproject.optical");
        this.initOpticalPorts();
        log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.intentService.removeListener((EventListener)this.pathProvisioner);
        log.info("Stopped");
    }

    private void initOpticalPorts() {
    }

    private boolean isPacketLayer(Device.Type type) {
        return type == Device.Type.SWITCH || type == Device.Type.ROUTER || type == Device.Type.VIRTUAL;
    }

    private boolean isTransportLayer(Device.Type type) {
        return type == Device.Type.ROADM || type == Device.Type.OTN || type == Device.Type.ROADM_OTN;
    }

    private boolean isCrossConnectLink(Link link) {
        Device.Type dst;
        if (link.type() != Link.Type.OPTICAL) {
            return false;
        }
        Device.Type src = this.deviceService.getDevice(link.src().deviceId()).type();
        return src != (dst = this.deviceService.getDevice(link.dst().deviceId()).type()) && (this.isPacketLayer(src) && this.isTransportLayer(dst) || this.isPacketLayer(dst) && this.isTransportLayer(src));
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindPathService(PathService pathService) {
        this.pathService = pathService;
    }

    protected void unbindPathService(PathService pathService) {
        if (this.pathService == pathService) {
            this.pathService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    public class InternalOpticalPathProvisioner
    implements IntentListener {
        public void event(IntentEvent event) {
            switch ((IntentEvent.Type)event.type()) {
                case INSTALL_REQ: {
                    break;
                }
                case INSTALLED: {
                    break;
                }
                case FAILED: {
                    log.info("Intent {} failed, calling optical path provisioning app.", event.subject());
                    this.setupLightpath((Intent)event.subject());
                    break;
                }
            }
        }

        private void setupLightpath(Intent intent) {
            NodeId sourceMaster;
            ConnectPoint dst;
            ConnectPoint src;
            Preconditions.checkNotNull((Object)intent);
            if (OpticalPathProvisioner.this.intentService.getIntentState(intent.key()) != IntentState.FAILED) {
                return;
            }
            if (intent instanceof HostToHostIntent) {
                HostToHostIntent hostToHostIntent = (HostToHostIntent)intent;
                Host one = OpticalPathProvisioner.this.hostService.getHost(hostToHostIntent.one());
                Host two = OpticalPathProvisioner.this.hostService.getHost(hostToHostIntent.two());
                Preconditions.checkNotNull((Object)one);
                Preconditions.checkNotNull((Object)two);
                src = one.location();
                dst = two.location();
            } else if (intent instanceof PointToPointIntent) {
                PointToPointIntent p2pIntent = (PointToPointIntent)intent;
                src = p2pIntent.ingressPoint();
                dst = p2pIntent.egressPoint();
            } else {
                return;
            }
            if (src == null || dst == null) {
                return;
            }
            NodeId localNode = OpticalPathProvisioner.this.clusterService.getLocalNode().id();
            if (!localNode.equals((Object)(sourceMaster = OpticalPathProvisioner.this.mastershipService.getMasterFor(src.deviceId())))) {
                return;
            }
            List<Intent> intents = this.getOpticalIntents(src, dst);
            for (Intent i : intents) {
                OpticalPathProvisioner.this.intentService.submit(i);
                log.debug("Submitted an intent: {}", (Object)i);
            }
        }

        private List<ConnectPoint> getCrossConnectPoints(Path path) {
            boolean scanning = false;
            LinkedList<ConnectPoint> connectPoints = new LinkedList<ConnectPoint>();
            for (Link link : path.links()) {
                if (!OpticalPathProvisioner.this.isCrossConnectLink(link)) continue;
                if (scanning) {
                    connectPoints.add((ConnectPoint)Preconditions.checkNotNull((Object)link.src()));
                    scanning = false;
                    continue;
                }
                connectPoints.add((ConnectPoint)Preconditions.checkNotNull((Object)link.dst()));
                scanning = true;
            }
            return connectPoints;
        }

        private boolean checkCrossConnectPoints(List<ConnectPoint> crossConnectPoints) {
            Preconditions.checkArgument((crossConnectPoints.size() % 2 == 0 ? 1 : 0) != 0);
            Iterator<ConnectPoint> itr = crossConnectPoints.iterator();
            while (itr.hasNext()) {
                Device.Type dstType;
                ConnectPoint src = itr.next();
                ConnectPoint dst = itr.next();
                Device.Type srcType = OpticalPathProvisioner.this.deviceService.getDevice(src.deviceId()).type();
                if (srcType == (dstType = OpticalPathProvisioner.this.deviceService.getDevice(dst.deviceId()).type())) continue;
                log.warn("Unsupported mix of cross connect points");
                return false;
            }
            return true;
        }

        private List<Intent> getIntents(List<ConnectPoint> crossConnectPoints) {
            Preconditions.checkArgument((crossConnectPoints.size() % 2 == 0 ? 1 : 0) != 0);
            LinkedList<Intent> intents = new LinkedList<Intent>();
            Iterator<ConnectPoint> itr = crossConnectPoints.iterator();
            while (itr.hasNext()) {
                ConnectPoint src = itr.next();
                ConnectPoint dst = itr.next();
                Port srcPort = OpticalPathProvisioner.this.deviceService.getPort(src.deviceId(), src.port());
                Port dstPort = OpticalPathProvisioner.this.deviceService.getPort(dst.deviceId(), dst.port());
                if (srcPort instanceof OduCltPort && dstPort instanceof OduCltPort) {
                    OpticalCircuitIntent circuitIntent = OpticalCircuitIntent.builder().appId(OpticalPathProvisioner.this.appId).src(src).dst(dst).signalType(CltSignalType.CLT_10GBE).bidirectional(true).build();
                    intents.add((Intent)circuitIntent);
                    continue;
                }
                if (srcPort instanceof OchPort && dstPort instanceof OchPort) {
                    OpticalConnectivityIntent opticalIntent = OpticalConnectivityIntent.builder().appId(OpticalPathProvisioner.this.appId).src(src).dst(dst).signalType(OduSignalType.ODU4).bidirectional(true).build();
                    intents.add((Intent)opticalIntent);
                    continue;
                }
                log.warn("Unsupported cross connect point types {} {}", (Object)srcPort.type(), (Object)dstPort.type());
                return Collections.emptyList();
            }
            return intents;
        }

        private List<Intent> getOpticalIntents(ConnectPoint ingress, ConnectPoint egress) {
            Set paths = OpticalPathProvisioner.this.pathService.getPaths((ElementId)ingress.deviceId(), (ElementId)egress.deviceId(), (LinkWeight)new OpticalLinkWeight());
            if (paths.isEmpty()) {
                return Collections.emptyList();
            }
            for (Path path : paths) {
                List<ConnectPoint> crossConnectPoints = this.getCrossConnectPoints(path);
                if (!this.checkCrossConnectPoints(crossConnectPoints)) continue;
                return this.getIntents(crossConnectPoints);
            }
            log.warn("Unable to find multi-layer path.");
            return Collections.emptyList();
        }

        private class OpticalLinkWeight
        implements LinkWeight {
            private OpticalLinkWeight() {
            }

            public double weight(TopologyEdge edge) {
                if (edge.link().state() == Link.State.INACTIVE) {
                    return -1.0;
                }
                if (edge.link().type() == Link.Type.OPTICAL) {
                    return 1000.0;
                }
                return 1.0;
            }
        }
    }
}

