/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.resource.label.LabelResourceService;
import org.onosproject.incubator.net.tunnel.DefaultTunnel;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.pce.pceservice.BasicPceccHandler;
import org.onosproject.pce.pceservice.PceManagerTest;
import org.onosproject.pce.pcestore.PceccTunnelInfo;
import org.onosproject.pce.pcestore.api.LspLocalLabelInfo;
import org.onosproject.pce.pcestore.api.PceStore;
import org.onosproject.pce.util.LabelResourceAdapter;
import org.onosproject.pce.util.PceStoreAdapter;

public class BasicPceccHandlerTest {
    public static final long LOCAL_LABEL_SPACE_MIN = 5122L;
    public static final long LOCAL_LABEL_SPACE_MAX = 9217L;
    private BasicPceccHandler pceccHandler;
    protected LabelResourceService labelRsrcService;
    protected PceStore pceStore;
    private FlowObjectiveService flowObjectiveService;
    private CoreService coreService;
    private ApplicationId appId;
    private TunnelEndPoint src = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((int)23423));
    private TunnelEndPoint dst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((int)32421));
    private DefaultGroupId groupId = new DefaultGroupId(92034);
    private TunnelName tunnelName = TunnelName.tunnelName((String)"TunnelName");
    private TunnelId tunnelId = TunnelId.valueOf((String)"41654654");
    private ProviderId producerName = new ProviderId("producer1", "13");
    private Path path;
    private Tunnel tunnel;
    private PceccTunnelInfo pceccTunnelInfo;
    private DeviceId deviceId1;
    private DeviceId deviceId2;
    private DeviceId deviceId3;
    private DeviceId deviceId4;
    private DeviceId deviceId5;
    private PortNumber port1;
    private PortNumber port2;
    private PortNumber port3;
    private PortNumber port4;
    private PortNumber port5;

    @Before
    public void setUp() throws Exception {
        this.pceccHandler = BasicPceccHandler.getInstance();
        this.labelRsrcService = new LabelResourceAdapter();
        this.pceStore = new PceStoreAdapter();
        this.flowObjectiveService = new PceManagerTest.MockFlowObjService();
        this.coreService = new PceManagerTest.MockCoreService();
        this.appId = this.coreService.registerApplication("org.onosproject.pce");
        this.pceccHandler.initialize(this.labelRsrcService, this.flowObjectiveService, this.appId, this.pceStore);
        ProviderId providerId = new ProviderId("of", "foo");
        this.deviceId1 = DeviceId.deviceId((String)"of:A");
        this.deviceId2 = DeviceId.deviceId((String)"of:B");
        this.deviceId3 = DeviceId.deviceId((String)"of:C");
        this.deviceId4 = DeviceId.deviceId((String)"of:D");
        this.deviceId5 = DeviceId.deviceId((String)"of:E");
        this.port1 = PortNumber.portNumber((long)1L);
        this.port2 = PortNumber.portNumber((long)2L);
        this.port3 = PortNumber.portNumber((long)3L);
        this.port4 = PortNumber.portNumber((long)4L);
        this.port5 = PortNumber.portNumber((long)5L);
        LinkedList<DefaultLink> linkList = new LinkedList<DefaultLink>();
        DefaultLink l1 = DefaultLink.builder().providerId(providerId).annotations((Annotations)DefaultAnnotations.builder().set("key1", "yahoo").build()).src(new ConnectPoint((ElementId)this.deviceId1, this.port1)).dst(new ConnectPoint((ElementId)this.deviceId2, this.port2)).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
        linkList.add(l1);
        DefaultLink l2 = DefaultLink.builder().providerId(providerId).annotations((Annotations)DefaultAnnotations.builder().set("key2", "yahoo").build()).src(new ConnectPoint((ElementId)this.deviceId2, this.port2)).dst(new ConnectPoint((ElementId)this.deviceId3, this.port3)).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
        linkList.add(l2);
        DefaultLink l3 = DefaultLink.builder().providerId(providerId).annotations((Annotations)DefaultAnnotations.builder().set("key3", "yahoo").build()).src(new ConnectPoint((ElementId)this.deviceId3, this.port3)).dst(new ConnectPoint((ElementId)this.deviceId4, this.port4)).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
        linkList.add(l3);
        DefaultLink l4 = DefaultLink.builder().providerId(providerId).annotations((Annotations)DefaultAnnotations.builder().set("key4", "yahoo").build()).src(new ConnectPoint((ElementId)this.deviceId4, this.port4)).dst(new ConnectPoint((ElementId)this.deviceId5, this.port5)).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
        linkList.add(l4);
        this.path = new DefaultPath(providerId, linkList, 10.0, new Annotations[0]);
        this.tunnel = new DefaultTunnel(this.producerName, this.src, this.dst, Tunnel.Type.VXLAN, Tunnel.State.ACTIVE, this.groupId, this.tunnelId, this.tunnelName, this.path, new Annotations[0]);
    }

    @After
    public void tearDown() throws Exception {
        PceManagerTest.flowsDownloaded = 0;
    }

    @Test
    public void testGetInstance() {
        MatcherAssert.assertThat((Object)this.pceccHandler, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAllocateLabel() {
        MatcherAssert.assertThat((Object)this.pceccHandler.allocateLabel(this.tunnel), (Matcher)Matchers.is((Object)true));
        this.pceccTunnelInfo = this.pceStore.getTunnelInfo(this.tunnel.tunnelId());
        List lspLocalLabelInfoList = this.pceccTunnelInfo.lspLocalLabelInfoList();
        Iterator iterator = lspLocalLabelInfoList.iterator();
        LspLocalLabelInfo lspLocalLabelInfo = (LspLocalLabelInfo)iterator.next();
        DeviceId deviceId = lspLocalLabelInfo.deviceId();
        LabelResourceId inLabelId = lspLocalLabelInfo.inLabelId();
        LabelResourceId outLabelId = lspLocalLabelInfo.outLabelId();
        PortNumber inPort = lspLocalLabelInfo.inPort();
        PortNumber outPort = lspLocalLabelInfo.outPort();
        MatcherAssert.assertThat((Object)deviceId, (Matcher)Matchers.is((Object)this.deviceId5));
        MatcherAssert.assertThat((Object)inLabelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)outLabelId, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)inPort, (Matcher)Matchers.is((Object)this.port5));
        MatcherAssert.assertThat((Object)outPort, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        lspLocalLabelInfo = (LspLocalLabelInfo)iterator.next();
        deviceId = lspLocalLabelInfo.deviceId();
        inLabelId = lspLocalLabelInfo.inLabelId();
        outLabelId = lspLocalLabelInfo.outLabelId();
        inPort = lspLocalLabelInfo.inPort();
        outPort = lspLocalLabelInfo.outPort();
        MatcherAssert.assertThat((Object)deviceId, (Matcher)Matchers.is((Object)this.deviceId4));
        MatcherAssert.assertThat((Object)inLabelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)outLabelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inPort, (Matcher)Matchers.is((Object)this.port4));
        MatcherAssert.assertThat((Object)outPort, (Matcher)Matchers.is((Object)this.port5));
        lspLocalLabelInfo = (LspLocalLabelInfo)iterator.next();
        deviceId = lspLocalLabelInfo.deviceId();
        inLabelId = lspLocalLabelInfo.inLabelId();
        outLabelId = lspLocalLabelInfo.outLabelId();
        inPort = lspLocalLabelInfo.inPort();
        outPort = lspLocalLabelInfo.outPort();
        MatcherAssert.assertThat((Object)deviceId, (Matcher)Matchers.is((Object)this.deviceId3));
        MatcherAssert.assertThat((Object)inLabelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)outLabelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inPort, (Matcher)Matchers.is((Object)this.port3));
        MatcherAssert.assertThat((Object)outPort, (Matcher)Matchers.is((Object)this.port4));
        lspLocalLabelInfo = (LspLocalLabelInfo)iterator.next();
        deviceId = lspLocalLabelInfo.deviceId();
        inLabelId = lspLocalLabelInfo.inLabelId();
        outLabelId = lspLocalLabelInfo.outLabelId();
        inPort = lspLocalLabelInfo.inPort();
        outPort = lspLocalLabelInfo.outPort();
        MatcherAssert.assertThat((Object)deviceId, (Matcher)Matchers.is((Object)this.deviceId2));
        MatcherAssert.assertThat((Object)inLabelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)outLabelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inPort, (Matcher)Matchers.is((Object)this.port2));
        MatcherAssert.assertThat((Object)outPort, (Matcher)Matchers.is((Object)this.port3));
        lspLocalLabelInfo = (LspLocalLabelInfo)iterator.next();
        deviceId = lspLocalLabelInfo.deviceId();
        inLabelId = lspLocalLabelInfo.inLabelId();
        outLabelId = lspLocalLabelInfo.outLabelId();
        inPort = lspLocalLabelInfo.inPort();
        outPort = lspLocalLabelInfo.outPort();
        MatcherAssert.assertThat((Object)deviceId, (Matcher)Matchers.is((Object)this.deviceId1));
        MatcherAssert.assertThat((Object)inLabelId, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)outLabelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inPort, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)outPort, (Matcher)Matchers.is((Object)this.port2));
    }

    @Test
    public void testReleaseLabel() {
        MatcherAssert.assertThat((Object)this.pceccHandler.allocateLabel(this.tunnel), (Matcher)Matchers.is((Object)true));
        this.pceccHandler.releaseLabel(this.tunnel);
        this.pceccTunnelInfo = this.pceStore.getTunnelInfo(this.tunnel.tunnelId());
        MatcherAssert.assertThat((Object)this.pceccTunnelInfo, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

