/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.pce.pceservice.DefaultPcePath;
import org.onosproject.pce.pceservice.LspType;
import org.onosproject.pce.pceservice.PcePath;
import org.onosproject.pce.pceservice.constraint.CostConstraint;

public class DefaultPcePathTest {
    @Test
    public void testEquals() {
        String cost1 = "1";
        String bandwidth1 = "200";
        String src1 = "foo";
        String dst1 = "bee";
        String type1 = "1";
        String name1 = "pcc";
        PcePath path1 = DefaultPcePath.builder().source("foo").destination("bee").lspType("1").name("pcc").costConstraint("1").bandwidthConstraint("200").build();
        path1.id(TunnelId.valueOf((String)"1"));
        PcePath samePath1 = DefaultPcePath.builder().source("foo").destination("bee").lspType("1").name("pcc").costConstraint("1").bandwidthConstraint("200").build();
        samePath1.id(TunnelId.valueOf((String)"1"));
        String cost2 = "1";
        String bandwidth2 = "200";
        String src2 = "google";
        String dst2 = "yahoo";
        String type2 = "2";
        String name2 = "pcc2";
        PcePath path2 = DefaultPcePath.builder().source("google").destination("yahoo").lspType("2").name("pcc2").costConstraint("1").bandwidthConstraint("200").build();
        path2.id(TunnelId.valueOf((String)"2"));
        new EqualsTester().addEqualityGroup(new Object[]{path1, samePath1}).addEqualityGroup(new Object[]{path2}).testEquals();
    }

    @Test
    public void testConstruction() {
        String cost = "1";
        String bandwidth = "600";
        String src = "indiatimes";
        String dst = "deccan";
        String type = "2";
        String name = "pcc4";
        PcePath path = DefaultPcePath.builder().source("indiatimes").destination("deccan").lspType("2").name("pcc4").costConstraint("1").bandwidthConstraint("600").build();
        MatcherAssert.assertThat((Object)path.source(), (Matcher)Matchers.is((Object)"indiatimes"));
        MatcherAssert.assertThat((Object)path.destination(), (Matcher)Matchers.is((Object)"deccan"));
        MatcherAssert.assertThat((Object)path.lspType(), (Matcher)Matchers.is((Object)LspType.WITHOUT_SIGNALLING_AND_WITHOUT_SR));
        MatcherAssert.assertThat((Object)path.name(), (Matcher)Matchers.is((Object)"pcc4"));
        CostConstraint costConstExpected = CostConstraint.of((CostConstraint.Type)CostConstraint.Type.values()[Integer.valueOf("1") - 1]);
        CostConstraint costConstActual = (CostConstraint)path.costConstraint();
        MatcherAssert.assertThat((Object)costConstActual.type(), (Matcher)Matchers.is((Object)costConstExpected.type()));
        BandwidthConstraint bandwidthActual = (BandwidthConstraint)path.bandwidthConstraint();
        MatcherAssert.assertThat((Object)bandwidthActual.bandwidth().bps(), (Matcher)Matchers.is((Object)Double.valueOf("600")));
    }
}

