/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.DijkstraGraphSearch;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Path;
import org.onlab.graph.Vertex;
import org.onlab.packet.ChassisId;
import org.onlab.util.Bandwidth;
import org.onlab.util.Tools;
import org.onosproject.core.CoreService;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistryAdapter;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.resource.ContinuousResource;
import org.onosproject.net.resource.ContinuousResourceId;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.net.resource.Resources;
import org.onosproject.net.topology.DefaultTopologyEdge;
import org.onosproject.net.topology.DefaultTopologyVertex;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyVertex;
import org.onosproject.pce.pceservice.PceManager;
import org.onosproject.pce.pceservice.ResourceServiceAdapter;
import org.onosproject.pce.pceservice.constraint.CapabilityConstraint;
import org.onosproject.pce.pceservice.constraint.CostConstraint;
import org.onosproject.pce.pceservice.constraint.SharedBandwidthConstraint;
import org.onosproject.pcep.api.DeviceCapability;

public class PathComputationTest {
    private final MockPathResourceService resourceService = new MockPathResourceService();
    private final MockDeviceService deviceService = new MockDeviceService();
    private final MockNetConfigRegistryAdapter netConfigRegistry = new MockNetConfigRegistryAdapter();
    private PceManager pceManager = new PceManager();
    public static ProviderId providerId = new ProviderId("pce", "foo");
    public static final String DEVICE1 = "D001";
    public static final String DEVICE2 = "D002";
    public static final String DEVICE3 = "D003";
    public static final String DEVICE4 = "D004";
    public static final String DEVICE5 = "D005";
    public static final String PCEPDEVICE1 = "PD001";
    public static final String PCEPDEVICE2 = "PD002";
    public static final String PCEPDEVICE3 = "PD003";
    public static final String PCEPDEVICE4 = "PD004";
    public static final TopologyVertex D1 = new DefaultTopologyVertex(DeviceId.deviceId((String)"D001"));
    public static final TopologyVertex D2 = new DefaultTopologyVertex(DeviceId.deviceId((String)"D002"));
    public static final TopologyVertex D3 = new DefaultTopologyVertex(DeviceId.deviceId((String)"D003"));
    public static final TopologyVertex D4 = new DefaultTopologyVertex(DeviceId.deviceId((String)"D004"));
    public static final TopologyVertex D5 = new DefaultTopologyVertex(DeviceId.deviceId((String)"D005"));
    private static final String ANNOTATION_COST = "cost";
    private static final String ANNOTATION_TE_COST = "teCost";
    private static final String UNKNOWN = "unknown";
    public static final String LSRID = "lsrId";
    public static final String L3 = "L3";
    public static final String PCECC_CAPABILITY = "pceccCapability";
    public static final String SR_CAPABILITY = "srCapability";
    public static final String LABEL_STACK_CAPABILITY = "labelStackCapability";

    @Before
    public void startUp() {
        this.pceManager.resourceService = this.resourceService;
        this.pceManager.deviceService = this.deviceService;
        this.pceManager.netCfgService = this.netConfigRegistry;
    }

    public static AbstractGraphPathSearch<TopologyVertex, TopologyEdge> graphSearch() {
        return new DijkstraGraphSearch();
    }

    public static Link addLink(String device, long port, String device2, long port2, boolean setCost, int value) {
        ConnectPoint src = new ConnectPoint((ElementId)DeviceId.deviceId((String)device), PortNumber.portNumber((long)port));
        ConnectPoint dst = new ConnectPoint((ElementId)DeviceId.deviceId((String)device2), PortNumber.portNumber((long)port2));
        DefaultAnnotations.Builder annotationBuilder = DefaultAnnotations.builder();
        if (setCost) {
            annotationBuilder.set(ANNOTATION_COST, String.valueOf(value));
        } else {
            annotationBuilder.set(ANNOTATION_TE_COST, String.valueOf(value));
        }
        DefaultLink curLink = DefaultLink.builder().src(src).dst(dst).state(Link.State.ACTIVE).type(Link.Type.DIRECT).providerId(providerId).annotations((Annotations)annotationBuilder.build()).build();
        return curLink;
    }

    @After
    public void tearDown() {
        this.pceManager.resourceService = null;
        this.pceManager.deviceService = null;
        this.pceManager.netCfgService = null;
    }

    private LinkWeight weight(List<Constraint> constraints) {
        return new MockTeConstraintBasedLinkWeight(constraints);
    }

    private Set<org.onosproject.net.Path> computePath(Link link1, Link link2, Link link3, Link link4, List<Constraint> constraints) {
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)D1, (Object)D2, (Object)D3, (Object)D4), (Set)ImmutableSet.of((Object)new DefaultTopologyEdge(D1, D2, link1), (Object)new DefaultTopologyEdge(D2, D4, link2), (Object)new DefaultTopologyEdge(D1, D3, link3), (Object)new DefaultTopologyEdge(D3, D4, link4)));
        GraphPathSearch.Result result = PathComputationTest.graphSearch().search((Graph)graph, (Vertex)D1, (Vertex)D4, (EdgeWeight)this.weight(constraints), -1);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Path path : result.paths()) {
            builder.add((Object)PathComputationTest.networkPath((Path<TopologyVertex, TopologyEdge>)path));
        }
        return builder.build();
    }

    public static org.onosproject.net.Path networkPath(Path<TopologyVertex, TopologyEdge> path) {
        List links = path.edges().stream().map(TopologyEdge::link).collect(Collectors.toList());
        return new DefaultPath(CoreService.CORE_PROVIDER_ID, links, path.cost(), new Annotations[0]);
    }

    @Test
    public void testpathComputationCase1() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, true, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, true, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, true, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, true, 50);
        CostConstraint costConst = CostConstraint.of((CostConstraint.Type)CostConstraint.Type.COST);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        constraints.add((Constraint)costConst);
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(link1);
        links.add(link2);
        MatcherAssert.assertThat((Object)paths.iterator().next().links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)70.0));
    }

    @Test
    public void testpathComputationCase2() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, true, 100);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, true, 100);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, true, 1000);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, true, 100);
        CostConstraint costConst = CostConstraint.of((CostConstraint.Type)CostConstraint.Type.COST);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        constraints.add((Constraint)costConst);
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(link1);
        links.add(link2);
        MatcherAssert.assertThat((Object)paths.iterator().next().links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)200.0));
    }

    @Test
    public void testpathComputationCase3() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, true, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, true, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, true, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, true, 50);
        LinkedList<Resource> resources = new LinkedList<Resource>();
        resources.add((Resource)Resources.continuous((DeviceId)link1.src().deviceId(), (PortNumber)link1.src().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link2.src().deviceId(), (PortNumber)link2.src().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link3.src().deviceId(), (PortNumber)link3.src().port(), Bandwidth.class).resource(100.0));
        resources.add((Resource)Resources.continuous((DeviceId)link4.src().deviceId(), (PortNumber)link4.src().port(), Bandwidth.class).resource(100.0));
        resources.add((Resource)Resources.continuous((DeviceId)link1.dst().deviceId(), (PortNumber)link1.dst().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link2.dst().deviceId(), (PortNumber)link2.dst().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link3.dst().deviceId(), (PortNumber)link3.src().port(), Bandwidth.class).resource(100.0));
        resources.add((Resource)Resources.continuous((DeviceId)link4.dst().deviceId(), (PortNumber)link4.dst().port(), Bandwidth.class).resource(100.0));
        this.resourceService.allocate((ResourceConsumer)IntentId.valueOf((long)70L), resources);
        BandwidthConstraint bandwidthConst = new BandwidthConstraint(Bandwidth.bps((double)10.0));
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        constraints.add((Constraint)bandwidthConst);
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)2.0));
    }

    @Test
    public void testpathComputationCase4() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, true, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, true, 50);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, true, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, true, 100);
        LinkedList<Resource> resources = new LinkedList<Resource>();
        resources.add((Resource)Resources.continuous((DeviceId)link1.src().deviceId(), (PortNumber)link1.src().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link2.src().deviceId(), (PortNumber)link2.src().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link3.src().deviceId(), (PortNumber)link3.src().port(), Bandwidth.class).resource(100.0));
        resources.add((Resource)Resources.continuous((DeviceId)link4.src().deviceId(), (PortNumber)link4.src().port(), Bandwidth.class).resource(100.0));
        resources.add((Resource)Resources.continuous((DeviceId)link1.dst().deviceId(), (PortNumber)link1.dst().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link2.dst().deviceId(), (PortNumber)link2.dst().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link3.dst().deviceId(), (PortNumber)link3.dst().port(), Bandwidth.class).resource(100.0));
        resources.add((Resource)Resources.continuous((DeviceId)link4.dst().deviceId(), (PortNumber)link4.dst().port(), Bandwidth.class).resource(100.0));
        this.resourceService.allocate((ResourceConsumer)IntentId.valueOf((long)70L), resources);
        BandwidthConstraint bandwidthConst = new BandwidthConstraint(Bandwidth.bps((double)60.0));
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        constraints.add((Constraint)bandwidthConst);
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)2.0));
    }

    @Test
    public void testpathComputationCase5() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, true, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, true, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, true, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, true, 80);
        LinkedList<Resource> resources = new LinkedList<Resource>();
        resources.add((Resource)Resources.continuous((DeviceId)link1.src().deviceId(), (PortNumber)link1.src().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link2.src().deviceId(), (PortNumber)link2.src().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link3.src().deviceId(), (PortNumber)link3.src().port(), Bandwidth.class).resource(100.0));
        resources.add((Resource)Resources.continuous((DeviceId)link4.src().deviceId(), (PortNumber)link4.src().port(), Bandwidth.class).resource(100.0));
        resources.add((Resource)Resources.continuous((DeviceId)link1.dst().deviceId(), (PortNumber)link1.dst().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link2.dst().deviceId(), (PortNumber)link2.dst().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link3.dst().deviceId(), (PortNumber)link3.dst().port(), Bandwidth.class).resource(100.0));
        resources.add((Resource)Resources.continuous((DeviceId)link4.dst().deviceId(), (PortNumber)link4.dst().port(), Bandwidth.class).resource(100.0));
        this.resourceService.allocate((ResourceConsumer)IntentId.valueOf((long)70L), resources);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        LinkedList sharedLinks = new LinkedList();
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(link1);
        links.add(link2);
        CostConstraint costConst = CostConstraint.of((CostConstraint.Type)CostConstraint.Type.COST);
        sharedLinks.addAll(links);
        SharedBandwidthConstraint sharedBw = new SharedBandwidthConstraint(sharedLinks, Bandwidth.bps((long)10L), Bandwidth.bps((double)20.0));
        constraints.add((Constraint)sharedBw);
        constraints.add((Constraint)costConst);
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        MatcherAssert.assertThat((Object)paths.iterator().next().links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)70.0));
    }

    @Test
    public void testpathComputationCase6() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, true, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, true, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, true, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, true, 80);
        LinkedList<Resource> resources = new LinkedList<Resource>();
        resources.add((Resource)Resources.continuous((DeviceId)link1.src().deviceId(), (PortNumber)link1.src().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link2.src().deviceId(), (PortNumber)link2.src().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link3.src().deviceId(), (PortNumber)link3.src().port(), Bandwidth.class).resource(100.0));
        resources.add((Resource)Resources.continuous((DeviceId)link4.src().deviceId(), (PortNumber)link4.src().port(), Bandwidth.class).resource(100.0));
        resources.add((Resource)Resources.continuous((DeviceId)link1.dst().deviceId(), (PortNumber)link1.dst().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link2.dst().deviceId(), (PortNumber)link2.dst().port(), Bandwidth.class).resource(50.0));
        resources.add((Resource)Resources.continuous((DeviceId)link3.dst().deviceId(), (PortNumber)link3.dst().port(), Bandwidth.class).resource(100.0));
        resources.add((Resource)Resources.continuous((DeviceId)link4.dst().deviceId(), (PortNumber)link4.dst().port(), Bandwidth.class).resource(100.0));
        this.resourceService.allocate((ResourceConsumer)IntentId.valueOf((long)70L), resources);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        LinkedList sharedLinks = new LinkedList();
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(link1);
        links.add(link2);
        CostConstraint costConst = CostConstraint.of((CostConstraint.Type)CostConstraint.Type.COST);
        sharedLinks.addAll(links);
        SharedBandwidthConstraint sharedBwConst = new SharedBandwidthConstraint(sharedLinks, Bandwidth.bps((long)20L), Bandwidth.bps((double)10.0));
        constraints.add((Constraint)sharedBwConst);
        constraints.add((Constraint)costConst);
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        MatcherAssert.assertThat((Object)paths.iterator().next().links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)70.0));
    }

    @Test
    public void testpathComputationCase7() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, true, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, true, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, true, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, true, 80);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)2.0));
    }

    @Test
    public void testpathComputationCase8() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, false, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, false, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, false, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, false, 80);
        CostConstraint tecostConst = CostConstraint.of((CostConstraint.Type)CostConstraint.Type.TE_COST);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        constraints.add((Constraint)tecostConst);
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(link1);
        links.add(link2);
        MatcherAssert.assertThat((Object)paths.iterator().next().links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)70.0));
    }

    @Test
    public void testpathComputationCase9() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, false, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, false, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, false, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, false, 80);
        CostConstraint tecostConst = CostConstraint.of((CostConstraint.Type)CostConstraint.Type.TE_COST);
        CapabilityConstraint capabilityConst = CapabilityConstraint.of((CapabilityConstraint.CapabilityType)CapabilityConstraint.CapabilityType.WITH_SIGNALLING);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        constraints.add((Constraint)capabilityConst);
        constraints.add((Constraint)tecostConst);
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "1.1.1.1");
        this.addDevice(DEVICE1, builder);
        DeviceCapability device1Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"1.1.1.1"), DeviceCapability.class);
        device1Cap.setLabelStackCap(false).setLocalLabelCap(false).setSrCap(false).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "2.2.2.2");
        this.addDevice(DEVICE2, builder);
        DeviceCapability device2Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"2.2.2.2"), DeviceCapability.class);
        device2Cap.setLabelStackCap(false).setLocalLabelCap(false).setSrCap(false).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "3.3.3.3");
        this.addDevice(DEVICE3, builder);
        DeviceCapability device3Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"3.3.3.3"), DeviceCapability.class);
        device3Cap.setLabelStackCap(false).setLocalLabelCap(false).setSrCap(false).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "4.4.4.4");
        this.addDevice(DEVICE4, builder);
        DeviceCapability device4Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"4.4.4.4"), DeviceCapability.class);
        device4Cap.setLabelStackCap(false).setLocalLabelCap(false).setSrCap(false).apply();
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(link1);
        links.add(link2);
        MatcherAssert.assertThat((Object)paths.iterator().next().links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)70.0));
    }

    @Test
    public void testpathComputationCase10() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, true, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, true, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, true, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, true, 80);
        CapabilityConstraint capabilityConst = CapabilityConstraint.of((CapabilityConstraint.CapabilityType)CapabilityConstraint.CapabilityType.WITHOUT_SIGNALLING_AND_WITHOUT_SR);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        constraints.add((Constraint)capabilityConst);
        CostConstraint costConst = CostConstraint.of((CostConstraint.Type)CostConstraint.Type.COST);
        constraints.add((Constraint)costConst);
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "1.1.1.1");
        this.addDevice(DEVICE1, builder);
        DeviceCapability device1Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"1.1.1.1"), DeviceCapability.class);
        device1Cap.setLabelStackCap(false).setLocalLabelCap(true).setSrCap(false).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "2.2.2.2");
        this.addDevice(DEVICE2, builder);
        DeviceCapability device2Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"2.2.2.2"), DeviceCapability.class);
        device2Cap.setLabelStackCap(false).setLocalLabelCap(true).setSrCap(false).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "3.3.3.3");
        this.addDevice(DEVICE3, builder);
        DeviceCapability device3Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"3.3.3.3"), DeviceCapability.class);
        device3Cap.setLabelStackCap(false).setLocalLabelCap(true).setSrCap(false).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "4.4.4.4");
        this.addDevice(DEVICE4, builder);
        DeviceCapability device4Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"4.4.4.4"), DeviceCapability.class);
        device4Cap.setLabelStackCap(false).setLocalLabelCap(true).setSrCap(false).apply();
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(link1);
        links.add(link2);
        MatcherAssert.assertThat((Object)paths.iterator().next().links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)70.0));
    }

    @Test
    public void testpathComputationCase11() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, true, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, true, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, true, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, true, 80);
        CapabilityConstraint capabilityConst = CapabilityConstraint.of((CapabilityConstraint.CapabilityType)CapabilityConstraint.CapabilityType.SR_WITHOUT_SIGNALLING);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        constraints.add((Constraint)capabilityConst);
        CostConstraint costConst = CostConstraint.of((CostConstraint.Type)CostConstraint.Type.COST);
        constraints.add((Constraint)costConst);
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "1.1.1.1");
        this.addDevice(DEVICE1, builder);
        DeviceCapability device1Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"1.1.1.1"), DeviceCapability.class);
        device1Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "2.2.2.2");
        this.addDevice(DEVICE2, builder);
        DeviceCapability device2Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"2.2.2.2"), DeviceCapability.class);
        device2Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "3.3.3.3");
        this.addDevice(DEVICE3, builder);
        DeviceCapability device3Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"3.3.3.3"), DeviceCapability.class);
        device3Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "4.4.4.4");
        this.addDevice(DEVICE4, builder);
        DeviceCapability device4Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"4.4.4.4"), DeviceCapability.class);
        device4Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(link1);
        links.add(link2);
        MatcherAssert.assertThat((Object)paths.iterator().next().links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)70.0));
    }

    @Test
    public void testpathComputationCase12() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, false, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, false, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, false, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, false, 80);
        CostConstraint tecostConst = CostConstraint.of((CostConstraint.Type)CostConstraint.Type.TE_COST);
        CapabilityConstraint capabilityConst = CapabilityConstraint.of((CapabilityConstraint.CapabilityType)CapabilityConstraint.CapabilityType.SR_WITHOUT_SIGNALLING);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        constraints.add((Constraint)capabilityConst);
        constraints.add((Constraint)tecostConst);
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "1.1.1.1");
        this.addDevice(DEVICE1, builder);
        DeviceCapability device1Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"1.1.1.1"), DeviceCapability.class);
        device1Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "2.2.2.2");
        this.addDevice(DEVICE2, builder);
        DeviceCapability device2Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"2.2.2.2"), DeviceCapability.class);
        device2Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "3.3.3.3");
        this.addDevice(DEVICE3, builder);
        DeviceCapability device3Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"3.3.3.3"), DeviceCapability.class);
        device3Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "4.4.4.4");
        this.addDevice(DEVICE4, builder);
        DeviceCapability device4Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"4.4.4.4"), DeviceCapability.class);
        device4Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(link1);
        links.add(link2);
        MatcherAssert.assertThat((Object)paths.iterator().next().links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)70.0));
    }

    @Test
    public void testpathComputationCase13() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, false, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, false, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, false, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, false, 80);
        CapabilityConstraint capabilityConst = CapabilityConstraint.of((CapabilityConstraint.CapabilityType)CapabilityConstraint.CapabilityType.SR_WITHOUT_SIGNALLING);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        constraints.add((Constraint)capabilityConst);
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "1.1.1.1");
        this.addDevice(DEVICE1, builder);
        DeviceCapability device1Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"1.1.1.1"), DeviceCapability.class);
        device1Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "2.2.2.2");
        this.addDevice(DEVICE2, builder);
        DeviceCapability device2Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"2.2.2.2"), DeviceCapability.class);
        device2Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "3.3.3.3");
        this.addDevice(DEVICE3, builder);
        DeviceCapability device3Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"3.3.3.3"), DeviceCapability.class);
        device3Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "4.4.4.4");
        this.addDevice(DEVICE4, builder);
        DeviceCapability device4Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"4.4.4.4"), DeviceCapability.class);
        device4Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(link1);
        links.add(link2);
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)2.0));
    }

    @Test
    public void testpathComputationCase14() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, false, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, false, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, false, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, false, 80);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)2.0));
    }

    @Test
    public void testpathComputationCase15() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, false, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, false, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, false, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, false, 80);
        List<Constraint> constraints = null;
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)2.0));
    }

    @Test
    public void testpathComputationCase16() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, true, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, true, 100);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, true, 10);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, true, 10);
        Link link5 = PathComputationTest.addLink(DEVICE4, 90L, DEVICE5, 100L, true, 20);
        CostConstraint costConst = CostConstraint.of((CostConstraint.Type)CostConstraint.Type.COST);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        constraints.add((Constraint)costConst);
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)D1, (Object)D2, (Object)D3, (Object)D4, (Object)D5), (Set)ImmutableSet.of((Object)new DefaultTopologyEdge(D1, D2, link1), (Object)new DefaultTopologyEdge(D2, D4, link2), (Object)new DefaultTopologyEdge(D1, D3, link3), (Object)new DefaultTopologyEdge(D3, D4, link4), (Object)new DefaultTopologyEdge(D4, D5, link5)));
        GraphPathSearch.Result result = PathComputationTest.graphSearch().search((Graph)graph, (Vertex)D1, (Vertex)D5, (EdgeWeight)this.weight(constraints), -1);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Path path : result.paths()) {
            builder.add((Object)PathComputationTest.networkPath((Path<TopologyVertex, TopologyEdge>)path));
        }
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(link3);
        links.add(link4);
        links.add(link5);
        MatcherAssert.assertThat((Object)((org.onosproject.net.Path)builder.build().iterator().next()).links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)((org.onosproject.net.Path)builder.build().iterator().next()).cost(), (Matcher)Is.is((Object)40.0));
    }

    @Test
    public void testpathComputationCase17() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, false, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, false, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, false, 100);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, false, 80);
        CapabilityConstraint capabilityConst = CapabilityConstraint.of((CapabilityConstraint.CapabilityType)CapabilityConstraint.CapabilityType.WITHOUT_SIGNALLING_AND_WITHOUT_SR);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        constraints.add((Constraint)capabilityConst);
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "1.1.1.1");
        this.addDevice(DEVICE1, builder);
        DeviceCapability device1Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"1.1.1.1"), DeviceCapability.class);
        device1Cap.setLabelStackCap(false).setLocalLabelCap(true).setSrCap(false).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "2.2.2.2");
        this.addDevice(DEVICE2, builder);
        DeviceCapability device2Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"2.2.2.2"), DeviceCapability.class);
        device2Cap.setLabelStackCap(false).setLocalLabelCap(true).setSrCap(false).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "4.4.4.4");
        this.addDevice(DEVICE4, builder);
        DeviceCapability device4Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"4.4.4.4"), DeviceCapability.class);
        device4Cap.setLabelStackCap(false).setLocalLabelCap(true).setSrCap(false).apply();
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(link1);
        links.add(link2);
        MatcherAssert.assertThat((Object)paths.iterator().next().links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)paths.iterator().next().cost(), (Matcher)Is.is((Object)2.0));
    }

    @Test
    public void testpathComputationCase18() {
        Link link1 = PathComputationTest.addLink(DEVICE1, 10L, DEVICE2, 20L, true, 50);
        Link link2 = PathComputationTest.addLink(DEVICE2, 30L, DEVICE4, 40L, false, 20);
        Link link3 = PathComputationTest.addLink(DEVICE1, 80L, DEVICE3, 70L, true, 10);
        Link link4 = PathComputationTest.addLink(DEVICE3, 60L, DEVICE4, 50L, true, 10);
        CapabilityConstraint capabilityConst = CapabilityConstraint.of((CapabilityConstraint.CapabilityType)CapabilityConstraint.CapabilityType.WITHOUT_SIGNALLING_AND_WITHOUT_SR);
        CostConstraint costConst = CostConstraint.of((CostConstraint.Type)CostConstraint.Type.COST);
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        constraints.add((Constraint)capabilityConst);
        constraints.add((Constraint)costConst);
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "1.1.1.1");
        this.addDevice(DEVICE2, builder);
        DeviceCapability device1Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"1.1.1.1"), DeviceCapability.class);
        device1Cap.setLabelStackCap(false).setLocalLabelCap(true).setSrCap(false).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "2.2.2.2");
        this.addDevice(DEVICE2, builder);
        DeviceCapability device2Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"2.2.2.2"), DeviceCapability.class);
        device2Cap.setLabelStackCap(false).setLocalLabelCap(true).setSrCap(false).apply();
        builder = DefaultAnnotations.builder();
        builder.set("type", L3);
        builder.set(LSRID, "4.4.4.4");
        this.addDevice(DEVICE4, builder);
        DeviceCapability device4Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"4.4.4.4"), DeviceCapability.class);
        device4Cap.setLabelStackCap(false).setLocalLabelCap(true).setSrCap(false).apply();
        Set<org.onosproject.net.Path> paths = this.computePath(link1, link2, link3, link4, constraints);
        MatcherAssert.assertThat(paths, (Matcher)Is.is(new HashSet()));
    }

    private void addDevice(String device, DefaultAnnotations.Builder builder) {
        this.deviceService.addDevice((Device)new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)device), Device.Type.ROUTER, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, new ChassisId(), new Annotations[]{builder.build()}));
    }

    public static class MockNetConfigRegistryAdapter
    extends NetworkConfigRegistryAdapter {
        private ConfigFactory cfgFactory;
        private Map<DeviceId, DeviceCapability> classConfig = new HashMap<DeviceId, DeviceCapability>();

        public void registerConfigFactory(ConfigFactory configFactory) {
            this.cfgFactory = configFactory;
        }

        public void unregisterConfigFactory(ConfigFactory configFactory) {
            this.cfgFactory = null;
        }

        public <S, C extends Config<S>> C addConfig(S subject, Class<C> configClass) {
            if (configClass == DeviceCapability.class) {
                DeviceCapability devCap = new DeviceCapability();
                this.classConfig.put((DeviceId)subject, devCap);
                ObjectNode node = new ObjectNode((JsonNodeFactory)new MockJsonNode());
                ObjectMapper mapper = new ObjectMapper();
                InternalApplyDelegate delegate = new InternalApplyDelegate();
                devCap.init((Object)((DeviceId)subject), null, (JsonNode)node, mapper, (ConfigApplyDelegate)delegate);
                return (C)devCap;
            }
            return null;
        }

        public <S, C extends Config<S>> void removeConfig(S subject, Class<C> configClass) {
            this.classConfig.remove(subject);
        }

        public <S, C extends Config<S>> C getConfig(S subject, Class<C> configClass) {
            if (configClass == DeviceCapability.class) {
                return (C)((Config)this.classConfig.get(subject));
            }
            return null;
        }

        private class InternalApplyDelegate
        implements ConfigApplyDelegate {
            private InternalApplyDelegate() {
            }

            public void onApply(Config config) {
            }
        }

        private class MockJsonNode
        extends JsonNodeFactory {
            private MockJsonNode() {
            }
        }
    }

    public class MockPathResourceService
    extends ResourceServiceAdapter {
        private final Map<Resource, ResourceConsumer> assignment = new HashMap<Resource, ResourceConsumer>();
        private Map<ResourceId, List<ResourceAllocation>> resourcesAllocations = new HashMap<ResourceId, List<ResourceAllocation>>();

        public Optional<ResourceAllocation> allocate(ResourceConsumer consumer, Resource resources) {
            List<ResourceAllocation> allocations = this.allocate(consumer, (List<Resource>)ImmutableList.of((Object)resources));
            if (allocations.isEmpty()) {
                return Optional.empty();
            }
            assert (allocations.size() == 1);
            ResourceAllocation allocation = allocations.get(0);
            assert (allocation.resource().equals(resources));
            return Optional.of(allocation);
        }

        @Override
        public List<ResourceAllocation> allocate(ResourceConsumer consumer, List<Resource> resources) {
            for (Resource resource : resources) {
                if (!(resource instanceof ContinuousResource)) continue;
                LinkedList<ResourceAllocation> allocs = new LinkedList<ResourceAllocation>();
                allocs.add(new ResourceAllocation(resource, consumer));
                this.resourcesAllocations.put(resource.id(), allocs);
            }
            return resources.stream().map(x -> new ResourceAllocation(x, consumer)).collect(Collectors.toList());
        }

        @Override
        public List<ResourceAllocation> getResourceAllocations(ResourceId id) {
            if (id instanceof ContinuousResourceId) {
                return this.resourcesAllocations.get(id);
            }
            DiscreteResource discrete = Resources.discrete((DiscreteResourceId)((DiscreteResourceId)id)).resource();
            return (List)Optional.ofNullable(this.assignment.get(discrete)).map(x -> ImmutableList.of((Object)new ResourceAllocation((Resource)discrete, x))).orElse(ImmutableList.of());
        }

        @Override
        public <T> Set<Resource> getAvailableResources(DiscreteResourceId parent, Class<T> cls) {
            return this.getAvailableResources(parent).stream().filter(x -> x.isTypeOf(cls)).collect(Collectors.toSet());
        }

        @Override
        public <T> Set<T> getAvailableResourceValues(DiscreteResourceId parent, Class<T> cls) {
            return this.getAvailableResources(parent).stream().filter(x -> x.isTypeOf(cls)).flatMap(x -> Tools.stream((Optional)x.valueAs(cls))).collect(Collectors.toSet());
        }

        @Override
        public boolean isAvailable(Resource resource) {
            List<ResourceAllocation> resalloc;
            if (resource instanceof DiscreteResource) {
                return true;
            }
            return resource instanceof ContinuousResource && (resalloc = this.resourcesAllocations.get(resource.id())) != null && !resalloc.isEmpty() && ((ContinuousResource)resalloc.iterator().next().resource()).value() >= ((ContinuousResource)resource).value();
        }
    }

    private class MockTeConstraintBasedLinkWeight
    implements LinkWeight {
        private final List<Constraint> constraints;

        MockTeConstraintBasedLinkWeight(List<Constraint> constraints) {
            this.constraints = constraints == null ? Collections.emptyList() : ImmutableList.copyOf(constraints);
        }

        public double weight(TopologyEdge edge) {
            if (!this.constraints.iterator().hasNext()) {
                return 1.0;
            }
            Iterator<Constraint> it = this.constraints.iterator();
            double cost = 1.0;
            while (it.hasNext() && cost > 0.0) {
                Constraint constraint = it.next();
                if (constraint instanceof CapabilityConstraint) {
                    cost = ((CapabilityConstraint)constraint).isValidLink(edge.link(), (DeviceService)PathComputationTest.this.deviceService, (NetworkConfigService)PathComputationTest.this.netConfigRegistry) ? 1.0 : -1.0;
                    continue;
                }
                cost = constraint.cost(edge.link(), PathComputationTest.this.resourceService::isAvailable);
            }
            return cost;
        }
    }

    private class MockDeviceService
    extends DeviceServiceAdapter {
        List<Device> devices = new LinkedList<Device>();

        private MockDeviceService() {
        }

        private void addDevice(Device dev) {
            this.devices.add(dev);
        }

        public Device getDevice(DeviceId deviceId) {
            for (Device dev : this.devices) {
                if (!dev.id().equals((Object)deviceId)) continue;
                return dev;
            }
            return null;
        }

        public Iterable<Device> getAvailableDevices() {
            return this.devices;
        }
    }
}

