/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice;

import com.google.common.collect.ImmutableSet;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Path;
import org.onlab.graph.Vertex;
import org.onlab.junit.TestUtils;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.TCP;
import org.onlab.util.Bandwidth;
import org.onosproject.common.DefaultTopologyGraph;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreServiceAdapter;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.resource.label.LabelResourceAdminService;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.resource.label.LabelResourceService;
import org.onosproject.incubator.net.tunnel.DefaultTunnel;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelEvent;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelListener;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.packet.DefaultInboundPacket;
import org.onosproject.net.packet.DefaultPacketContext;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.packet.PacketServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.Resources;
import org.onosproject.net.topology.DefaultTopologyEdge;
import org.onosproject.net.topology.DefaultTopologyVertex;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.PathServiceAdapter;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyEvent;
import org.onosproject.net.topology.TopologyGraph;
import org.onosproject.net.topology.TopologyListener;
import org.onosproject.net.topology.TopologyServiceAdapter;
import org.onosproject.net.topology.TopologyVertex;
import org.onosproject.pce.pceservice.LspType;
import org.onosproject.pce.pceservice.PathComputationTest;
import org.onosproject.pce.pceservice.PceManager;
import org.onosproject.pce.pceservice.constraint.CostConstraint;
import org.onosproject.pce.pcestore.api.PceStore;
import org.onosproject.pce.util.FlowObjServiceAdapter;
import org.onosproject.pce.util.LabelResourceAdapter;
import org.onosproject.pce.util.MockDeviceService;
import org.onosproject.pce.util.MockLinkService;
import org.onosproject.pce.util.PceStoreAdapter;
import org.onosproject.pce.util.TunnelServiceAdapter;
import org.onosproject.pcep.api.DeviceCapability;
import org.onosproject.store.service.TestStorageService;

public class PceManagerTest {
    private PathComputationTest pathCompTest = new PathComputationTest();
    private PathComputationTest.MockPathResourceService resourceService = this.pathCompTest.new PathComputationTest.MockPathResourceService();
    private MockTopologyService topologyService = new MockTopologyService();
    private MockMastershipService mastershipService = new MockMastershipService();
    private MockPathService pathService = new MockPathService();
    private PceManager pceManager = new PceManager();
    private MockCoreService coreService = new MockCoreService();
    private MockTunnelServiceAdapter tunnelService = new MockTunnelServiceAdapter();
    private TestStorageService storageService = new TestStorageService();
    private PacketService packetService = new MockPacketService();
    private MockDeviceService deviceService = new MockDeviceService();
    private PathComputationTest.MockNetConfigRegistryAdapter netConfigRegistry = new PathComputationTest.MockNetConfigRegistryAdapter();
    private MockLinkService linkService = new MockLinkService();
    private MockFlowObjService flowObjectiveService = new MockFlowObjService();
    private PceStore pceStore = new PceStoreAdapter();
    private LabelResourceService labelResourceService = new LabelResourceAdapter();
    private LabelResourceAdminService labelRsrcAdminService = new LabelResourceAdapter();
    public static ProviderId providerId = new ProviderId("pce", "foo");
    private static final String L3 = "L3";
    private static final String LSRID = "lsrId";
    private static final String PCECC_CAPABILITY = "pceccCapability";
    private static final String SR_CAPABILITY = "srCapability";
    private static final String LABEL_STACK_CAPABILITY = "labelStackCapability";
    private TopologyGraph graph = null;
    private Device deviceD1;
    private Device deviceD2;
    private Device deviceD3;
    private Device deviceD4;
    private Device pcepDeviceD1;
    private Device pcepDeviceD2;
    private Device pcepDeviceD3;
    private Device pcepDeviceD4;
    private Link link1;
    private Link link2;
    private Link link3;
    private Link link4;
    protected static int flowsDownloaded;
    private TunnelListener tunnelListener;
    private TopologyListener listener;
    private Topology topology;
    private Set<TopologyEdge> edges;
    private Set<TopologyVertex> vertexes;
    private PacketProcessor pktProcessor = null;

    @Before
    public void startUp() throws TestUtils.TestUtilsException {
        this.listener = (TopologyListener)TestUtils.getField((Object)this.pceManager, (String)"topologyListener");
        this.pceManager.pathService = this.pathService;
        this.pceManager.resourceService = this.resourceService;
        this.pceManager.topologyService = this.topologyService;
        this.pceManager.tunnelService = this.tunnelService;
        this.pceManager.coreService = this.coreService;
        this.pceManager.storageService = this.storageService;
        this.pceManager.packetService = this.packetService;
        this.pceManager.deviceService = this.deviceService;
        this.pceManager.linkService = this.linkService;
        this.pceManager.netCfgService = this.netConfigRegistry;
        this.pceManager.labelRsrcAdminService = this.labelRsrcAdminService;
        this.pceManager.labelRsrcService = this.labelResourceService;
        this.pceManager.flowObjectiveService = this.flowObjectiveService;
        this.pceManager.pceStore = this.pceStore;
        this.pceManager.mastershipService = this.mastershipService;
        this.pceManager.activate();
    }

    private void build4RouterTopo(boolean setCost, boolean setPceccCap, boolean setSrCap, boolean setLabelStackCap, int bandwidth) {
        this.link1 = PathComputationTest.addLink("D001", 10L, "D002", 20L, setCost, 50);
        this.link2 = PathComputationTest.addLink("D002", 30L, "D004", 40L, setCost, 20);
        this.link3 = PathComputationTest.addLink("D001", 80L, "D003", 70L, setCost, 100);
        this.link4 = PathComputationTest.addLink("D003", 60L, "D004", 50L, setCost, 80);
        HashSet<TopologyVertex> vertexes = new HashSet<TopologyVertex>();
        vertexes.add(PathComputationTest.D1);
        vertexes.add(PathComputationTest.D2);
        vertexes.add(PathComputationTest.D3);
        vertexes.add(PathComputationTest.D4);
        this.vertexes = vertexes;
        HashSet<TopologyEdge> edges = new HashSet<TopologyEdge>();
        DefaultTopologyEdge edge1 = new DefaultTopologyEdge(PathComputationTest.D1, PathComputationTest.D2, this.link1);
        edges.add((TopologyEdge)edge1);
        DefaultTopologyEdge edge2 = new DefaultTopologyEdge(PathComputationTest.D2, PathComputationTest.D4, this.link2);
        edges.add((TopologyEdge)edge2);
        DefaultTopologyEdge edge3 = new DefaultTopologyEdge(PathComputationTest.D1, PathComputationTest.D3, this.link3);
        edges.add((TopologyEdge)edge3);
        DefaultTopologyEdge edge4 = new DefaultTopologyEdge(PathComputationTest.D3, PathComputationTest.D4, this.link4);
        edges.add((TopologyEdge)edge4);
        this.edges = edges;
        this.graph = new DefaultTopologyGraph(vertexes, edges);
        DefaultAnnotations.Builder builderDev1 = DefaultAnnotations.builder();
        DefaultAnnotations.Builder builderDev2 = DefaultAnnotations.builder();
        DefaultAnnotations.Builder builderDev3 = DefaultAnnotations.builder();
        DefaultAnnotations.Builder builderDev4 = DefaultAnnotations.builder();
        builderDev1.set("type", L3);
        builderDev1.set(LSRID, "1.1.1.1");
        builderDev2.set("type", L3);
        builderDev2.set(LSRID, "2.2.2.2");
        builderDev3.set("type", L3);
        builderDev3.set(LSRID, "3.3.3.3");
        builderDev4.set("type", L3);
        builderDev4.set(LSRID, "4.4.4.4");
        this.deviceD1 = new MockDevice(PathComputationTest.D1.deviceId(), (Annotations)builderDev1.build());
        this.deviceD2 = new MockDevice(PathComputationTest.D2.deviceId(), (Annotations)builderDev2.build());
        this.deviceD3 = new MockDevice(PathComputationTest.D3.deviceId(), (Annotations)builderDev3.build());
        this.deviceD4 = new MockDevice(PathComputationTest.D4.deviceId(), (Annotations)builderDev4.build());
        this.deviceService.addDevice(this.deviceD1);
        this.deviceService.addDevice(this.deviceD2);
        this.deviceService.addDevice(this.deviceD3);
        this.deviceService.addDevice(this.deviceD4);
        DeviceCapability device1Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"1.1.1.1"), DeviceCapability.class);
        device1Cap.setLabelStackCap(setLabelStackCap).setLocalLabelCap(setPceccCap).setSrCap(setSrCap).apply();
        DeviceCapability device2Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"2.2.2.2"), DeviceCapability.class);
        device2Cap.setLabelStackCap(setLabelStackCap).setLocalLabelCap(setPceccCap).setSrCap(setSrCap).apply();
        DeviceCapability device3Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"3.3.3.3"), DeviceCapability.class);
        device3Cap.setLabelStackCap(setLabelStackCap).setLocalLabelCap(setPceccCap).setSrCap(setSrCap).apply();
        DeviceCapability device4Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"4.4.4.4"), DeviceCapability.class);
        device4Cap.setLabelStackCap(setLabelStackCap).setLocalLabelCap(setPceccCap).setSrCap(setSrCap).apply();
        if (bandwidth != 0) {
            LinkedList<Resource> resources = new LinkedList<Resource>();
            resources.add((Resource)Resources.continuous((DeviceId)this.link1.src().deviceId(), (PortNumber)this.link1.src().port(), Bandwidth.class).resource((double)bandwidth));
            resources.add((Resource)Resources.continuous((DeviceId)this.link2.src().deviceId(), (PortNumber)this.link2.src().port(), Bandwidth.class).resource((double)bandwidth));
            resources.add((Resource)Resources.continuous((DeviceId)this.link3.src().deviceId(), (PortNumber)this.link3.src().port(), Bandwidth.class).resource((double)bandwidth));
            resources.add((Resource)Resources.continuous((DeviceId)this.link4.src().deviceId(), (PortNumber)this.link4.src().port(), Bandwidth.class).resource((double)bandwidth));
            resources.add((Resource)Resources.continuous((DeviceId)this.link1.dst().deviceId(), (PortNumber)this.link1.dst().port(), Bandwidth.class).resource((double)bandwidth));
            resources.add((Resource)Resources.continuous((DeviceId)this.link2.dst().deviceId(), (PortNumber)this.link2.dst().port(), Bandwidth.class).resource((double)bandwidth));
            resources.add((Resource)Resources.continuous((DeviceId)this.link3.dst().deviceId(), (PortNumber)this.link3.dst().port(), Bandwidth.class).resource((double)bandwidth));
            resources.add((Resource)Resources.continuous((DeviceId)this.link4.dst().deviceId(), (PortNumber)this.link4.dst().port(), Bandwidth.class).resource((double)bandwidth));
            this.resourceService.allocate((ResourceConsumer)IntentId.valueOf((long)bandwidth), resources);
        }
    }

    @Test
    public void setupPathTest1() {
        this.build4RouterTopo(true, false, false, false, 0);
        LinkedList<CostConstraint> constraints = new LinkedList<CostConstraint>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.COST);
        constraints.add(costConstraint);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void setupPathTest2() {
        this.build4RouterTopo(false, false, false, false, 0);
        LinkedList<CostConstraint> constraints = new LinkedList<CostConstraint>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.COST);
        constraints.add(costConstraint);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)false));
    }

    @Test
    public void setupPathTest3() {
        this.build4RouterTopo(false, false, false, false, 0);
        LinkedList<CostConstraint> constraints = new LinkedList<CostConstraint>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void setupPathTest4() {
        this.build4RouterTopo(true, false, false, false, 0);
        LinkedList<CostConstraint> constraints = new LinkedList<CostConstraint>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)false));
    }

    @Test
    public void setupPathTest5() {
        this.build4RouterTopo(true, true, false, false, 0);
        LinkedList<CostConstraint> constraints = new LinkedList<CostConstraint>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.COST);
        constraints.add(costConstraint);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.WITHOUT_SIGNALLING_AND_WITHOUT_SR);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void setupPathTest6() {
        this.build4RouterTopo(false, true, false, false, 0);
        LinkedList<CostConstraint> constraints = new LinkedList<CostConstraint>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.WITHOUT_SIGNALLING_AND_WITHOUT_SR);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void setupPathTest7() {
        this.build4RouterTopo(true, false, false, false, 0);
        LinkedList<CostConstraint> constraints = new LinkedList<CostConstraint>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.WITHOUT_SIGNALLING_AND_WITHOUT_SR);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)false));
    }

    @Test
    public void setupPathTest8() {
        this.build4RouterTopo(true, false, false, false, 0);
        LinkedList<Object> constraints = new LinkedList<Object>();
        BandwidthConstraint bwConstraint = new BandwidthConstraint(Bandwidth.bps((double)10.0));
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        constraints.add(bwConstraint);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)false));
    }

    @Test
    public void setupPathTest9() {
        this.build4RouterTopo(false, false, false, false, 5);
        LinkedList<Object> constraints = new LinkedList<Object>();
        BandwidthConstraint bwConstraint = new BandwidthConstraint(Bandwidth.bps((double)10.0));
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        constraints.add(bwConstraint);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)false));
    }

    @Test
    public void setupPathTest10() {
        this.build4RouterTopo(false, false, false, false, 0);
        LinkedList<CostConstraint> constraints = new LinkedList<CostConstraint>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.SR_WITHOUT_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)false));
    }

    @Test
    public void setupPathTest11() {
        this.build4RouterTopo(false, true, true, true, 15);
        LinkedList<Object> constraints = new LinkedList<Object>();
        BandwidthConstraint bwConstraint = new BandwidthConstraint(Bandwidth.bps((double)10.0));
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        constraints.add(bwConstraint);
        LabelResourceId node1Label = LabelResourceId.labelResourceId((long)5200L);
        LabelResourceId node2Label = LabelResourceId.labelResourceId((long)5201L);
        this.pceManager.pceStore.addGlobalNodeLabel(PathComputationTest.D1.deviceId(), node1Label);
        this.pceManager.pceStore.addGlobalNodeLabel(PathComputationTest.D2.deviceId(), node2Label);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.SR_WITHOUT_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)false));
    }

    @Test
    public void setupPathTest12() {
        this.build4RouterTopo(false, true, true, true, 15);
        LinkedList<Object> constraints = new LinkedList<Object>();
        BandwidthConstraint bwConstraint = new BandwidthConstraint(Bandwidth.bps((double)10.0));
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        constraints.add(bwConstraint);
        LabelResourceId node1Label = LabelResourceId.labelResourceId((long)5200L);
        LabelResourceId node2Label = LabelResourceId.labelResourceId((long)5201L);
        this.pceManager.pceStore.addGlobalNodeLabel(PathComputationTest.D1.deviceId(), node1Label);
        this.pceManager.pceStore.addGlobalNodeLabel(PathComputationTest.D2.deviceId(), node2Label);
        LabelResourceId link1Label = LabelResourceId.labelResourceId((long)5202L);
        this.pceManager.pceStore.addAdjLabel(this.link1, link1Label);
        LabelResourceId link2Label = LabelResourceId.labelResourceId((long)5203L);
        this.pceManager.pceStore.addAdjLabel(this.link2, link2Label);
        LabelResourceId link3Label = LabelResourceId.labelResourceId((long)5204L);
        this.pceManager.pceStore.addAdjLabel(this.link3, link3Label);
        LabelResourceId link4Label = LabelResourceId.labelResourceId((long)5205L);
        this.pceManager.pceStore.addAdjLabel(this.link4, link4Label);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.SR_WITHOUT_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void setupPathTest13() {
        this.build4RouterTopo(false, false, false, false, 0);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", null, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void updatePathTest1() {
        this.build4RouterTopo(false, true, true, true, 100);
        LinkedList<Object> constraints = new LinkedList<Object>();
        BandwidthConstraint bwConstraint = new BandwidthConstraint(Bandwidth.bps((double)60.0));
        constraints.add(bwConstraint);
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D4.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        constraints = new LinkedList();
        bwConstraint = new BandwidthConstraint(Bandwidth.bps((double)50.0));
        constraints.add(bwConstraint);
        constraints.add(costConstraint);
        Collection tunnels = (Collection)this.pceManager.queryAllPath();
        MatcherAssert.assertThat((Object)tunnels.size(), (Matcher)Is.is((Object)1));
        Tunnel tunnel = (Tunnel)tunnels.iterator().next();
        this.tunnelService.updateTunnelWithLspIds(tunnel, "123", "1", Tunnel.State.ACTIVE);
        result = this.pceManager.updatePath(tunnel.tunnelId(), constraints);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        tunnels = (Collection)this.pceManager.queryAllPath();
        MatcherAssert.assertThat((Object)tunnels.size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void updatePathTest2() {
        this.build4RouterTopo(false, true, true, true, 100);
        LinkedList<Object> constraints = new LinkedList<Object>();
        BandwidthConstraint bwConstraint = new BandwidthConstraint(Bandwidth.bps((double)60.0));
        constraints.add(bwConstraint);
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        LabelResourceId node1Label = LabelResourceId.labelResourceId((long)5200L);
        LabelResourceId node2Label = LabelResourceId.labelResourceId((long)5201L);
        this.pceManager.pceStore.addGlobalNodeLabel(PathComputationTest.D1.deviceId(), node1Label);
        this.pceManager.pceStore.addGlobalNodeLabel(PathComputationTest.D2.deviceId(), node2Label);
        LabelResourceId link1Label = LabelResourceId.labelResourceId((long)5202L);
        this.pceManager.pceStore.addAdjLabel(this.link1, link1Label);
        LabelResourceId link2Label = LabelResourceId.labelResourceId((long)5203L);
        this.pceManager.pceStore.addAdjLabel(this.link2, link2Label);
        LabelResourceId link3Label = LabelResourceId.labelResourceId((long)5204L);
        this.pceManager.pceStore.addAdjLabel(this.link3, link3Label);
        LabelResourceId link4Label = LabelResourceId.labelResourceId((long)5205L);
        this.pceManager.pceStore.addAdjLabel(this.link4, link4Label);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.SR_WITHOUT_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        constraints.remove(bwConstraint);
        bwConstraint = new BandwidthConstraint(Bandwidth.bps((double)70.0));
        constraints.add(bwConstraint);
        Collection tunnels = (Collection)this.pceManager.queryAllPath();
        MatcherAssert.assertThat((Object)tunnels.size(), (Matcher)Is.is((Object)1));
        for (Tunnel tunnel : tunnels) {
            result = this.pceManager.updatePath(tunnel.tunnelId(), constraints);
            MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        }
        tunnels = (Collection)this.pceManager.queryAllPath();
        MatcherAssert.assertThat((Object)tunnels.size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void updatePathTest3() {
        this.build4RouterTopo(false, true, true, true, 100);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", null, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        Collection tunnels = (Collection)this.pceManager.queryAllPath();
        MatcherAssert.assertThat((Object)tunnels.size(), (Matcher)Is.is((Object)1));
        for (Tunnel tunnel : tunnels) {
            result = this.pceManager.updatePath(tunnel.tunnelId(), null);
            MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        }
        Iterable queryTunnelResult = this.pceManager.queryAllPath();
        MatcherAssert.assertThat((Object)((int)queryTunnelResult.spliterator().getExactSizeIfKnown()), (Matcher)Is.is((Object)2));
    }

    @Test
    public void releasePathTest1() {
        this.build4RouterTopo(false, false, false, false, 5);
        LinkedList<CostConstraint> constraints = new LinkedList<CostConstraint>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        Collection tunnels = (Collection)this.pceManager.queryAllPath();
        MatcherAssert.assertThat((Object)tunnels.size(), (Matcher)Is.is((Object)1));
        for (Tunnel tunnel : tunnels) {
            boolean result = this.pceManager.releasePath(tunnel.tunnelId());
            MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        }
        tunnels = (Collection)this.pceManager.queryAllPath();
        MatcherAssert.assertThat((Object)tunnels.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void releasePathTest2() {
        this.build4RouterTopo(false, false, false, false, 5);
        LinkedList<CostConstraint> constraints = new LinkedList<CostConstraint>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        Collection tunnels = (Collection)this.pceManager.queryAllPath();
        MatcherAssert.assertThat((Object)tunnels.size(), (Matcher)Is.is((Object)1));
        boolean result = this.pceManager.releasePath(TunnelId.valueOf((String)"111"));
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)false));
        tunnels = (Collection)this.pceManager.queryAllPath();
        MatcherAssert.assertThat((Object)tunnels.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void packetProcessingTest1() throws URISyntaxException {
        this.build4RouterTopo(false, true, true, true, 0);
        LabelResourceId node1Label = LabelResourceId.labelResourceId((long)5200L);
        LabelResourceId node2Label = LabelResourceId.labelResourceId((long)5201L);
        this.pceManager.pceStore.addLsrIdDevice(this.deviceD1.annotations().value(LSRID), this.deviceD1.id());
        this.pceManager.pceStore.addGlobalNodeLabel(PathComputationTest.D1.deviceId(), node1Label);
        this.pceManager.pceStore.addGlobalNodeLabel(PathComputationTest.D2.deviceId(), node2Label);
        ConnectPoint src = new ConnectPoint((ElementId)PathComputationTest.D1.deviceId(), PortNumber.portNumber((long)1L));
        ConnectPoint dst = new ConnectPoint((ElementId)PathComputationTest.D2.deviceId(), PortNumber.portNumber((long)2L));
        DefaultLink link1 = DefaultLink.builder().src(src).dst(dst).state(Link.State.ACTIVE).type(Link.Type.DIRECT).providerId(new ProviderId("eth", "1")).build();
        LabelResourceId link1Label = LabelResourceId.labelResourceId((long)5204L);
        this.pceManager.pceStore.addAdjLabel((Link)link1, link1Label);
        TCP tcp = new TCP();
        tcp.setDestinationPort(4189);
        IPv4 ipv4 = new IPv4();
        ipv4.setProtocol((byte)6);
        ipv4.setPayload((IPacket)tcp);
        Ethernet eth = new Ethernet();
        eth.setEtherType(Ethernet.TYPE_IPV4);
        eth.setPayload((IPacket)ipv4);
        DefaultInboundPacket inPkt = new DefaultInboundPacket(new ConnectPoint((ElementId)DeviceId.deviceId((String)"1.1.1.1"), PortNumber.portNumber((long)4189L)), eth, null);
        this.pktProcessor.process((PacketContext)new MockPcepPacketContext((InboundPacket)inPkt, null));
        MatcherAssert.assertThat((Object)flowsDownloaded, (Matcher)Is.is((Object)4));
    }

    @Test
    public void packetProcessingTest2() throws URISyntaxException {
        this.build4RouterTopo(false, true, true, true, 0);
        LabelResourceId node1Label = LabelResourceId.labelResourceId((long)5200L);
        LabelResourceId node2Label = LabelResourceId.labelResourceId((long)5201L);
        this.pceManager.pceStore.addGlobalNodeLabel(PathComputationTest.D1.deviceId(), node1Label);
        this.pceManager.pceStore.addGlobalNodeLabel(PathComputationTest.D2.deviceId(), node2Label);
        ConnectPoint src = new ConnectPoint((ElementId)PathComputationTest.D1.deviceId(), PortNumber.portNumber((long)1L));
        ConnectPoint dst = new ConnectPoint((ElementId)PathComputationTest.D2.deviceId(), PortNumber.portNumber((long)2L));
        DefaultLink link1 = DefaultLink.builder().src(src).dst(dst).state(Link.State.ACTIVE).type(Link.Type.DIRECT).providerId(new ProviderId("eth", "1")).build();
        LabelResourceId link1Label = LabelResourceId.labelResourceId((long)5204L);
        this.pceManager.pceStore.addAdjLabel((Link)link1, link1Label);
        TCP tcp = new TCP();
        IPv4 ipv4 = new IPv4();
        ipv4.setProtocol((byte)6);
        ipv4.setPayload((IPacket)tcp);
        Ethernet eth = new Ethernet();
        eth.setEtherType(Ethernet.TYPE_IPV4);
        eth.setPayload((IPacket)ipv4);
        DefaultInboundPacket inPkt = new DefaultInboundPacket(new ConnectPoint((ElementId)PathComputationTest.D1.deviceId(), PortNumber.portNumber((long)4189L)), eth, null);
        this.pktProcessor.process((PacketContext)new MockPcepPacketContext((InboundPacket)inPkt, null));
        MatcherAssert.assertThat((Object)flowsDownloaded, (Matcher)Is.is((Object)0));
    }

    @Test
    public void tunnelEventTest1() {
        this.build4RouterTopo(false, true, true, true, 15);
        LinkedList<Object> constraints = new LinkedList<Object>();
        BandwidthConstraint bwConstraint = new BandwidthConstraint(Bandwidth.bps((double)10.0));
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        constraints.add(bwConstraint);
        LabelResourceId node1Label = LabelResourceId.labelResourceId((long)5200L);
        LabelResourceId node2Label = LabelResourceId.labelResourceId((long)5201L);
        this.pceManager.pceStore.addGlobalNodeLabel(PathComputationTest.D1.deviceId(), node1Label);
        this.pceManager.pceStore.addGlobalNodeLabel(PathComputationTest.D2.deviceId(), node2Label);
        LabelResourceId link1Label = LabelResourceId.labelResourceId((long)5202L);
        this.pceManager.pceStore.addAdjLabel(this.link1, link1Label);
        LabelResourceId link2Label = LabelResourceId.labelResourceId((long)5203L);
        this.pceManager.pceStore.addAdjLabel(this.link2, link2Label);
        LabelResourceId link3Label = LabelResourceId.labelResourceId((long)5204L);
        this.pceManager.pceStore.addAdjLabel(this.link3, link3Label);
        LabelResourceId link4Label = LabelResourceId.labelResourceId((long)5205L);
        this.pceManager.pceStore.addAdjLabel(this.link4, link4Label);
        this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T1", constraints, LspType.SR_WITHOUT_SIGNALLING);
        MatcherAssert.assertThat((Object)this.pceStore.getTunnelInfoCount(), (Matcher)Is.is((Object)1));
        Collection tunnels = (Collection)this.pceManager.queryAllPath();
        for (Tunnel tunnel : tunnels) {
            TunnelEvent event = new TunnelEvent(TunnelEvent.Type.TUNNEL_ADDED, tunnel);
            this.tunnelListener.event((Event)event);
            this.pceManager.releasePath(tunnel.tunnelId());
            event = new TunnelEvent(TunnelEvent.Type.TUNNEL_REMOVED, tunnel);
            this.tunnelListener.event((Event)event);
        }
        MatcherAssert.assertThat((Object)this.pceStore.getTunnelInfoCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void tunnelEventTest2() {
        TunnelEvent event;
        this.build4RouterTopo(false, true, true, true, 15);
        LinkedList<Object> constraints = new LinkedList<Object>();
        BandwidthConstraint bwConstraint = new BandwidthConstraint(Bandwidth.bps((double)10.0));
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        constraints.add(bwConstraint);
        this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T2", constraints, LspType.WITHOUT_SIGNALLING_AND_WITHOUT_SR);
        MatcherAssert.assertThat((Object)this.pceStore.getTunnelInfoCount(), (Matcher)Is.is((Object)1));
        Collection tunnels = (Collection)this.pceManager.queryAllPath();
        for (Tunnel tunnel : tunnels) {
            event = new TunnelEvent(TunnelEvent.Type.TUNNEL_ADDED, tunnel);
            this.tunnelListener.event((Event)event);
            this.tunnelService.updateTunnelWithLspIds(tunnel, "123", "1", Tunnel.State.ESTABLISHED);
        }
        tunnels = (Collection)this.pceManager.queryAllPath();
        for (Tunnel tunnel : tunnels) {
            event = new TunnelEvent(TunnelEvent.Type.TUNNEL_UPDATED, tunnel);
            this.tunnelListener.event((Event)event);
            this.pceManager.releasePath(tunnel.tunnelId());
            event = new TunnelEvent(TunnelEvent.Type.TUNNEL_REMOVED, tunnel);
            this.tunnelListener.event((Event)event);
        }
        MatcherAssert.assertThat((Object)this.pceStore.getTunnelInfoCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void tunnelEventTest3() {
        TunnelEvent event;
        this.build4RouterTopo(false, true, true, true, 15);
        LinkedList<Object> constraints = new LinkedList<Object>();
        BandwidthConstraint bwConstraint = new BandwidthConstraint(Bandwidth.bps((double)10.0));
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.TE_COST);
        constraints.add(costConstraint);
        constraints.add(bwConstraint);
        this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D2.deviceId(), "T2", constraints, LspType.WITHOUT_SIGNALLING_AND_WITHOUT_SR);
        MatcherAssert.assertThat((Object)this.pceStore.getTunnelInfoCount(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.pceStore.getFailedPathInfoCount(), (Matcher)Is.is((Object)0));
        Collection tunnels = (Collection)this.pceManager.queryAllPath();
        for (Tunnel tunnel : tunnels) {
            event = new TunnelEvent(TunnelEvent.Type.TUNNEL_ADDED, tunnel);
            this.tunnelListener.event((Event)event);
            this.tunnelService.updateTunnelWithLspIds(tunnel, "123", "1", Tunnel.State.UNSTABLE);
        }
        tunnels = (Collection)this.pceManager.queryAllPath();
        for (Tunnel tunnel : tunnels) {
            event = new TunnelEvent(TunnelEvent.Type.TUNNEL_UPDATED, tunnel);
            this.tunnelListener.event((Event)event);
        }
        MatcherAssert.assertThat((Object)this.pceStore.getTunnelInfoCount(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.pceStore.getFailedPathInfoCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void resilencyTest1() {
        this.build4RouterTopo(true, false, false, false, 10);
        LinkedList<Object> constraints = new LinkedList<Object>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.COST);
        constraints.add(costConstraint);
        BandwidthConstraint localBwConst = new BandwidthConstraint(Bandwidth.bps((long)10L));
        constraints.add(localBwConst);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D4.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.pceStore.getTunnelInfoCount(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.pceStore.getFailedPathInfoCount(), (Matcher)Is.is((Object)0));
        LinkedList<LinkEvent> reasons = new LinkedList<LinkEvent>();
        LinkEvent linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link2);
        reasons.add(linkEvent);
        TopologyEvent event = new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGED, this.topology, reasons);
        HashSet<TopologyEdge> tempEdges = new HashSet<TopologyEdge>();
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D2, PathComputationTest.D4, this.link2));
        this.topologyService.changeInTopology(this.getGraph(null, tempEdges));
        this.listener.event((Event)event);
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(this.link3);
        links.add(this.link4);
        MatcherAssert.assertThat((Object)((org.onosproject.net.Path)this.pathService.paths().iterator().next()).links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)((org.onosproject.net.Path)this.pathService.paths().iterator().next()).cost(), (Matcher)Is.is((Object)180.0));
    }

    @Test
    public void resilencyTest2() {
        this.build4RouterTopo(true, false, false, false, 10);
        LinkedList<Object> constraints = new LinkedList<Object>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.COST);
        constraints.add(costConstraint);
        BandwidthConstraint localBwConst = new BandwidthConstraint(Bandwidth.bps((long)10L));
        constraints.add(localBwConst);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D4.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        LinkedList<LinkEvent> reasons = new LinkedList<LinkEvent>();
        LinkEvent linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link2);
        reasons.add(linkEvent);
        linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link4);
        reasons.add(linkEvent);
        TopologyEvent event = new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGED, this.topology, reasons);
        HashSet<TopologyEdge> tempEdges = new HashSet<TopologyEdge>();
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D2, PathComputationTest.D4, this.link2));
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D3, PathComputationTest.D4, this.link4));
        this.topologyService.changeInTopology(this.getGraph(null, tempEdges));
        this.listener.event((Event)event);
        MatcherAssert.assertThat((Object)this.pathService.paths().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void resilencyTest3() {
        this.build4RouterTopo(true, false, false, false, 10);
        LinkedList<Object> constraints = new LinkedList<Object>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.COST);
        constraints.add(costConstraint);
        BandwidthConstraint localBwConst = new BandwidthConstraint(Bandwidth.bps((long)10L));
        constraints.add(localBwConst);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D4.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        LinkedList<LinkEvent> reasons = new LinkedList<LinkEvent>();
        LinkEvent linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link2);
        reasons.add(linkEvent);
        linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link1);
        reasons.add(linkEvent);
        TopologyEvent event = new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGED, this.topology, reasons);
        HashSet<TopologyEdge> tempEdges = new HashSet<TopologyEdge>();
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D2, PathComputationTest.D4, this.link2));
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D1, PathComputationTest.D2, this.link1));
        this.topologyService.changeInTopology(this.getGraph(null, tempEdges));
        this.listener.event((Event)event);
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(this.link3);
        links.add(this.link4);
        MatcherAssert.assertThat((Object)((org.onosproject.net.Path)this.pathService.paths().iterator().next()).links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)((org.onosproject.net.Path)this.pathService.paths().iterator().next()).cost(), (Matcher)Is.is((Object)180.0));
    }

    @Test
    public void resilencyTest4() {
        this.build4RouterTopo(true, false, false, false, 10);
        LinkedList<Object> constraints = new LinkedList<Object>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.COST);
        constraints.add(costConstraint);
        BandwidthConstraint localBwConst = new BandwidthConstraint(Bandwidth.bps((long)10L));
        constraints.add(localBwConst);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D4.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        LinkedList<LinkEvent> reasons = new LinkedList<LinkEvent>();
        LinkEvent linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link3);
        reasons.add(linkEvent);
        linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link1);
        reasons.add(linkEvent);
        TopologyEvent event = new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGED, this.topology, reasons);
        HashSet<TopologyEdge> tempEdges = new HashSet<TopologyEdge>();
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D1, PathComputationTest.D3, this.link3));
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D1, PathComputationTest.D2, this.link1));
        this.topologyService.changeInTopology(this.getGraph(null, tempEdges));
        this.listener.event((Event)event);
        MatcherAssert.assertThat((Object)this.pathService.paths().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void resilencyTest5() {
        this.build4RouterTopo(true, false, false, false, 10);
        LinkedList<Object> constraints = new LinkedList<Object>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.COST);
        constraints.add(costConstraint);
        BandwidthConstraint localBwConst = new BandwidthConstraint(Bandwidth.bps((long)10L));
        constraints.add(localBwConst);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D4.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        LinkedList<LinkEvent> reasons = new LinkedList<LinkEvent>();
        LinkEvent linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link2);
        reasons.add(linkEvent);
        linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link1);
        reasons.add(linkEvent);
        linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link3);
        reasons.add(linkEvent);
        linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link4);
        reasons.add(linkEvent);
        TopologyEvent event = new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGED, this.topology, reasons);
        HashSet<TopologyEdge> tempEdges = new HashSet<TopologyEdge>();
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D1, PathComputationTest.D2, this.link1));
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D2, PathComputationTest.D4, this.link2));
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D1, PathComputationTest.D3, this.link3));
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D3, PathComputationTest.D4, this.link4));
        HashSet<TopologyVertex> tempVertexes = new HashSet<TopologyVertex>();
        tempVertexes.add(PathComputationTest.D2);
        tempVertexes.add(PathComputationTest.D3);
        this.topologyService.changeInTopology(this.getGraph(tempVertexes, tempEdges));
        this.listener.event((Event)event);
        MatcherAssert.assertThat((Object)this.pathService.paths().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void resilencyTest6() {
        this.build4RouterTopo(true, false, false, false, 10);
        LinkedList<Object> constraints = new LinkedList<Object>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.COST);
        constraints.add(costConstraint);
        BandwidthConstraint localBwConst = new BandwidthConstraint(Bandwidth.bps((long)10L));
        constraints.add(localBwConst);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D4.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        LinkedList<LinkEvent> reasons = new LinkedList<LinkEvent>();
        LinkEvent linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link2);
        reasons.add(linkEvent);
        linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link4);
        reasons.add(linkEvent);
        TopologyEvent event = new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGED, this.topology, reasons);
        HashSet<TopologyEdge> tempEdges = new HashSet<TopologyEdge>();
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D2, PathComputationTest.D4, this.link2));
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D3, PathComputationTest.D4, this.link4));
        HashSet<TopologyVertex> tempVertexes = new HashSet<TopologyVertex>();
        tempVertexes.add(PathComputationTest.D4);
        this.topologyService.changeInTopology(this.getGraph(tempVertexes, tempEdges));
        this.listener.event((Event)event);
        MatcherAssert.assertThat((Object)this.pathService.paths().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void resilencyTest7() {
        this.build4RouterTopo(true, false, false, false, 10);
        LinkedList<Object> constraints = new LinkedList<Object>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.COST);
        constraints.add(costConstraint);
        BandwidthConstraint localBwConst = new BandwidthConstraint(Bandwidth.bps((long)10L));
        constraints.add(localBwConst);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D4.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        LinkedList<LinkEvent> reasons = new LinkedList<LinkEvent>();
        LinkEvent linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link2);
        reasons.add(linkEvent);
        linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link4);
        reasons.add(linkEvent);
        TopologyEvent event = new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGED, this.topology, reasons);
        HashSet<TopologyEdge> tempEdges = new HashSet<TopologyEdge>();
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D2, PathComputationTest.D4, this.link2));
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D3, PathComputationTest.D4, this.link4));
        HashSet<TopologyVertex> tempVertexes = new HashSet<TopologyVertex>();
        tempVertexes.add(PathComputationTest.D4);
        this.topologyService.changeInTopology(this.getGraph(tempVertexes, tempEdges));
        this.listener.event((Event)event);
        MatcherAssert.assertThat((Object)this.pathService.paths().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void resilencyTest8() {
        this.build4RouterTopo(true, false, false, false, 10);
        LinkedList<Object> constraints = new LinkedList<Object>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.COST);
        constraints.add(costConstraint);
        BandwidthConstraint localBwConst = new BandwidthConstraint(Bandwidth.bps((long)10L));
        constraints.add(localBwConst);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D4.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        LinkedList<LinkEvent> reasons = new LinkedList<LinkEvent>();
        LinkEvent linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link1);
        reasons.add(linkEvent);
        linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link2);
        reasons.add(linkEvent);
        TopologyEvent event = new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGED, this.topology, reasons);
        HashSet<TopologyEdge> tempEdges = new HashSet<TopologyEdge>();
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D1, PathComputationTest.D2, this.link1));
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D2, PathComputationTest.D4, this.link2));
        HashSet<TopologyVertex> tempVertexes = new HashSet<TopologyVertex>();
        tempVertexes.add(PathComputationTest.D2);
        this.topologyService.changeInTopology(this.getGraph(tempVertexes, tempEdges));
        this.listener.event((Event)event);
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(this.link3);
        links.add(this.link4);
        MatcherAssert.assertThat((Object)((org.onosproject.net.Path)this.pathService.paths().iterator().next()).links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)((org.onosproject.net.Path)this.pathService.paths().iterator().next()).cost(), (Matcher)Is.is((Object)180.0));
    }

    @Test
    public void resilencyTest11() {
        this.build4RouterTopo(true, false, false, false, 10);
        LinkedList<Object> constraints = new LinkedList<Object>();
        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.COST);
        constraints.add(costConstraint);
        BandwidthConstraint localBwConst = new BandwidthConstraint(Bandwidth.bps((long)10L));
        constraints.add(localBwConst);
        boolean result = this.pceManager.setupPath(PathComputationTest.D1.deviceId(), PathComputationTest.D4.deviceId(), "T123", constraints, LspType.WITH_SIGNALLING);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        LinkedList<LinkEvent> reasons = new LinkedList<LinkEvent>();
        LinkEvent linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link1);
        reasons.add(linkEvent);
        linkEvent = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link2);
        reasons.add(linkEvent);
        TopologyEvent event = new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGED, this.topology, reasons);
        HashSet<TopologyEdge> tempEdges = new HashSet<TopologyEdge>();
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D1, PathComputationTest.D2, this.link1));
        tempEdges.add((TopologyEdge)new DefaultTopologyEdge(PathComputationTest.D2, PathComputationTest.D4, this.link2));
        HashSet<TopologyVertex> tempVertexes = new HashSet<TopologyVertex>();
        tempVertexes.add(PathComputationTest.D2);
        this.topologyService.changeInTopology(this.getGraph(tempVertexes, tempEdges));
        this.listener.event((Event)event);
        LinkedList<Link> links = new LinkedList<Link>();
        links.add(this.link3);
        links.add(this.link4);
        MatcherAssert.assertThat((Object)((org.onosproject.net.Path)this.pathService.paths().iterator().next()).links(), (Matcher)Is.is(links));
        MatcherAssert.assertThat((Object)((org.onosproject.net.Path)this.pathService.paths().iterator().next()).cost(), (Matcher)Is.is((Object)180.0));
    }

    @Test
    public void deviceEventTest() {
        this.build4RouterTopo(true, false, true, true, 0);
        DefaultAnnotations.Builder builderDev5 = DefaultAnnotations.builder();
        builderDev5.set("type", L3);
        builderDev5.set(LSRID, "5.5.5.5");
        MockDevice dev5 = new MockDevice(DeviceId.deviceId((String)"P005"), (Annotations)builderDev5.build());
        this.deviceService.addDevice((Device)dev5);
        DeviceCapability device5Cap = this.netConfigRegistry.addConfig(DeviceId.deviceId((String)"5.5.5.5"), DeviceCapability.class);
        device5Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        DeviceListener listener = this.deviceService.getListener();
        this.deviceService.removeDevice((Device)dev5);
        DeviceEvent event = new DeviceEvent(DeviceEvent.Type.DEVICE_REMOVED, (Device)dev5);
        listener.event((Event)event);
        MatcherAssert.assertThat((Object)this.pceStore.getGlobalNodeLabel(dev5.id()), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void linkEventTest() {
        this.build4RouterTopo(true, false, true, true, 0);
        LinkListener listener = this.linkService.getListener();
        this.linkService.addLink(this.link3);
        LinkEvent event = new LinkEvent(LinkEvent.Type.LINK_ADDED, this.link3);
        listener.event((Event)event);
        MatcherAssert.assertThat((Object)this.pceStore.getAdjLabel(this.link3), (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        this.linkService.addLink(this.link4);
        event = new LinkEvent(LinkEvent.Type.LINK_ADDED, this.link4);
        listener.event((Event)event);
        MatcherAssert.assertThat((Object)this.pceStore.getAdjLabel(this.link4), (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        this.linkService.removeLink(this.link3);
        event = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link3);
        listener.event((Event)event);
        MatcherAssert.assertThat((Object)this.pceStore.getAdjLabel(this.link3), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        this.linkService.removeLink(this.link4);
        event = new LinkEvent(LinkEvent.Type.LINK_REMOVED, this.link4);
        listener.event((Event)event);
        MatcherAssert.assertThat((Object)this.pceStore.getAdjLabel(this.link4), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @After
    public void tearDown() {
        this.pceManager.deactivate();
        this.pceManager.pathService = null;
        this.pceManager.resourceService = null;
        this.pceManager.tunnelService = null;
        this.pceManager.coreService = null;
        this.pceManager.storageService = null;
        this.pceManager.packetService = null;
        this.pceManager.deviceService = null;
        this.pceManager.linkService = null;
        this.pceManager.netCfgService = null;
        this.pceManager.labelRsrcAdminService = null;
        this.pceManager.labelRsrcService = null;
        this.pceManager.flowObjectiveService = null;
        this.pceManager.pceStore = null;
        this.pceManager.topologyService = null;
        this.pceManager.mastershipService = null;
        flowsDownloaded = 0;
    }

    private TopologyGraph getGraph(Set<TopologyVertex> removedVertex, Set<TopologyEdge> removedEdges) {
        if (removedVertex != null) {
            this.vertexes.remove(removedVertex);
            removedVertex.forEach(v -> this.vertexes.remove(v));
        }
        if (removedEdges != null) {
            removedEdges.forEach(e -> this.edges.remove(e));
        }
        return new DefaultTopologyGraph(this.vertexes, this.edges);
    }

    public static class MockFlowObjService
    extends FlowObjServiceAdapter {
        @Override
        public void forward(DeviceId deviceId, ForwardingObjective forwardingObjective) {
            ++flowsDownloaded;
        }
    }

    final class MockPcepPacketContext
    extends DefaultPacketContext {
        private MockPcepPacketContext(InboundPacket inPkt, OutboundPacket outPkt) {
            super(System.currentTimeMillis(), inPkt, outPkt, false);
        }

        public void send() {
        }
    }

    private class MockPacketService
    extends PacketServiceAdapter {
        private MockPacketService() {
        }

        public void addProcessor(PacketProcessor processor, int priority) {
            PceManagerTest.this.pktProcessor = processor;
        }
    }

    private class MockDevice
    extends DefaultDevice {
        MockDevice(DeviceId id, Annotations annotations) {
            super(null, id, null, null, null, null, null, null, new Annotations[]{annotations});
        }
    }

    public static class MockCoreService
    extends CoreServiceAdapter {
        public ApplicationId registerApplication(String name) {
            return new DefaultApplicationId(1, name);
        }

        public IdGenerator getIdGenerator(String topic) {
            return new IdGenerator(){
                private AtomicLong counter = new AtomicLong(0L);

                public long getNewId() {
                    return this.counter.getAndIncrement();
                }
            };
        }
    }

    private class MockTunnelServiceAdapter
    extends TunnelServiceAdapter {
        private HashMap<TunnelId, Tunnel> tunnelIdAsKeyStore = new HashMap();
        private int tunnelIdCounter = 0;

        private MockTunnelServiceAdapter() {
        }

        @Override
        public TunnelId setupTunnel(ApplicationId producerId, ElementId srcElementId, Tunnel tunnel, org.onosproject.net.Path path) {
            TunnelId tunnelId = TunnelId.valueOf((String)String.valueOf(++this.tunnelIdCounter));
            DefaultTunnel tunnelToInsert = new DefaultTunnel(tunnel.providerId(), tunnel.src(), tunnel.dst(), tunnel.type(), tunnel.state(), tunnel.groupId(), tunnelId, tunnel.tunnelName(), path, new Annotations[]{tunnel.annotations()});
            this.tunnelIdAsKeyStore.put(tunnelId, (Tunnel)tunnelToInsert);
            return tunnelId;
        }

        @Override
        public void addListener(TunnelListener listener) {
            PceManagerTest.this.tunnelListener = listener;
        }

        public TunnelId updateTunnelWithLspIds(Tunnel tunnel, String pLspId, String localLspId, Tunnel.State state) {
            TunnelId tunnelId = tunnel.tunnelId();
            DefaultAnnotations.Builder annotationBuilder = DefaultAnnotations.builder();
            annotationBuilder.putAll(tunnel.annotations());
            if (tunnel.annotations().value("PLspId") == null) {
                annotationBuilder.set("PLspId", pLspId);
            }
            if (tunnel.annotations().value("localLspId") == null) {
                annotationBuilder.set("localLspId", localLspId);
            }
            DefaultAnnotations annotations = annotationBuilder.build();
            this.tunnelIdAsKeyStore.remove(tunnelId, tunnel);
            DefaultTunnel tunnelToInsert = new DefaultTunnel(tunnel.providerId(), tunnel.src(), tunnel.dst(), tunnel.type(), state, tunnel.groupId(), tunnelId, tunnel.tunnelName(), tunnel.path(), new Annotations[]{annotations});
            this.tunnelIdAsKeyStore.put(tunnelId, (Tunnel)tunnelToInsert);
            return tunnelId;
        }

        @Override
        public boolean downTunnel(ApplicationId producerId, TunnelId tunnelId) {
            for (TunnelId tunnelIdKey : this.tunnelIdAsKeyStore.keySet()) {
                if (!tunnelIdKey.equals((Object)tunnelId)) continue;
                this.tunnelIdAsKeyStore.remove(tunnelId);
                return true;
            }
            return false;
        }

        @Override
        public Tunnel queryTunnel(TunnelId tunnelId) {
            for (TunnelId tunnelIdKey : this.tunnelIdAsKeyStore.keySet()) {
                if (!tunnelIdKey.equals((Object)tunnelId)) continue;
                return this.tunnelIdAsKeyStore.get(tunnelId);
            }
            return null;
        }

        @Override
        public Collection<Tunnel> queryTunnel(TunnelEndPoint src, TunnelEndPoint dst) {
            HashSet<Tunnel> result = new HashSet<Tunnel>();
            Tunnel tunnel = null;
            for (TunnelId tunnelId : this.tunnelIdAsKeyStore.keySet()) {
                tunnel = this.tunnelIdAsKeyStore.get(tunnelId);
                if (null == tunnel || !src.equals(tunnel.src()) || !dst.equals(tunnel.dst())) continue;
                result.add(tunnel);
            }
            return result.size() == 0 ? Collections.emptySet() : ImmutableSet.copyOf(result);
        }

        @Override
        public Collection<Tunnel> queryTunnel(Tunnel.Type type) {
            HashSet<Tunnel> result = new HashSet<Tunnel>();
            for (TunnelId tunnelId : this.tunnelIdAsKeyStore.keySet()) {
                result.add(this.tunnelIdAsKeyStore.get(tunnelId));
            }
            return result.size() == 0 ? Collections.emptySet() : ImmutableSet.copyOf(result);
        }

        @Override
        public Collection<Tunnel> queryAllTunnels() {
            HashSet<Tunnel> result = new HashSet<Tunnel>();
            for (TunnelId tunnelId : this.tunnelIdAsKeyStore.keySet()) {
                result.add(this.tunnelIdAsKeyStore.get(tunnelId));
            }
            return result.size() == 0 ? Collections.emptySet() : ImmutableSet.copyOf(result);
        }

        @Override
        public Iterable<Tunnel> getTunnels(DeviceId deviceId) {
            LinkedList<Tunnel> tunnelList = new LinkedList<Tunnel>();
            block0: for (Tunnel t : this.tunnelIdAsKeyStore.values()) {
                for (Link l : t.path().links()) {
                    if (!l.src().deviceId().equals((Object)deviceId) && !l.dst().deviceId().equals((Object)deviceId)) continue;
                    tunnelList.add(t);
                    continue block0;
                }
            }
            return tunnelList;
        }
    }

    private class MockPathService
    extends PathServiceAdapter {
        Set<org.onosproject.net.Path> computedPaths;

        private MockPathService() {
        }

        public Set<org.onosproject.net.Path> getPaths(ElementId src, ElementId dst, LinkWeight weight) {
            if (src == null || dst == null) {
                return ImmutableSet.of();
            }
            this.computedPaths = PceManagerTest.this.topologyService.getPaths(null, (DeviceId)src, (DeviceId)dst, weight);
            return this.computedPaths;
        }

        private Set<org.onosproject.net.Path> paths() {
            return this.computedPaths;
        }
    }

    private class MockTopologyService
    extends TopologyServiceAdapter {
        private MockTopologyService() {
        }

        private void changeInTopology(TopologyGraph graphModified) {
            PceManagerTest.this.graph = graphModified;
        }

        public Set<org.onosproject.net.Path> getPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeight weight) {
            DefaultTopologyVertex srcV = new DefaultTopologyVertex(src);
            DefaultTopologyVertex dstV = new DefaultTopologyVertex(dst);
            Set vertices = PceManagerTest.this.graph.getVertexes();
            if (!vertices.contains(srcV) || !vertices.contains(dstV)) {
                return ImmutableSet.of();
            }
            GraphPathSearch.Result result = PathComputationTest.graphSearch().search((Graph)PceManagerTest.this.graph, (Vertex)srcV, (Vertex)dstV, (EdgeWeight)weight, -1);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Path path : result.paths()) {
                builder.add((Object)PathComputationTest.networkPath((Path<TopologyVertex, TopologyEdge>)path));
            }
            return builder.build();
        }
    }

    private class MockMastershipService
    extends MastershipServiceAdapter {
        private MockMastershipService() {
        }

        public MastershipRole getLocalRole(DeviceId deviceId) {
            return MastershipRole.MASTER;
        }

        public boolean isLocalMaster(DeviceId deviceId) {
            return this.getLocalRole(deviceId) == MastershipRole.MASTER;
        }
    }
}

