/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.incubator.net.resource.label.LabelResourceAdminService;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.resource.label.LabelResourceService;
import org.onosproject.incubator.net.tunnel.LabelStack;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.pce.pceservice.PathComputationTest;
import org.onosproject.pce.pceservice.PceManagerTest;
import org.onosproject.pce.pceservice.PceccSrTeBeHandler;
import org.onosproject.pce.pcestore.api.PceStore;
import org.onosproject.pce.util.LabelResourceAdapter;
import org.onosproject.pce.util.MockDeviceService;
import org.onosproject.pce.util.PceStoreAdapter;
import org.onosproject.pcep.api.DeviceCapability;

public class PceccSrTeBeHandlerTest {
    public static final long GLOBAL_LABEL_SPACE_MIN = 4097L;
    public static final long GLOBAL_LABEL_SPACE_MAX = 5121L;
    private static final String L3 = "L3";
    private static final String LSRID = "lsrId";
    private PceccSrTeBeHandler srTeHandler;
    private CoreService coreService;
    private LabelResourceAdminService labelRsrcAdminService;
    private LabelResourceService labelRsrcService;
    private PceStore pceStore;
    private MockDeviceService deviceService;
    private FlowObjectiveService flowObjectiveService;
    private PathComputationTest.MockNetConfigRegistryAdapter netCfgService = new PathComputationTest.MockNetConfigRegistryAdapter();
    private ApplicationId appId;
    private ProviderId providerId;
    private Device deviceD1;
    private Device deviceD2;
    private Device deviceD3;
    private Device deviceD4;
    private Device deviceD5;
    private PortNumber port1;
    private PortNumber port2;
    private PortNumber port3;
    private PortNumber port4;
    private PortNumber port5;
    private Link link1;
    private Link link2;
    private Link link3;
    private Link link4;
    private Path path1;
    LabelResourceId labelId;

    @Before
    public void setUp() throws Exception {
        this.srTeHandler = PceccSrTeBeHandler.getInstance();
        this.labelRsrcService = new LabelResourceAdapter();
        this.labelRsrcAdminService = new LabelResourceAdapter();
        this.flowObjectiveService = new PceManagerTest.MockFlowObjService();
        this.coreService = new PceManagerTest.MockCoreService();
        this.appId = this.coreService.registerApplication("org.onosproject.pce");
        this.pceStore = new PceStoreAdapter();
        this.deviceService = new MockDeviceService();
        this.srTeHandler.initialize(this.labelRsrcAdminService, this.labelRsrcService, this.flowObjectiveService, this.appId, this.pceStore, (DeviceService)this.deviceService);
        this.providerId = new ProviderId("of", "foo");
        DefaultAnnotations.Builder builderDev1 = DefaultAnnotations.builder();
        DefaultAnnotations.Builder builderDev2 = DefaultAnnotations.builder();
        DefaultAnnotations.Builder builderDev3 = DefaultAnnotations.builder();
        DefaultAnnotations.Builder builderDev4 = DefaultAnnotations.builder();
        DefaultAnnotations.Builder builderDev5 = DefaultAnnotations.builder();
        builderDev1.set("type", L3);
        builderDev1.set(LSRID, "1.1.1.1");
        builderDev2.set("type", L3);
        builderDev2.set(LSRID, "2.2.2.2");
        builderDev3.set("type", L3);
        builderDev3.set(LSRID, "3.3.3.3");
        builderDev4.set("type", L3);
        builderDev4.set(LSRID, "4.4.4.4");
        builderDev5.set("type", L3);
        builderDev5.set(LSRID, "5.5.5.5");
        this.deviceD1 = new MockDevice(PathComputationTest.D1.deviceId(), (Annotations)builderDev1.build());
        this.deviceD2 = new MockDevice(PathComputationTest.D2.deviceId(), (Annotations)builderDev2.build());
        this.deviceD3 = new MockDevice(PathComputationTest.D3.deviceId(), (Annotations)builderDev3.build());
        this.deviceD4 = new MockDevice(PathComputationTest.D4.deviceId(), (Annotations)builderDev4.build());
        this.deviceD5 = new MockDevice(PathComputationTest.D5.deviceId(), (Annotations)builderDev5.build());
        this.deviceService.addDevice(this.deviceD1);
        this.deviceService.addDevice(this.deviceD2);
        this.deviceService.addDevice(this.deviceD3);
        this.deviceService.addDevice(this.deviceD4);
        this.deviceService.addDevice(this.deviceD5);
        DeviceCapability device1Cap = this.netCfgService.addConfig(DeviceId.deviceId((String)"1.1.1.1"), DeviceCapability.class);
        device1Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        DeviceCapability device2Cap = this.netCfgService.addConfig(DeviceId.deviceId((String)"2.2.2.2"), DeviceCapability.class);
        device2Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        DeviceCapability device3Cap = this.netCfgService.addConfig(DeviceId.deviceId((String)"3.3.3.3"), DeviceCapability.class);
        device3Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        DeviceCapability device4Cap = this.netCfgService.addConfig(DeviceId.deviceId((String)"4.4.4.4"), DeviceCapability.class);
        device4Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        DeviceCapability device5Cap = this.netCfgService.addConfig(DeviceId.deviceId((String)"5.5.5.5"), DeviceCapability.class);
        device5Cap.setLabelStackCap(true).setLocalLabelCap(false).setSrCap(true).apply();
        this.port1 = PortNumber.portNumber((long)1L);
        this.port2 = PortNumber.portNumber((long)2L);
        this.port3 = PortNumber.portNumber((long)3L);
        this.port4 = PortNumber.portNumber((long)4L);
        this.port5 = PortNumber.portNumber((long)5L);
        LinkedList<Link> linkList = new LinkedList<Link>();
        this.link1 = DefaultLink.builder().providerId(this.providerId).annotations((Annotations)DefaultAnnotations.builder().set("key1", "yahoo").build()).src(new ConnectPoint((ElementId)this.deviceD1.id(), this.port1)).dst(new ConnectPoint((ElementId)this.deviceD2.id(), this.port2)).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
        linkList.add(this.link1);
        this.link2 = DefaultLink.builder().providerId(this.providerId).annotations((Annotations)DefaultAnnotations.builder().set("key2", "yahoo").build()).src(new ConnectPoint((ElementId)this.deviceD2.id(), this.port2)).dst(new ConnectPoint((ElementId)this.deviceD3.id(), this.port3)).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
        linkList.add(this.link2);
        this.link3 = DefaultLink.builder().providerId(this.providerId).annotations((Annotations)DefaultAnnotations.builder().set("key3", "yahoo").build()).src(new ConnectPoint((ElementId)this.deviceD3.id(), this.port3)).dst(new ConnectPoint((ElementId)this.deviceD4.id(), this.port4)).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
        linkList.add(this.link3);
        this.link4 = DefaultLink.builder().providerId(this.providerId).annotations((Annotations)DefaultAnnotations.builder().set("key4", "yahoo").build()).src(new ConnectPoint((ElementId)this.deviceD4.id(), this.port4)).dst(new ConnectPoint((ElementId)this.deviceD5.id(), this.port5)).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
        linkList.add(this.link4);
        this.path1 = new DefaultPath(this.providerId, linkList, 10.0, new Annotations[0]);
    }

    @After
    public void tearDown() throws Exception {
        PceManagerTest.flowsDownloaded = 0;
    }

    @Test
    public void testGetInstance() {
        MatcherAssert.assertThat((Object)this.srTeHandler, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testReserveGlobalPool() {
        MatcherAssert.assertThat((Object)this.srTeHandler.reserveGlobalPool(4097L, 5121L), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAllocateNodeLabel() {
        String lsrId1 = "11.1.1.1";
        MatcherAssert.assertThat((Object)this.srTeHandler.allocateNodeLabel(PathComputationTest.D1.deviceId(), lsrId1), (Matcher)Matchers.is((Object)true));
        LabelResourceId labelId = this.pceStore.getGlobalNodeLabel(PathComputationTest.D1.deviceId());
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String lsrId2 = "12.1.1.1";
        MatcherAssert.assertThat((Object)this.srTeHandler.allocateNodeLabel(PathComputationTest.D2.deviceId(), lsrId2), (Matcher)Matchers.is((Object)true));
        labelId = this.pceStore.getGlobalNodeLabel(PathComputationTest.D2.deviceId());
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String lsrId3 = "13.1.1.1";
        MatcherAssert.assertThat((Object)this.srTeHandler.allocateNodeLabel(PathComputationTest.D3.deviceId(), lsrId3), (Matcher)Matchers.is((Object)true));
        labelId = this.pceStore.getGlobalNodeLabel(PathComputationTest.D3.deviceId());
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String lsrId4 = "14.1.1.1";
        MatcherAssert.assertThat((Object)this.srTeHandler.allocateNodeLabel(PathComputationTest.D4.deviceId(), lsrId4), (Matcher)Matchers.is((Object)true));
        labelId = this.pceStore.getGlobalNodeLabel(PathComputationTest.D4.deviceId());
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String lsrId5 = "15.1.1.1";
        MatcherAssert.assertThat((Object)this.srTeHandler.allocateNodeLabel(PathComputationTest.D5.deviceId(), lsrId5), (Matcher)Matchers.is((Object)true));
        labelId = this.pceStore.getGlobalNodeLabel(PathComputationTest.D5.deviceId());
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testReleaseNodeLabelSuccess() {
        this.testAllocateNodeLabel();
        String lsrId1 = "11.1.1.1";
        MatcherAssert.assertThat((Object)this.srTeHandler.releaseNodeLabel(PathComputationTest.D1.deviceId(), lsrId1), (Matcher)Matchers.is((Object)true));
        LabelResourceId labelId = this.pceStore.getGlobalNodeLabel(PathComputationTest.D1.deviceId());
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        String lsrId2 = "12.1.1.1";
        MatcherAssert.assertThat((Object)this.srTeHandler.releaseNodeLabel(PathComputationTest.D2.deviceId(), lsrId2), (Matcher)Matchers.is((Object)true));
        labelId = this.pceStore.getGlobalNodeLabel(PathComputationTest.D2.deviceId());
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        String lsrId3 = "13.1.1.1";
        MatcherAssert.assertThat((Object)this.srTeHandler.releaseNodeLabel(PathComputationTest.D3.deviceId(), lsrId3), (Matcher)Matchers.is((Object)true));
        labelId = this.pceStore.getGlobalNodeLabel(PathComputationTest.D3.deviceId());
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        String lsrId4 = "14.1.1.1";
        MatcherAssert.assertThat((Object)this.srTeHandler.releaseNodeLabel(PathComputationTest.D4.deviceId(), lsrId4), (Matcher)Matchers.is((Object)true));
        labelId = this.pceStore.getGlobalNodeLabel(PathComputationTest.D4.deviceId());
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        String lsrId5 = "15.1.1.1";
        MatcherAssert.assertThat((Object)this.srTeHandler.releaseNodeLabel(PathComputationTest.D5.deviceId(), lsrId5), (Matcher)Matchers.is((Object)true));
        labelId = this.pceStore.getGlobalNodeLabel(PathComputationTest.D5.deviceId());
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testReleaseNodeLabelFailure() {
        this.testAllocateNodeLabel();
        String lsrId6 = "16.1.1.1";
        DeviceId deviceId6 = DeviceId.deviceId((String)"foo6");
        MatcherAssert.assertThat((Object)this.srTeHandler.releaseNodeLabel(deviceId6, lsrId6), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAllocateAdjacencyLabel() {
        MatcherAssert.assertThat((Object)this.srTeHandler.allocateAdjacencyLabel(this.link1), (Matcher)Matchers.is((Object)true));
        LabelResourceId labelId = this.pceStore.getAdjLabel(this.link1);
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.srTeHandler.allocateAdjacencyLabel(this.link2), (Matcher)Matchers.is((Object)true));
        labelId = this.pceStore.getAdjLabel(this.link2);
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.srTeHandler.allocateAdjacencyLabel(this.link3), (Matcher)Matchers.is((Object)true));
        labelId = this.pceStore.getAdjLabel(this.link3);
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.srTeHandler.allocateAdjacencyLabel(this.link4), (Matcher)Matchers.is((Object)true));
        labelId = this.pceStore.getAdjLabel(this.link4);
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testReleaseAdjacencyLabel() {
        MatcherAssert.assertThat((Object)this.srTeHandler.allocateAdjacencyLabel(this.link1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.srTeHandler.releaseAdjacencyLabel(this.link1), (Matcher)Matchers.is((Object)true));
        LabelResourceId labelId = this.pceStore.getAdjLabel(this.link1);
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)this.srTeHandler.allocateAdjacencyLabel(this.link2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.srTeHandler.releaseAdjacencyLabel(this.link2), (Matcher)Matchers.is((Object)true));
        labelId = this.pceStore.getAdjLabel(this.link2);
        MatcherAssert.assertThat((Object)labelId, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testComputeLabelStack() {
        this.labelId = LabelResourceId.labelResourceId((long)4097L);
        this.pceStore.addGlobalNodeLabel(PathComputationTest.D1.deviceId(), this.labelId);
        this.labelId = LabelResourceId.labelResourceId((long)4098L);
        this.pceStore.addGlobalNodeLabel(PathComputationTest.D2.deviceId(), this.labelId);
        this.labelId = LabelResourceId.labelResourceId((long)4099L);
        this.pceStore.addGlobalNodeLabel(PathComputationTest.D3.deviceId(), this.labelId);
        this.labelId = LabelResourceId.labelResourceId((long)4100L);
        this.pceStore.addGlobalNodeLabel(PathComputationTest.D4.deviceId(), this.labelId);
        this.labelId = LabelResourceId.labelResourceId((long)4101L);
        this.pceStore.addGlobalNodeLabel(PathComputationTest.D5.deviceId(), this.labelId);
        this.labelId = LabelResourceId.labelResourceId((long)5122L);
        this.pceStore.addAdjLabel(this.link1, this.labelId);
        this.labelId = LabelResourceId.labelResourceId((long)5123L);
        this.pceStore.addAdjLabel(this.link2, this.labelId);
        this.labelId = LabelResourceId.labelResourceId((long)5124L);
        this.pceStore.addAdjLabel(this.link3, this.labelId);
        this.labelId = LabelResourceId.labelResourceId((long)5125L);
        this.pceStore.addAdjLabel(this.link4, this.labelId);
        LabelStack labelStack = this.srTeHandler.computeLabelStack(this.path1);
        List labelList = labelStack.labelResources();
        Iterator iterator = labelList.iterator();
        this.labelId = (LabelResourceId)iterator.next();
        MatcherAssert.assertThat((Object)this.labelId, (Matcher)Matchers.is((Object)LabelResourceId.labelResourceId((long)5122L)));
        this.labelId = (LabelResourceId)iterator.next();
        MatcherAssert.assertThat((Object)this.labelId, (Matcher)Matchers.is((Object)LabelResourceId.labelResourceId((long)4098L)));
        this.labelId = (LabelResourceId)iterator.next();
        MatcherAssert.assertThat((Object)this.labelId, (Matcher)Matchers.is((Object)LabelResourceId.labelResourceId((long)5123L)));
        this.labelId = (LabelResourceId)iterator.next();
        MatcherAssert.assertThat((Object)this.labelId, (Matcher)Matchers.is((Object)LabelResourceId.labelResourceId((long)4099L)));
        this.labelId = (LabelResourceId)iterator.next();
        MatcherAssert.assertThat((Object)this.labelId, (Matcher)Matchers.is((Object)LabelResourceId.labelResourceId((long)5124L)));
        this.labelId = (LabelResourceId)iterator.next();
        MatcherAssert.assertThat((Object)this.labelId, (Matcher)Matchers.is((Object)LabelResourceId.labelResourceId((long)4100L)));
        this.labelId = (LabelResourceId)iterator.next();
        MatcherAssert.assertThat((Object)this.labelId, (Matcher)Matchers.is((Object)LabelResourceId.labelResourceId((long)5125L)));
        this.labelId = (LabelResourceId)iterator.next();
        MatcherAssert.assertThat((Object)this.labelId, (Matcher)Matchers.is((Object)LabelResourceId.labelResourceId((long)4101L)));
    }

    private class MockDevice
    extends DefaultDevice {
        MockDevice(DeviceId id, Annotations annotations) {
            super(null, id, null, null, null, null, null, null, new Annotations[]{annotations});
        }
    }
}

