/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pcestore;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.util.DataRateUnit;
import org.onosproject.incubator.net.resource.label.DefaultLabelResource;
import org.onosproject.incubator.net.resource.label.LabelResource;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.pce.pceservice.LspType;
import org.onosproject.pce.pceservice.TunnelConsumerId;
import org.onosproject.pce.pcestore.DefaultLspLocalLabelInfo;
import org.onosproject.pce.pcestore.DistributedPceStore;
import org.onosproject.pce.pcestore.PcePathInfo;
import org.onosproject.pce.pcestore.PceccTunnelInfo;
import org.onosproject.pce.pcestore.api.LspLocalLabelInfo;
import org.onosproject.store.service.TestStorageService;

public class DistributedPceStoreTest {
    private DistributedPceStore distrPceStore;
    private DeviceId deviceId1 = DeviceId.deviceId((String)"foo");
    private DeviceId deviceId2 = DeviceId.deviceId((String)"goo");
    private DeviceId deviceId3 = DeviceId.deviceId((String)"yaa");
    private DeviceId deviceId4 = DeviceId.deviceId((String)"zoo");
    private LabelResourceId labelId1 = LabelResourceId.labelResourceId((long)1L);
    private LabelResourceId labelId2 = LabelResourceId.labelResourceId((long)2L);
    private LabelResourceId labelId3 = LabelResourceId.labelResourceId((long)3L);
    private LabelResourceId labelId4 = LabelResourceId.labelResourceId((long)4L);
    private PortNumber portNumber1 = PortNumber.portNumber((long)1L);
    private PortNumber portNumber2 = PortNumber.portNumber((long)2L);
    private PortNumber portNumber3 = PortNumber.portNumber((long)3L);
    private PortNumber portNumber4 = PortNumber.portNumber((long)4L);
    private ConnectPoint srcConnectionPoint1 = new ConnectPoint((ElementId)this.deviceId1, this.portNumber1);
    private ConnectPoint dstConnectionPoint2 = new ConnectPoint((ElementId)this.deviceId2, this.portNumber2);
    private ConnectPoint srcConnectionPoint3 = new ConnectPoint((ElementId)this.deviceId3, this.portNumber3);
    private ConnectPoint dstConnectionPoint4 = new ConnectPoint((ElementId)this.deviceId4, this.portNumber4);
    private LabelResource labelResource1 = new DefaultLabelResource(this.deviceId1, this.labelId1);
    private LabelResource labelResource2 = new DefaultLabelResource(this.deviceId2, this.labelId2);
    private LabelResource labelResource3 = new DefaultLabelResource(this.deviceId3, this.labelId3);
    private LabelResource labelResource4 = new DefaultLabelResource(this.deviceId4, this.labelId4);
    private Link link1;
    private Link link2;
    private List<LabelResource> labelList1 = new LinkedList<LabelResource>();
    private List<LabelResource> labelList2 = new LinkedList<LabelResource>();
    private TunnelId tunnelId1 = TunnelId.valueOf((String)"1");
    private TunnelId tunnelId2 = TunnelId.valueOf((String)"2");
    private TunnelId tunnelId3 = TunnelId.valueOf((String)"3");
    private TunnelId tunnelId4 = TunnelId.valueOf((String)"4");
    private PceccTunnelInfo pceccTunnelInfo1;
    private PceccTunnelInfo pceccTunnelInfo2;
    private PcePathInfo failedPathInfo1;
    private PcePathInfo failedPathInfo2;
    private PcePathInfo failedPathInfo3;
    private PcePathInfo failedPathInfo4;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.distrPceStore = new DistributedPceStore();
        this.link1 = DefaultLink.builder().providerId(new ProviderId("eth", "1")).annotations((Annotations)DefaultAnnotations.builder().set("key1", "yahoo").build()).src(this.srcConnectionPoint1).dst(this.dstConnectionPoint2).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
        this.link2 = DefaultLink.builder().providerId(new ProviderId("mac", "2")).annotations((Annotations)DefaultAnnotations.builder().set("key2", "google").build()).src(this.srcConnectionPoint3).dst(this.dstConnectionPoint4).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
        this.labelList1.add(this.labelResource1);
        this.labelList1.add(this.labelResource2);
        this.labelList2.add(this.labelResource3);
        this.labelList2.add(this.labelResource4);
        LinkedList<LspLocalLabelInfo> lspLocalLabelInfoList1 = new LinkedList<LspLocalLabelInfo>();
        TunnelConsumerId tunnelConsumerId1 = TunnelConsumerId.valueOf((long)10L);
        DeviceId deviceId1 = DeviceId.deviceId((String)"foo");
        LabelResourceId inLabelId1 = LabelResourceId.labelResourceId((long)1L);
        LabelResourceId outLabelId1 = LabelResourceId.labelResourceId((long)2L);
        LspLocalLabelInfo lspLocalLabel1 = DefaultLspLocalLabelInfo.builder().deviceId(deviceId1).inLabelId(inLabelId1).outLabelId(outLabelId1).build();
        lspLocalLabelInfoList1.add(lspLocalLabel1);
        this.pceccTunnelInfo1 = new PceccTunnelInfo(lspLocalLabelInfoList1, (ResourceConsumer)tunnelConsumerId1);
        LinkedList<LspLocalLabelInfo> lspLocalLabelInfoList2 = new LinkedList<LspLocalLabelInfo>();
        TunnelConsumerId tunnelConsumerId2 = TunnelConsumerId.valueOf((long)20L);
        DeviceId deviceId2 = DeviceId.deviceId((String)"foo");
        LabelResourceId inLabelId2 = LabelResourceId.labelResourceId((long)3L);
        LabelResourceId outLabelId2 = LabelResourceId.labelResourceId((long)4L);
        LspLocalLabelInfo lspLocalLabel2 = DefaultLspLocalLabelInfo.builder().deviceId(deviceId2).inLabelId(inLabelId2).outLabelId(outLabelId2).build();
        lspLocalLabelInfoList2.add(lspLocalLabel2);
        this.pceccTunnelInfo2 = new PceccTunnelInfo(lspLocalLabelInfoList2, (ResourceConsumer)tunnelConsumerId2);
        DeviceId src1 = DeviceId.deviceId((String)"foo1");
        DeviceId dst1 = DeviceId.deviceId((String)"goo1");
        String name1 = "pcc1";
        LspType lspType1 = LspType.SR_WITHOUT_SIGNALLING;
        LinkedList<BandwidthConstraint> constraints1 = new LinkedList<BandwidthConstraint>();
        BandwidthConstraint bandwidth1 = BandwidthConstraint.of((double)200.0, (DataRateUnit)DataRateUnit.BPS);
        constraints1.add(bandwidth1);
        this.failedPathInfo1 = new PcePathInfo(src1, dst1, name1, constraints1, lspType1);
        DeviceId src2 = DeviceId.deviceId((String)"foo2");
        DeviceId dst2 = DeviceId.deviceId((String)"goo2");
        String name2 = "pcc2";
        LspType lspType2 = LspType.SR_WITHOUT_SIGNALLING;
        LinkedList<BandwidthConstraint> constraints2 = new LinkedList<BandwidthConstraint>();
        BandwidthConstraint bandwidth2 = BandwidthConstraint.of((double)400.0, (DataRateUnit)DataRateUnit.BPS);
        constraints2.add(bandwidth2);
        this.failedPathInfo2 = new PcePathInfo(src2, dst2, name2, constraints2, lspType2);
        DeviceId src3 = DeviceId.deviceId((String)"foo3");
        DeviceId dst3 = DeviceId.deviceId((String)"goo3");
        String name3 = "pcc3";
        LspType lspType3 = LspType.SR_WITHOUT_SIGNALLING;
        LinkedList<BandwidthConstraint> constraints3 = new LinkedList<BandwidthConstraint>();
        BandwidthConstraint bandwidth3 = BandwidthConstraint.of((double)500.0, (DataRateUnit)DataRateUnit.BPS);
        constraints3.add(bandwidth3);
        this.failedPathInfo3 = new PcePathInfo(src3, dst3, name3, constraints3, lspType3);
        DeviceId src4 = DeviceId.deviceId((String)"foo4");
        DeviceId dst4 = DeviceId.deviceId((String)"goo4");
        String name4 = "pcc4";
        LspType lspType4 = LspType.SR_WITHOUT_SIGNALLING;
        LinkedList<BandwidthConstraint> constraints4 = new LinkedList<BandwidthConstraint>();
        BandwidthConstraint bandwidth4 = BandwidthConstraint.of((double)600.0, (DataRateUnit)DataRateUnit.BPS);
        constraints4.add(bandwidth4);
        this.failedPathInfo4 = new PcePathInfo(src4, dst4, name4, constraints4, lspType4);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testAddGlobalNodeLabel() {
        this.distrPceStore.storageService = new TestStorageService();
        this.distrPceStore.activate();
        this.distrPceStore.addGlobalNodeLabel(this.deviceId1, this.labelId1);
        MatcherAssert.assertThat((Object)this.distrPceStore.existsGlobalNodeLabel(this.deviceId1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.getGlobalNodeLabel(this.deviceId1), (Matcher)Matchers.is((Object)this.labelId1));
        this.distrPceStore.addGlobalNodeLabel(this.deviceId2, this.labelId2);
        MatcherAssert.assertThat((Object)this.distrPceStore.existsGlobalNodeLabel(this.deviceId2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.getGlobalNodeLabel(this.deviceId2), (Matcher)Matchers.is((Object)this.labelId2));
    }

    @Test
    public void testAddAdjLabel() {
        this.distrPceStore.storageService = new TestStorageService();
        this.distrPceStore.activate();
        this.distrPceStore.addAdjLabel(this.link1, this.labelId1);
        MatcherAssert.assertThat((Object)this.distrPceStore.existsAdjLabel(this.link1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.getAdjLabel(this.link1), (Matcher)Matchers.is((Object)this.labelId1));
        this.distrPceStore.addAdjLabel(this.link2, this.labelId2);
        MatcherAssert.assertThat((Object)this.distrPceStore.existsAdjLabel(this.link2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.getAdjLabel(this.link2), (Matcher)Matchers.is((Object)this.labelId2));
    }

    @Test
    public void testAddTunnelInfo() {
        this.distrPceStore.storageService = new TestStorageService();
        this.distrPceStore.activate();
        this.distrPceStore.addTunnelInfo(this.tunnelId1, this.pceccTunnelInfo1);
        MatcherAssert.assertThat((Object)this.distrPceStore.existsTunnelInfo(this.tunnelId1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.getTunnelInfo(this.tunnelId1), (Matcher)Matchers.is((Object)this.pceccTunnelInfo1));
        this.distrPceStore.addTunnelInfo(this.tunnelId2, this.pceccTunnelInfo2);
        MatcherAssert.assertThat((Object)this.distrPceStore.existsTunnelInfo(this.tunnelId2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.getTunnelInfo(this.tunnelId2), (Matcher)Matchers.is((Object)this.pceccTunnelInfo2));
    }

    @Test
    public void testAddFailedPathInfo() {
        this.distrPceStore.storageService = new TestStorageService();
        this.distrPceStore.activate();
        this.distrPceStore.addFailedPathInfo(this.failedPathInfo1);
        MatcherAssert.assertThat((Object)this.distrPceStore.existsFailedPathInfo(this.failedPathInfo1), (Matcher)Matchers.is((Object)true));
        this.distrPceStore.addFailedPathInfo(this.failedPathInfo2);
        MatcherAssert.assertThat((Object)this.distrPceStore.existsFailedPathInfo(this.failedPathInfo2), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testExistsGlobalNodeLabel() {
        this.testAddGlobalNodeLabel();
        MatcherAssert.assertThat((Object)this.distrPceStore.existsGlobalNodeLabel(this.deviceId1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.existsGlobalNodeLabel(this.deviceId2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.existsGlobalNodeLabel(this.deviceId3), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.distrPceStore.existsGlobalNodeLabel(this.deviceId4), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testExistsAdjLabel() {
        this.testAddAdjLabel();
        MatcherAssert.assertThat((Object)this.distrPceStore.existsAdjLabel(this.link1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.existsAdjLabel(this.link2), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testExistsTunnelInfo() {
        this.testAddTunnelInfo();
        MatcherAssert.assertThat((Object)this.distrPceStore.existsTunnelInfo(this.tunnelId1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.existsTunnelInfo(this.tunnelId2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.existsTunnelInfo(this.tunnelId3), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.distrPceStore.existsTunnelInfo(this.tunnelId4), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testExistsFailedPathInfo() {
        this.testAddFailedPathInfo();
        MatcherAssert.assertThat((Object)this.distrPceStore.existsFailedPathInfo(this.failedPathInfo1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.existsFailedPathInfo(this.failedPathInfo2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.existsFailedPathInfo(this.failedPathInfo3), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.distrPceStore.existsFailedPathInfo(this.failedPathInfo4), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testGetGlobalNodeLabelCount() {
        this.testAddGlobalNodeLabel();
        MatcherAssert.assertThat((Object)this.distrPceStore.getGlobalNodeLabelCount(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetAdjLabelCount() {
        this.testAddAdjLabel();
        MatcherAssert.assertThat((Object)this.distrPceStore.getAdjLabelCount(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetTunnelInfoCount() {
        this.testAddTunnelInfo();
        MatcherAssert.assertThat((Object)this.distrPceStore.getTunnelInfoCount(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetFailedPathInfoCount() {
        this.testAddFailedPathInfo();
        MatcherAssert.assertThat((Object)this.distrPceStore.getFailedPathInfoCount(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetGlobalNodeLabels() {
        this.testAddGlobalNodeLabel();
        Map nodeLabelMap = this.distrPceStore.getGlobalNodeLabels();
        MatcherAssert.assertThat((Object)nodeLabelMap, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)nodeLabelMap.isEmpty(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)nodeLabelMap.size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetAdjLabels() {
        this.testAddAdjLabel();
        Map adjLabelMap = this.distrPceStore.getAdjLabels();
        MatcherAssert.assertThat((Object)adjLabelMap, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)adjLabelMap.isEmpty(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)adjLabelMap.size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetTunnelInfos() {
        this.testAddTunnelInfo();
        Map tunnelInfoMap = this.distrPceStore.getTunnelInfos();
        MatcherAssert.assertThat((Object)tunnelInfoMap, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)tunnelInfoMap.isEmpty(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)tunnelInfoMap.size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetFailedPathInfos() {
        this.testAddFailedPathInfo();
        Iterable failedPathInfoSet = this.distrPceStore.getFailedPathInfos();
        MatcherAssert.assertThat((Object)failedPathInfoSet, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)failedPathInfoSet.iterator().hasNext(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetGlobalNodeLabel() {
        this.testAddGlobalNodeLabel();
        MatcherAssert.assertThat((Object)this.deviceId1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.distrPceStore.getGlobalNodeLabel(this.deviceId1), (Matcher)Matchers.is((Object)this.labelId1));
        MatcherAssert.assertThat((Object)this.deviceId2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.distrPceStore.getGlobalNodeLabel(this.deviceId2), (Matcher)Matchers.is((Object)this.labelId2));
    }

    @Test
    public void testGetAdjLabel() {
        this.testAddAdjLabel();
        MatcherAssert.assertThat((Object)this.link1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.distrPceStore.getAdjLabel(this.link1), (Matcher)Matchers.is((Object)this.labelId1));
        MatcherAssert.assertThat((Object)this.link2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.distrPceStore.getAdjLabel(this.link2), (Matcher)Matchers.is((Object)this.labelId2));
    }

    @Test
    public void testGetTunnelInfo() {
        this.testAddTunnelInfo();
        MatcherAssert.assertThat((Object)this.tunnelId1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.distrPceStore.getTunnelInfo(this.tunnelId1), (Matcher)Matchers.is((Object)this.pceccTunnelInfo1));
        MatcherAssert.assertThat((Object)this.tunnelId2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.distrPceStore.getTunnelInfo(this.tunnelId2), (Matcher)Matchers.is((Object)this.pceccTunnelInfo2));
    }

    @Test
    public void testUpdateTunnelInfo() {
        this.testAddTunnelInfo();
        LinkedList<LspLocalLabelInfo> lspLocalLabelInfoList3 = new LinkedList<LspLocalLabelInfo>();
        TunnelConsumerId tunnelConsumerId3 = TunnelConsumerId.valueOf((long)30L);
        DeviceId deviceId3 = DeviceId.deviceId((String)"goo");
        LabelResourceId inLabelId3 = LabelResourceId.labelResourceId((long)3L);
        LabelResourceId outLabelId3 = LabelResourceId.labelResourceId((long)4L);
        LspLocalLabelInfo lspLocalLabel3 = DefaultLspLocalLabelInfo.builder().deviceId(deviceId3).inLabelId(inLabelId3).outLabelId(outLabelId3).build();
        lspLocalLabelInfoList3.add(lspLocalLabel3);
        PceccTunnelInfo pceccTunnelInfo3 = new PceccTunnelInfo(lspLocalLabelInfoList3, (ResourceConsumer)tunnelConsumerId3);
        LinkedList<LspLocalLabelInfo> lspLocalLabelInfoList4 = new LinkedList<LspLocalLabelInfo>();
        TunnelConsumerId tunnelConsumerId4 = TunnelConsumerId.valueOf((long)40L);
        DeviceId deviceId4 = DeviceId.deviceId((String)"goo");
        LabelResourceId inLabelId4 = LabelResourceId.labelResourceId((long)4L);
        LabelResourceId outLabelId4 = LabelResourceId.labelResourceId((long)5L);
        LspLocalLabelInfo lspLocalLabel4 = DefaultLspLocalLabelInfo.builder().deviceId(deviceId4).inLabelId(inLabelId4).outLabelId(outLabelId4).build();
        lspLocalLabelInfoList4.add(lspLocalLabel4);
        PceccTunnelInfo pceccTunnelInfo4 = new PceccTunnelInfo(lspLocalLabelInfoList4, (ResourceConsumer)tunnelConsumerId4);
        MatcherAssert.assertThat((Object)this.distrPceStore.updateTunnelInfo(this.tunnelId1, lspLocalLabelInfoList3), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.updateTunnelInfo(this.tunnelId2, lspLocalLabelInfoList4), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.updateTunnelInfo(this.tunnelId1, (ResourceConsumer)tunnelConsumerId3), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.updateTunnelInfo(this.tunnelId2, (ResourceConsumer)tunnelConsumerId4), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.getTunnelInfo(this.tunnelId1), (Matcher)Matchers.is((Object)pceccTunnelInfo3));
        MatcherAssert.assertThat((Object)this.distrPceStore.getTunnelInfo(this.tunnelId2), (Matcher)Matchers.is((Object)pceccTunnelInfo4));
    }

    @Test
    public void testRemoveGlobalNodeLabel() {
        this.testAddGlobalNodeLabel();
        MatcherAssert.assertThat((Object)this.distrPceStore.removeGlobalNodeLabel(this.deviceId1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.removeGlobalNodeLabel(this.deviceId2), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testRemoveAdjLabel() {
        this.testAddAdjLabel();
        MatcherAssert.assertThat((Object)this.distrPceStore.removeAdjLabel(this.link1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.removeAdjLabel(this.link2), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testRemoveTunnelInfo() {
        this.testAddTunnelInfo();
        MatcherAssert.assertThat((Object)this.distrPceStore.removeTunnelInfo(this.tunnelId1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.removeTunnelInfo(this.tunnelId2), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testRemoveFailedPathInfo() {
        this.testAddFailedPathInfo();
        MatcherAssert.assertThat((Object)this.distrPceStore.removeFailedPathInfo(this.failedPathInfo1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.removeFailedPathInfo(this.failedPathInfo2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.distrPceStore.removeFailedPathInfo(this.failedPathInfo3), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.distrPceStore.removeFailedPathInfo(this.failedPathInfo4), (Matcher)Matchers.is((Object)false));
    }
}

