/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pcestore;

import com.google.common.testing.EqualsTester;
import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.util.DataRateUnit;
import org.onosproject.net.DeviceId;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.pce.pceservice.LspType;
import org.onosproject.pce.pcestore.PcePathInfo;

public class PcePathInfoTest {
    @Test
    public void testEquals() {
        DeviceId src1 = DeviceId.deviceId((String)"foo1");
        DeviceId dst1 = DeviceId.deviceId((String)"goo1");
        String name1 = "pcc1";
        LspType lspType1 = LspType.WITH_SIGNALLING;
        LinkedList<BandwidthConstraint> constraints1 = new LinkedList<BandwidthConstraint>();
        BandwidthConstraint bandwidth11 = BandwidthConstraint.of((double)100.0, (DataRateUnit)DataRateUnit.BPS);
        constraints1.add(bandwidth11);
        BandwidthConstraint bandwidth12 = BandwidthConstraint.of((double)200.0, (DataRateUnit)DataRateUnit.BPS);
        constraints1.add(bandwidth12);
        BandwidthConstraint bandwidth13 = BandwidthConstraint.of((double)300.0, (DataRateUnit)DataRateUnit.BPS);
        constraints1.add(bandwidth13);
        PcePathInfo pathInfo1 = new PcePathInfo(src1, dst1, name1, constraints1, lspType1);
        PcePathInfo samePathInfo1 = new PcePathInfo(src1, dst1, name1, constraints1, lspType1);
        DeviceId src2 = DeviceId.deviceId((String)"foo2");
        DeviceId dst2 = DeviceId.deviceId((String)"goo2");
        String name2 = "pcc2";
        LspType lspType2 = LspType.SR_WITHOUT_SIGNALLING;
        LinkedList<BandwidthConstraint> constraints2 = new LinkedList<BandwidthConstraint>();
        BandwidthConstraint bandwidth21 = BandwidthConstraint.of((double)400.0, (DataRateUnit)DataRateUnit.BPS);
        constraints2.add(bandwidth21);
        BandwidthConstraint bandwidth22 = BandwidthConstraint.of((double)800.0, (DataRateUnit)DataRateUnit.BPS);
        constraints2.add(bandwidth22);
        PcePathInfo pathInfo2 = new PcePathInfo(src2, dst2, name2, constraints2, lspType2);
        new EqualsTester().addEqualityGroup(new Object[]{pathInfo1, samePathInfo1}).addEqualityGroup(new Object[]{pathInfo2}).testEquals();
    }

    @Test
    public void testConstruction() {
        DeviceId src = DeviceId.deviceId((String)"foo2");
        DeviceId dst = DeviceId.deviceId((String)"goo2");
        String name = "pcc2";
        LspType lspType = LspType.SR_WITHOUT_SIGNALLING;
        LinkedList<BandwidthConstraint> constraints = new LinkedList<BandwidthConstraint>();
        BandwidthConstraint bandwidth1 = BandwidthConstraint.of((double)100.0, (DataRateUnit)DataRateUnit.BPS);
        constraints.add(bandwidth1);
        BandwidthConstraint bandwidth2 = BandwidthConstraint.of((double)200.0, (DataRateUnit)DataRateUnit.BPS);
        constraints.add(bandwidth2);
        BandwidthConstraint bandwidth3 = BandwidthConstraint.of((double)300.0, (DataRateUnit)DataRateUnit.BPS);
        constraints.add(bandwidth3);
        PcePathInfo pathInfo = new PcePathInfo(src, dst, name, constraints, lspType);
        MatcherAssert.assertThat((Object)src, (Matcher)Matchers.is((Object)pathInfo.src()));
        MatcherAssert.assertThat((Object)dst, (Matcher)Matchers.is((Object)pathInfo.dst()));
        MatcherAssert.assertThat((Object)name, (Matcher)Matchers.is((Object)pathInfo.name()));
        MatcherAssert.assertThat(constraints, (Matcher)Matchers.is((Object)pathInfo.constraints()));
        MatcherAssert.assertThat((Object)lspType, (Matcher)Matchers.is((Object)pathInfo.lspType()));
    }
}

