/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.util.DataRateUnit;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.pce.pceservice.PcePath;
import org.onosproject.pce.pceservice.constraint.CostConstraint;
import org.onosproject.pce.rest.MockPceCodecContext;

public class PcePathCodecTest {
    MockPceCodecContext context;
    JsonCodec<PcePath> pcePathCodec;

    @Before
    public void setUp() {
        this.context = new MockPceCodecContext();
        this.pcePathCodec = this.context.codec(PcePath.class);
        MatcherAssert.assertThat(this.pcePathCodec, (Matcher)Matchers.notNullValue());
    }

    private PcePath getPcePath(String resourceName) throws IOException {
        InputStream jsonStream = PcePathCodecTest.class.getResourceAsStream(resourceName);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(jsonStream);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.notNullValue());
        PcePath pcePath = (PcePath)this.pcePathCodec.decode((ObjectNode)json, (CodecContext)this.context);
        MatcherAssert.assertThat((Object)pcePath, (Matcher)Matchers.notNullValue());
        return pcePath;
    }

    @Test
    public void codecPcePathTest() throws IOException {
        PcePath pcePath = this.getPcePath("pcePath.json");
        MatcherAssert.assertThat((Object)pcePath, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)pcePath.source().toString(), (Matcher)Matchers.is((Object)"11.0.0.1"));
        MatcherAssert.assertThat((Object)pcePath.destination(), (Matcher)Matchers.is((Object)"11.0.0.2"));
        MatcherAssert.assertThat((Object)pcePath.lspType().toString(), (Matcher)Matchers.is((Object)"WITHOUT_SIGNALLING_AND_WITHOUT_SR"));
        String cost = "2";
        CostConstraint costConstraint = CostConstraint.of((CostConstraint.Type)CostConstraint.Type.values()[Integer.valueOf(cost) - 1]);
        MatcherAssert.assertThat((Object)pcePath.costConstraint(), (Matcher)Matchers.is((Object)costConstraint));
        String bandwidth = "200";
        BandwidthConstraint bandwidthConstraint = BandwidthConstraint.of((double)Double.valueOf(bandwidth), (DataRateUnit)DataRateUnit.valueOf((String)"BPS"));
        MatcherAssert.assertThat((Object)pcePath.bandwidthConstraint(), (Matcher)Matchers.is((Object)bandwidthConstraint));
    }
}

