/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.rest;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.packet.IpAddress;
import org.onlab.rest.BaseResource;
import org.onosproject.codec.CodecService;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.incubator.net.tunnel.DefaultTunnel;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.pce.pceservice.LspType;
import org.onosproject.pce.pceservice.api.PceService;
import org.onosproject.pce.rest.MockPceCodecContext;
import org.onosproject.pce.rest.PceResourceTest;

public class PcePathResourceTest
extends PceResourceTest {
    private final PceService pceService = (PceService)EasyMock.createMock(PceService.class);
    private final TunnelEndPoint src = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((int)23423));
    private final TunnelEndPoint dst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((int)32421));
    private final DefaultGroupId groupId = new DefaultGroupId(92034);
    private final TunnelName tunnelName = TunnelName.tunnelName((String)"TunnelName");
    private final TunnelId tunnelId = TunnelId.valueOf((String)"41654654");
    private final ProviderId producerName = new ProviderId("producer1", "13");
    private Path path;
    private Tunnel tunnel;
    private DeviceId deviceId1;
    private DeviceId deviceId2;
    private DeviceId deviceId3;
    private DeviceId deviceId4;
    private DeviceId deviceId5;
    private PortNumber port1;
    private PortNumber port2;
    private PortNumber port3;
    private PortNumber port4;
    private PortNumber port5;

    @Before
    public void setUpTest() {
        MockPceCodecContext context = new MockPceCodecContext();
        TestServiceDirectory testDirectory = new TestServiceDirectory().add(PceService.class, (Object)this.pceService).add(CodecService.class, (Object)context.codecManager());
        BaseResource.setServiceDirectory((ServiceDirectory)testDirectory);
        ProviderId providerId = new ProviderId("of", "foo");
        this.deviceId1 = DeviceId.deviceId((String)"of:A");
        this.deviceId2 = DeviceId.deviceId((String)"of:B");
        this.deviceId3 = DeviceId.deviceId((String)"of:C");
        this.deviceId4 = DeviceId.deviceId((String)"of:D");
        this.deviceId5 = DeviceId.deviceId((String)"of:E");
        this.port1 = PortNumber.portNumber((long)1L);
        this.port2 = PortNumber.portNumber((long)2L);
        this.port3 = PortNumber.portNumber((long)3L);
        this.port4 = PortNumber.portNumber((long)4L);
        this.port5 = PortNumber.portNumber((long)5L);
        LinkedList<DefaultLink> linkList = new LinkedList<DefaultLink>();
        DefaultLink l1 = DefaultLink.builder().providerId(providerId).annotations((Annotations)DefaultAnnotations.builder().set("key1", "yahoo").build()).src(new ConnectPoint((ElementId)this.deviceId1, this.port1)).dst(new ConnectPoint((ElementId)this.deviceId2, this.port2)).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
        linkList.add(l1);
        DefaultLink l2 = DefaultLink.builder().providerId(providerId).annotations((Annotations)DefaultAnnotations.builder().set("key2", "yahoo").build()).src(new ConnectPoint((ElementId)this.deviceId2, this.port2)).dst(new ConnectPoint((ElementId)this.deviceId3, this.port3)).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
        linkList.add(l2);
        DefaultLink l3 = DefaultLink.builder().providerId(providerId).annotations((Annotations)DefaultAnnotations.builder().set("key3", "yahoo").build()).src(new ConnectPoint((ElementId)this.deviceId3, this.port3)).dst(new ConnectPoint((ElementId)this.deviceId4, this.port4)).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
        linkList.add(l3);
        DefaultLink l4 = DefaultLink.builder().providerId(providerId).annotations((Annotations)DefaultAnnotations.builder().set("key4", "yahoo").build()).src(new ConnectPoint((ElementId)this.deviceId4, this.port4)).dst(new ConnectPoint((ElementId)this.deviceId5, this.port5)).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
        linkList.add(l4);
        this.path = new DefaultPath(providerId, linkList, 10.0, new Annotations[0]);
        DefaultAnnotations.Builder builderAnn = DefaultAnnotations.builder();
        builderAnn.set("lspSigType", "2");
        builderAnn.set("costType", "2");
        builderAnn.set("bandwidth", "200");
        this.tunnel = new DefaultTunnel(this.producerName, this.src, this.dst, Tunnel.Type.VXLAN, Tunnel.State.ACTIVE, this.groupId, this.tunnelId, this.tunnelName, this.path, new Annotations[]{builderAnn.build()});
    }

    @After
    public void tearDownTest() {
    }

    @Test
    public void testPcePathsEmpty() {
        EasyMock.expect((Object)this.pceService.queryAllPath()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.pceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("path").request().get(String.class);
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Object)"{\"paths\":[]}"));
    }

    @Test
    public void testGetTunnelId() {
        EasyMock.expect((Object)this.pceService.queryPath((TunnelId)EasyMock.anyObject())).andReturn((Object)this.tunnel).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.pceService});
        WebTarget wt = this.target();
        String response = (String)wt.path("path/1").request().get(String.class);
        JsonObject result = Json.parse((String)response).asObject();
        Assert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testBadGet() {
        EasyMock.expect((Object)this.pceService.queryPath((TunnelId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.pceService});
        WebTarget wt = this.target();
        try {
            wt.path("path/1").request().get(String.class);
            Assert.fail((String)"Fetch of non-existent pce path did not throw an exception");
        }
        catch (NotFoundException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"HTTP 404 Not Found"));
        }
    }

    @Test
    public void testPost() {
        EasyMock.expect((Object)this.pceService.setupPath((DeviceId)EasyMock.anyObject(), (DeviceId)EasyMock.anyObject(), (String)EasyMock.anyObject(), (List)EasyMock.anyObject(), (LspType)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.pceService});
        WebTarget wt = this.target();
        InputStream jsonStream = PcePathResourceTest.class.getResourceAsStream("post-PcePath.json");
        Response response = wt.path("path").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void testPut() {
        EasyMock.expect((Object)this.pceService.updatePath((TunnelId)EasyMock.anyObject(), (List)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.pceService});
        WebTarget wt = this.target();
        InputStream jsonStream = PcePathResourceTest.class.getResourceAsStream("post-PcePath.json");
        Response response = wt.path("path/1").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)jsonStream));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void testDelete() {
        EasyMock.expect((Object)this.pceService.releasePath((TunnelId)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.pceService});
        WebTarget wt = this.target();
        String location = "path/1";
        Response deleteResponse = wt.path(location).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        Assert.assertThat((Object)deleteResponse.getStatus(), (Matcher)Matchers.is((Object)200));
    }
}

