/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.util;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.pce.pcestore.PcePathInfo;
import org.onosproject.pce.pcestore.PceccTunnelInfo;
import org.onosproject.pce.pcestore.api.LspLocalLabelInfo;
import org.onosproject.pce.pcestore.api.PceStore;

public class PceStoreAdapter
implements PceStore {
    private ConcurrentMap<DeviceId, LabelResourceId> globalNodeLabelMap = new ConcurrentHashMap<DeviceId, LabelResourceId>();
    private ConcurrentMap<Link, LabelResourceId> adjLabelMap = new ConcurrentHashMap<Link, LabelResourceId>();
    private ConcurrentMap<TunnelId, PceccTunnelInfo> tunnelInfoMap = new ConcurrentHashMap<TunnelId, PceccTunnelInfo>();
    private Set<PcePathInfo> failedPathInfoSet = new HashSet<PcePathInfo>();
    private Map<String, DeviceId> lsrIdDeviceIdMap = new HashMap<String, DeviceId>();

    public boolean existsGlobalNodeLabel(DeviceId id) {
        return this.globalNodeLabelMap.containsKey(id);
    }

    public boolean existsAdjLabel(Link link) {
        return this.adjLabelMap.containsKey(link);
    }

    public boolean existsTunnelInfo(TunnelId tunnelId) {
        return this.tunnelInfoMap.containsKey(tunnelId);
    }

    public boolean existsFailedPathInfo(PcePathInfo pathInfo) {
        return this.failedPathInfoSet.contains(pathInfo);
    }

    public int getGlobalNodeLabelCount() {
        return this.globalNodeLabelMap.size();
    }

    public int getAdjLabelCount() {
        return this.adjLabelMap.size();
    }

    public int getTunnelInfoCount() {
        return this.tunnelInfoMap.size();
    }

    public int getFailedPathInfoCount() {
        return this.failedPathInfoSet.size();
    }

    public Map<DeviceId, LabelResourceId> getGlobalNodeLabels() {
        return this.globalNodeLabelMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (LabelResourceId)e.getValue()));
    }

    public Map<Link, LabelResourceId> getAdjLabels() {
        return this.adjLabelMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (LabelResourceId)e.getValue()));
    }

    public Map<TunnelId, PceccTunnelInfo> getTunnelInfos() {
        return this.tunnelInfoMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (PceccTunnelInfo)e.getValue()));
    }

    public Iterable<PcePathInfo> getFailedPathInfos() {
        return ImmutableSet.copyOf(this.failedPathInfoSet);
    }

    public LabelResourceId getGlobalNodeLabel(DeviceId id) {
        return (LabelResourceId)this.globalNodeLabelMap.get(id);
    }

    public LabelResourceId getAdjLabel(Link link) {
        return (LabelResourceId)this.adjLabelMap.get(link);
    }

    public PceccTunnelInfo getTunnelInfo(TunnelId tunnelId) {
        return (PceccTunnelInfo)this.tunnelInfoMap.get(tunnelId);
    }

    public void addGlobalNodeLabel(DeviceId deviceId, LabelResourceId labelId) {
        this.globalNodeLabelMap.put(deviceId, labelId);
    }

    public void addAdjLabel(Link link, LabelResourceId labelId) {
        this.adjLabelMap.put(link, labelId);
    }

    public void addTunnelInfo(TunnelId tunnelId, PceccTunnelInfo pceccTunnelInfo) {
        this.tunnelInfoMap.put(tunnelId, pceccTunnelInfo);
    }

    public void addFailedPathInfo(PcePathInfo pathInfo) {
        this.failedPathInfoSet.add(pathInfo);
    }

    public boolean updateTunnelInfo(TunnelId tunnelId, List<LspLocalLabelInfo> lspLocalLabelInfoList) {
        if (!this.tunnelInfoMap.containsKey(tunnelId)) {
            return false;
        }
        PceccTunnelInfo labelStoreInfo = (PceccTunnelInfo)this.tunnelInfoMap.get(tunnelId);
        labelStoreInfo.lspLocalLabelInfoList(lspLocalLabelInfoList);
        this.tunnelInfoMap.put(tunnelId, labelStoreInfo);
        return true;
    }

    public boolean updateTunnelInfo(TunnelId tunnelId, ResourceConsumer tunnelConsumerId) {
        if (!this.tunnelInfoMap.containsKey(tunnelId)) {
            return false;
        }
        PceccTunnelInfo tunnelInfo = (PceccTunnelInfo)this.tunnelInfoMap.get(tunnelId);
        tunnelInfo.tunnelConsumerId(tunnelConsumerId);
        this.tunnelInfoMap.put(tunnelId, tunnelInfo);
        return true;
    }

    public boolean removeGlobalNodeLabel(DeviceId id) {
        this.globalNodeLabelMap.remove(id);
        return !this.globalNodeLabelMap.containsKey(id);
    }

    public boolean removeAdjLabel(Link link) {
        this.adjLabelMap.remove(link);
        return !this.adjLabelMap.containsKey(link);
    }

    public boolean removeTunnelInfo(TunnelId tunnelId) {
        this.tunnelInfoMap.remove(tunnelId);
        return !this.tunnelInfoMap.containsKey(tunnelId);
    }

    public boolean removeFailedPathInfo(PcePathInfo pathInfo) {
        return !this.failedPathInfoSet.remove(pathInfo);
    }

    public boolean addLsrIdDevice(String lsrId, DeviceId deviceId) {
        this.lsrIdDeviceIdMap.put(lsrId, deviceId);
        return true;
    }

    public boolean removeLsrIdDevice(String lsrId) {
        this.lsrIdDeviceIdMap.remove(lsrId);
        return true;
    }

    public DeviceId getLsrIdDevice(String lsrId) {
        return this.lsrIdDeviceIdMap.get(lsrId);
    }

    public boolean addPccLsr(DeviceId lsrId) {
        return false;
    }

    public boolean removePccLsr(DeviceId lsrId) {
        return false;
    }

    public boolean hasPccLsr(DeviceId lsrId) {
        return false;
    }
}

