/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.cli;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.util.DataRateUnit;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.pce.pceservice.LspType;
import org.onosproject.pce.pceservice.api.PceService;
import org.onosproject.pce.pceservice.constraint.CostConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="onos", name="pce-setup-path", description="Supports creating pce path.")
public class PceSetupPathCommand
extends AbstractShellCommand {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Argument(index=0, name="src", description="source device.", required=true, multiValued=false)
    String src = null;
    @Argument(index=1, name="dst", description="destination device.", required=true, multiValued=false)
    String dst = null;
    @Argument(index=2, name="type", description="LSP type: It includes PCE tunnel with signalling in network (0), PCE tunnel without signalling in network with segment routing (1), PCE tunnel without signalling in network (2).", required=true, multiValued=false)
    int type = 0;
    @Argument(index=3, name="name", description="symbolic-path-name.", required=true, multiValued=false)
    String name = null;
    @Option(name="-c", aliases={"--cost"}, description="The cost attribute IGP cost(1) or TE cost(2)", required=false, multiValued=false)
    int cost = 2;
    @Option(name="-b", aliases={"--bandwidth"}, description="The bandwidth attribute of path. Data rate unit is in BPS.", required=false, multiValued=false)
    double bandwidth = 0.0;

    protected void execute() {
        this.log.info("executing pce-setup-path");
        PceService service = (PceService)PceSetupPathCommand.get(PceService.class);
        TunnelService tunnelService = (TunnelService)PceSetupPathCommand.get(TunnelService.class);
        DeviceId srcDevice = DeviceId.deviceId((String)this.src);
        DeviceId dstDevice = DeviceId.deviceId((String)this.dst);
        LinkedList<Constraint> listConstrnt = new LinkedList<Constraint>();
        if (this.type < 0 || this.type > 2) {
            this.error("The LSP type value can be PCE tunnel with signalling in network (0), PCE tunnel without signalling in network with segment routing (1), PCE tunnel without signalling in network (2).", new Object[0]);
            return;
        }
        LspType lspType = LspType.values()[this.type];
        Collection existingTunnels = tunnelService.queryTunnel(Tunnel.Type.MPLS);
        for (Tunnel t : existingTunnels) {
            if (!t.tunnelName().toString().equals(this.name)) continue;
            this.error("Path creation failed, Tunnel name already exists", new Object[0]);
            return;
        }
        if (this.bandwidth != 0.0) {
            listConstrnt.add((Constraint)BandwidthConstraint.of((double)this.bandwidth, (DataRateUnit)DataRateUnit.valueOf((String)"BPS")));
        }
        if (this.cost < 1 || this.cost > 2) {
            this.error("The cost attribute value either IGP cost(1) or TE cost(2).", new Object[0]);
            return;
        }
        CostConstraint.Type costType = CostConstraint.Type.values()[this.cost - 1];
        listConstrnt.add(CostConstraint.of(costType));
        if (!service.setupPath(srcDevice, dstDevice, this.name, listConstrnt, lspType)) {
            this.error("Path creation failed.", new Object[0]);
        }
    }
}

