/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.cli;

import java.util.LinkedList;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.util.DataRateUnit;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.pce.pceservice.api.PceService;
import org.onosproject.pce.pceservice.constraint.CostConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="onos", name="pce-update-path", description="Supports updating PCE path.")
public class PceUpdatePathCommand
extends AbstractShellCommand {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Argument(index=0, name="id", description="Path Id.", required=true, multiValued=false)
    String id = null;
    @Option(name="-c", aliases={"--cost"}, description="The cost attribute IGP cost (1) or TE cost (2).", required=false, multiValued=false)
    int cost = 0;
    @Option(name="-b", aliases={"--bandwidth"}, description="The bandwidth attribute of path. Data rate unit is in Bps.", required=false, multiValued=false)
    double bandwidth = 0.0;

    protected void execute() {
        this.log.info("executing pce-update-path");
        PceService service = (PceService)PceUpdatePathCommand.get(PceService.class);
        LinkedList<Constraint> constrntList = new LinkedList<Constraint>();
        if (this.bandwidth != 0.0) {
            constrntList.add((Constraint)BandwidthConstraint.of((double)this.bandwidth, (DataRateUnit)DataRateUnit.valueOf((String)"BPS")));
        }
        if (this.cost != 0) {
            if (this.cost < 1 || this.cost > 2) {
                this.error("The cost attribute value is either IGP cost(1) or TE cost(2).", new Object[0]);
                return;
            }
            CostConstraint.Type costType = CostConstraint.Type.values()[this.cost - 1];
            constrntList.add(CostConstraint.of(costType));
        }
        if (!service.updatePath(TunnelId.valueOf((String)this.id), constrntList)) {
            this.error("Path updation failed.", new Object[0]);
            return;
        }
    }
}

