/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.onlab.packet.MplsLabel;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.resource.label.DefaultLabelResource;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.resource.label.LabelResourceService;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.pce.pceservice.LabelType;
import org.onosproject.pce.pcestore.DefaultLspLocalLabelInfo;
import org.onosproject.pce.pcestore.PceccTunnelInfo;
import org.onosproject.pce.pcestore.api.LspLocalLabelInfo;
import org.onosproject.pce.pcestore.api.PceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicPceccHandler {
    private static final Logger log = LoggerFactory.getLogger(BasicPceccHandler.class);
    private static final String LABEL_RESOURCE_SERVICE_NULL = "Label Resource Service cannot be null";
    private static final String PCE_STORE_NULL = "PCE Store cannot be null";
    private static BasicPceccHandler crHandlerInstance = null;
    private LabelResourceService labelRsrcService;
    private PceStore pceStore;
    private FlowObjectiveService flowObjectiveService;
    private ApplicationId appId;

    private BasicPceccHandler() {
    }

    public static BasicPceccHandler getInstance() {
        if (crHandlerInstance == null) {
            crHandlerInstance = new BasicPceccHandler();
        }
        return crHandlerInstance;
    }

    public void initialize(LabelResourceService labelRsrcService, FlowObjectiveService flowObjectiveService, ApplicationId appId, PceStore pceStore) {
        this.labelRsrcService = labelRsrcService;
        this.flowObjectiveService = flowObjectiveService;
        this.appId = appId;
        this.pceStore = pceStore;
    }

    public boolean allocateLabel(Tunnel tunnel) {
        long applyNum = 1L;
        boolean isLastLabelToPush = false;
        Preconditions.checkNotNull((Object)this.labelRsrcService, (Object)LABEL_RESOURCE_SERVICE_NULL);
        Preconditions.checkNotNull((Object)this.pceStore, (Object)PCE_STORE_NULL);
        List linkList = tunnel.path().links();
        if (linkList != null && linkList.size() > 0) {
            ListIterator iterator = linkList.listIterator(linkList.size());
            while (iterator.hasPrevious()) {
                Link link = (Link)iterator.previous();
                DeviceId dstDeviceId = link.dst().deviceId();
                DeviceId srcDeviceId = link.src().deviceId();
                Collection labelRscList = this.labelRsrcService.applyFromDevicePool(dstDeviceId, applyNum);
                if (labelRscList != null && labelRscList.size() > 0) {
                    Iterator labelIterator = labelRscList.iterator();
                    DefaultLabelResource defaultLabelResource = (DefaultLabelResource)labelIterator.next();
                    LabelResourceId labelId = defaultLabelResource.labelResourceId();
                    log.debug("Allocated local label: " + labelId.toString() + "to device: " + defaultLabelResource.deviceId().toString());
                    PortNumber dstPort = link.dst().port();
                    if (!iterator.hasPrevious()) {
                        isLastLabelToPush = true;
                    }
                    this.installLocalLabelRule(dstDeviceId, labelId, dstPort, tunnel.tunnelId(), false, Long.valueOf(LabelType.IN_LABEL.value), Objective.Operation.ADD);
                    this.installLocalLabelRule(srcDeviceId, labelId, dstPort, tunnel.tunnelId(), isLastLabelToPush, Long.valueOf(LabelType.OUT_LABEL.value), Objective.Operation.ADD);
                    this.updatePceccTunnelInfoInStore(srcDeviceId, dstDeviceId, labelId, dstPort, tunnel, isLastLabelToPush);
                    continue;
                }
                log.error("Unable to allocate label to device id {}.", (Object)dstDeviceId.toString());
                this.releaseLabel(tunnel);
                return false;
            }
        } else {
            log.error("Tunnel {} is having empty links.", (Object)tunnel.toString());
            return false;
        }
        return true;
    }

    public void updatePceccTunnelInfoInStore(DeviceId srcDeviceId, DeviceId dstDeviceId, LabelResourceId labelId, PortNumber dstPort, Tunnel tunnel, boolean isLastLabelToPush) {
        List<LspLocalLabelInfo> lspLabelInfoList;
        boolean dstDeviceUpdated = false;
        boolean srcDeviceUpdated = false;
        PceccTunnelInfo pceccTunnelInfo = this.pceStore.getTunnelInfo(tunnel.tunnelId());
        if (pceccTunnelInfo != null && (lspLabelInfoList = pceccTunnelInfo.lspLocalLabelInfoList()) != null && lspLabelInfoList.size() > 0) {
            for (int i = 0; i < lspLabelInfoList.size(); ++i) {
                LspLocalLabelInfo lspLocalLabelInfo = lspLabelInfoList.get(i);
                DefaultLspLocalLabelInfo.Builder lspLocalLabelInfoBuilder = null;
                if (dstDeviceId.equals((Object)lspLocalLabelInfo.deviceId())) {
                    lspLocalLabelInfoBuilder = DefaultLspLocalLabelInfo.builder(lspLocalLabelInfo);
                    lspLocalLabelInfoBuilder.inLabelId(labelId);
                    lspLocalLabelInfoBuilder.inPort(dstPort);
                    dstDeviceUpdated = true;
                } else if (srcDeviceId.equals((Object)lspLocalLabelInfo.deviceId())) {
                    lspLocalLabelInfoBuilder = DefaultLspLocalLabelInfo.builder(lspLocalLabelInfo);
                    lspLocalLabelInfoBuilder.outLabelId(labelId);
                    lspLocalLabelInfoBuilder.outPort(dstPort);
                    srcDeviceUpdated = true;
                }
                if (lspLocalLabelInfoBuilder == null || !dstDeviceUpdated && !srcDeviceUpdated) continue;
                lspLabelInfoList.set(i, lspLocalLabelInfoBuilder.build());
            }
        }
        if (!dstDeviceUpdated || !srcDeviceUpdated) {
            if (pceccTunnelInfo == null) {
                pceccTunnelInfo = new PceccTunnelInfo();
                lspLabelInfoList = new LinkedList<LspLocalLabelInfo>();
            } else {
                lspLabelInfoList = pceccTunnelInfo.lspLocalLabelInfoList();
                if (lspLabelInfoList == null) {
                    lspLabelInfoList = new LinkedList<LspLocalLabelInfo>();
                }
            }
            if (!dstDeviceUpdated) {
                LspLocalLabelInfo lspLocalLabelInfo = DefaultLspLocalLabelInfo.builder().deviceId(dstDeviceId).inLabelId(labelId).outLabelId(null).inPort(dstPort).outPort(null).build();
                lspLabelInfoList.add(lspLocalLabelInfo);
            }
            if (!srcDeviceUpdated) {
                LspLocalLabelInfo lspLocalLabelInfo = DefaultLspLocalLabelInfo.builder().deviceId(srcDeviceId).inLabelId(null).outLabelId(labelId).inPort(null).outPort(dstPort).build();
                lspLabelInfoList.add(lspLocalLabelInfo);
            }
            pceccTunnelInfo.lspLocalLabelInfoList(lspLabelInfoList);
            this.pceStore.addTunnelInfo(tunnel.tunnelId(), pceccTunnelInfo);
        }
    }

    public void releaseLabel(Tunnel tunnel) {
        boolean isLastLabelToPush = false;
        Preconditions.checkNotNull((Object)this.labelRsrcService, (Object)LABEL_RESOURCE_SERVICE_NULL);
        Preconditions.checkNotNull((Object)this.pceStore, (Object)PCE_STORE_NULL);
        ArrayListMultimap release = ArrayListMultimap.create();
        PceccTunnelInfo pceccTunnelInfo = this.pceStore.getTunnelInfo(tunnel.tunnelId());
        if (pceccTunnelInfo != null) {
            List<LspLocalLabelInfo> lspLocalLabelInfoList = pceccTunnelInfo.lspLocalLabelInfoList();
            if (lspLocalLabelInfoList != null && lspLocalLabelInfoList.size() > 0) {
                Iterator<LspLocalLabelInfo> iterator = lspLocalLabelInfoList.iterator();
                while (iterator.hasNext()) {
                    LspLocalLabelInfo lspLocalLabelInfo = iterator.next();
                    DeviceId deviceId = lspLocalLabelInfo.deviceId();
                    LabelResourceId inLabelId = lspLocalLabelInfo.inLabelId();
                    LabelResourceId outLabelId = lspLocalLabelInfo.outLabelId();
                    PortNumber inPort = lspLocalLabelInfo.inPort();
                    PortNumber outPort = lspLocalLabelInfo.outPort();
                    if (!iterator.hasNext()) {
                        isLastLabelToPush = true;
                    }
                    if (inLabelId != null && inPort != null) {
                        this.installLocalLabelRule(deviceId, inLabelId, inPort, tunnel.tunnelId(), isLastLabelToPush, Long.valueOf(LabelType.IN_LABEL.value), Objective.Operation.REMOVE);
                    }
                    if (outLabelId != null && outPort != null) {
                        this.installLocalLabelRule(deviceId, outLabelId, outPort, tunnel.tunnelId(), isLastLabelToPush, Long.valueOf(LabelType.OUT_LABEL.value), Objective.Operation.REMOVE);
                    }
                    if (!iterator.hasNext() || inLabelId == null) continue;
                    DefaultLabelResource labelRsc = new DefaultLabelResource(deviceId, inLabelId);
                    release.put((Object)deviceId, (Object)labelRsc);
                }
            }
            if (!release.isEmpty()) {
                this.labelRsrcService.releaseToDevicePool((Multimap)release);
            }
            if (pceccTunnelInfo.tunnelConsumerId() == null) {
                this.pceStore.removeTunnelInfo(tunnel.tunnelId());
            }
        } else {
            log.error("Unable to find PCECC tunnel info in store for a tunnel {}.", (Object)tunnel.toString());
        }
    }

    private void installLocalLabelRule(DeviceId deviceId, LabelResourceId labelId, PortNumber portNum, TunnelId tunnelId, Boolean isBos, Long labelType, Objective.Operation type) {
        Preconditions.checkNotNull((Object)this.flowObjectiveService);
        Preconditions.checkNotNull((Object)this.appId);
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchMplsLabel(MplsLabel.mplsLabel((int)((Long)labelId.id()).intValue()));
        selectorBuilder.matchInPort(portNum);
        selectorBuilder.matchTunnelId(Long.parseLong((String)tunnelId.id()));
        selectorBuilder.matchMplsBos(isBos.booleanValue());
        selectorBuilder.matchMetadata(labelType.longValue());
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().build();
        DefaultForwardingObjective.Builder forwardingObjective = DefaultForwardingObjective.builder().withSelector(selectorBuilder.build()).withTreatment(treatment).withFlag(ForwardingObjective.Flag.VERSATILE).fromApp(this.appId).makePermanent();
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.flowObjectiveService.forward(deviceId, forwardingObjective.add());
        } else {
            this.flowObjectiveService.forward(deviceId, forwardingObjective.remove());
        }
    }
}

